/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.db.explorer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverListener;
import org.netbeans.modules.db.explorer.dlg.AddDriverDialog;
import org.netbeans.modules.db.explorer.driver.JDBCDriverConvertor;
import org.netbeans.modules.db.runtime.DatabaseRuntimeManager;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.lookup.Lookups;

public final class JDBCDriverManager {
    private static JDBCDriverManager DEFAULT = null;
    private Lookup.Result<JDBCDriver> result = this.getLookupResult();
    private Set<JDBCDriverListener> listeners = new HashSet<JDBCDriverListener>();

    public static synchronized JDBCDriverManager getDefault() {
        if (DEFAULT == null) {
            DatabaseRuntimeManager.getDefault().getRuntimes();
            JDBCDriverConvertor.importOldDrivers();
            DEFAULT = new JDBCDriverManager();
        }
        return DEFAULT;
    }

    private JDBCDriverManager() {
        this.result.allInstances();
        this.result.addLookupListener(new LookupListener(){

            public void resultChanged(LookupEvent e) {
                JDBCDriverManager.this.fireListeners();
            }
        });
    }

    public JDBCDriver[] getDrivers() {
        Collection drivers = this.result.allInstances();
        return drivers.toArray(new JDBCDriver[drivers.size()]);
    }

    public JDBCDriver[] getDrivers(String drvClass) {
        if (drvClass == null) {
            throw new NullPointerException();
        }
        LinkedList<JDBCDriver> res = new LinkedList<JDBCDriver>();
        JDBCDriver[] drvs = this.getDrivers();
        for (int i = 0; i < drvs.length; ++i) {
            if (!drvClass.equals(drvs[i].getClassName())) continue;
            res.add(drvs[i]);
        }
        return res.toArray(new JDBCDriver[res.size()]);
    }

    public void addDriver(JDBCDriver driver) throws DatabaseException {
        if (driver == null) {
            throw new NullPointerException();
        }
        try {
            JDBCDriverConvertor.create(driver);
        }
        catch (IOException ioe) {
            throw new DatabaseException(ioe);
        }
    }

    public void removeDriver(JDBCDriver driver) throws DatabaseException {
        try {
            JDBCDriverConvertor.remove(driver);
        }
        catch (IOException ioe) {
            throw new DatabaseException(ioe);
        }
    }

    public void showAddDriverDialog() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AddDriverDialog.showDialog();
                }
            });
        } else {
            AddDriverDialog.showDialog();
        }
    }

    public JDBCDriver showAddDriverDialogFromEventThread() {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("The current thread is not the event dispatching thread.");
        }
        return AddDriverDialog.showDialog();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDriverListener(JDBCDriverListener listener) {
        Set<JDBCDriverListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDriverListener(JDBCDriverListener listener) {
        Set<JDBCDriverListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireListeners() {
        ArrayList<JDBCDriverListener> listenersCopy;
        Set<JDBCDriverListener> set = this.listeners;
        synchronized (set) {
            listenersCopy = new ArrayList<JDBCDriverListener>(this.listeners);
        }
        for (JDBCDriverListener listener : listenersCopy) {
            listener.driversChanged();
        }
    }

    private synchronized Lookup.Result<JDBCDriver> getLookupResult() {
        return Lookups.forPath((String)"Databases/JDBCDrivers").lookupResult(JDBCDriver.class);
    }
}

