/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project;

import java.io.File;
import java.util.HashMap;
import java.util.regex.Pattern;
import org.apache.tools.ant.module.spi.AntEvent;
import org.apache.tools.ant.module.spi.AntLogger;
import org.apache.tools.ant.module.spi.AntSession;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class J2MEAntLogger
extends AntLogger {
    private static final String separator = File.separatorChar == '\\' ? "\\\\" : "/";
    private static final Pattern PREPROCESSED = Pattern.compile("^.*" + separator + "build(?:" + separator + "[a-zA-Z_$][a-zA-Z0-9_$]*)?" + separator + "preprocessed" + separator);
    private static final String CHARSTOESCAPE = "([\\\\\\$])";
    private static final String ESCAPESEQUENCE = "\\\\$1";

    public boolean interestedInSession(AntSession session) {
        return session.getVerbosity() < 4;
    }

    public boolean interestedInScript(File script, AntSession session) {
        FileObject projfile = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)script));
        if (projfile == null) {
            return false;
        }
        Project proj = FileOwnerQuery.getOwner((FileObject)projfile);
        if (proj == null) {
            return false;
        }
        AntProjectHelper helper = (AntProjectHelper)proj.getLookup().lookup(AntProjectHelper.class);
        if (helper == null) {
            return false;
        }
        String sourceRoot = helper.getStandardPropertyEvaluator().getProperty("src.dir");
        if (sourceRoot == null) {
            return false;
        }
        File srcRoot = helper.resolveFile(sourceRoot);
        if (srcRoot == null) {
            return false;
        }
        HashMap<File, String> roots = (HashMap<File, String>)session.getCustomData((AntLogger)this);
        if (roots == null) {
            roots = new HashMap<File, String>();
            session.putCustomData((AntLogger)this, roots);
        }
        roots.put(script, srcRoot.getAbsolutePath().replaceAll(CHARSTOESCAPE, ESCAPESEQUENCE) + separator);
        return true;
    }

    public String[] interestedInTargets(AntSession session) {
        return AntLogger.ALL_TARGETS;
    }

    public String[] interestedInTasks(AntSession session) {
        return AntLogger.ALL_TASKS;
    }

    public void messageLogged(AntEvent event) {
        String newMessage;
        String srcRoot;
        if (event.isConsumed()) {
            return;
        }
        Object cd = event.getSession().getCustomData((AntLogger)this);
        if (cd instanceof HashMap) {
            HashMap roots = (HashMap)cd;
            if (roots == null) {
                return;
            }
            srcRoot = (String)roots.get(event.getScriptLocation());
        } else {
            srcRoot = (String)cd;
        }
        if (srcRoot == null) {
            return;
        }
        String message = event.getMessage();
        if (!message.equals(newMessage = PREPROCESSED.matcher(message).replaceFirst(srcRoot))) {
            event.consume();
            event.getSession().deliverMessageLogged(event, newMessage, event.getLogLevel());
        }
    }

    public int[] interestedInLogLevels(AntSession session) {
        return new int[]{3, 2, 1, 0};
    }
}

