/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.java.invokers;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyModule;
import org.jruby.nb.java.invokers.RubyToJavaInvoker;
import org.jruby.nb.javasupport.JavaMethod;

public abstract class MethodInvoker
extends RubyToJavaInvoker {
    private Method[] methods;

    MethodInvoker(RubyModule host, List<Method> methods) {
        super(host);
        this.methods = methods.toArray(new Method[methods.size()]);
        if (!Ruby.isSecurityRestricted()) {
            Method.setAccessible(this.methods, true);
        }
    }

    synchronized void createJavaMethods(Ruby runtime) {
        if (!this.initialized) {
            if (this.methods != null) {
                if (this.methods.length == 1) {
                    this.javaCallable = JavaMethod.create(runtime, this.methods[0]);
                } else {
                    HashMap<Integer, ArrayList<JavaMethod>> methodsMap = new HashMap<Integer, ArrayList<JavaMethod>>();
                    int maxArity = 0;
                    for (Method method : this.methods) {
                        int arity = method.getParameterTypes().length;
                        maxArity = Math.max(arity, maxArity);
                        ArrayList<JavaMethod> methodsForArity = (ArrayList<JavaMethod>)methodsMap.get(arity);
                        if (methodsForArity == null) {
                            methodsForArity = new ArrayList<JavaMethod>();
                            methodsMap.put(arity, methodsForArity);
                        }
                        methodsForArity.add(JavaMethod.create(runtime, method));
                    }
                    this.javaCallables = new JavaMethod[maxArity + 1][];
                    for (Map.Entry entry : methodsMap.entrySet()) {
                        List methodsForArity = (List)entry.getValue();
                        JavaMethod[] methodsArray = methodsForArity.toArray(new JavaMethod[methodsForArity.size()]);
                        this.javaCallables[((Integer)entry.getKey()).intValue()] = methodsArray;
                    }
                }
                this.methods = null;
                this.cache = new ConcurrentHashMap();
            }
            this.initialized = true;
        }
    }
}

