/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.compiler.impl;

import java.util.HashMap;
import java.util.Map;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyFixnum;
import org.jruby.nb.RubySymbol;
import org.jruby.nb.compiler.impl.FieldBasedCacheCompiler;
import org.jruby.nb.compiler.impl.SkinnyMethodAdapter;
import org.jruby.nb.compiler.impl.StandardASMCompiler;
import org.jruby.nb.runtime.CallSite;
import org.jruby.nb.runtime.CallType;
import org.jruby.nb.runtime.MethodIndex;
import org.jruby.nb.util.CodegenUtils;

public class InheritedCacheCompiler
extends FieldBasedCacheCompiler {
    public static final int MAX_INHERITED_CALL_SITES = 50;
    public static final int MAX_INHERITED_SYMBOLS = 50;
    public static final int MAX_INHERITED_FIXNUMS = 50;
    int callSiteCount = 0;
    int inheritedSymbolCount = 0;
    int inheritedFixnumCount = 0;
    Map<String, String> inheritedSymbols = new HashMap<String, String>();
    Map<Long, String> inheritedFixnums = new HashMap<Long, String>();

    public InheritedCacheCompiler(StandardASMCompiler scriptCompiler) {
        super(scriptCompiler);
    }

    @Override
    public void cacheCallSite(StandardASMCompiler.AbstractMethodCompiler method, String name, CallType callType) {
        String fieldName = "site" + this.callSiteCount;
        SkinnyMethodAdapter initMethod = this.scriptCompiler.getInitMethod();
        initMethod.aload(0);
        method.loadThis();
        initMethod.ldc(name);
        if (callType.equals(CallType.NORMAL)) {
            initMethod.invokestatic(CodegenUtils.p(MethodIndex.class), "getCallSite", CodegenUtils.sig(CallSite.class, CodegenUtils.params(String.class)));
        } else if (callType.equals(CallType.FUNCTIONAL)) {
            initMethod.invokestatic(CodegenUtils.p(MethodIndex.class), "getFunctionalCallSite", CodegenUtils.sig(CallSite.class, CodegenUtils.params(String.class)));
        } else if (callType.equals(CallType.VARIABLE)) {
            initMethod.invokestatic(CodegenUtils.p(MethodIndex.class), "getVariableCallSite", CodegenUtils.sig(CallSite.class, CodegenUtils.params(String.class)));
        }
        if (this.callSiteCount >= 50) {
            this.scriptCompiler.getNewField(CodegenUtils.ci(CallSite.class), fieldName, null);
            initMethod.putfield(this.scriptCompiler.getClassname(), fieldName, CodegenUtils.ci(CallSite.class));
            method.method.getfield(this.scriptCompiler.getClassname(), fieldName, CodegenUtils.ci(CallSite.class));
        } else {
            initMethod.putfield(this.scriptCompiler.getClassname(), fieldName, CodegenUtils.ci(CallSite.class));
            method.method.getfield(this.scriptCompiler.getClassname(), fieldName, CodegenUtils.ci(CallSite.class));
        }
        ++this.callSiteCount;
    }

    @Override
    public void cacheSymbol(StandardASMCompiler.AbstractMethodCompiler method, String symbol) {
        String methodName = this.inheritedSymbols.get(symbol);
        if (methodName == null && this.inheritedSymbolCount < 50) {
            methodName = "getSymbol" + this.inheritedSymbolCount++;
            this.inheritedSymbols.put(symbol, methodName);
        }
        if (methodName == null) {
            super.cacheSymbol(method, symbol);
        } else {
            method.loadThis();
            method.loadRuntime();
            method.method.ldc(symbol);
            method.method.invokevirtual(this.scriptCompiler.getClassname(), methodName, CodegenUtils.sig(RubySymbol.class, Ruby.class, String.class));
        }
    }

    @Override
    public void cacheFixnum(StandardASMCompiler.AbstractMethodCompiler method, long value) {
        String methodName = this.inheritedFixnums.get(value);
        if (methodName == null && this.inheritedFixnumCount < 50) {
            methodName = "getFixnum" + this.inheritedFixnumCount++;
            this.inheritedFixnums.put(value, methodName);
        }
        if (methodName == null) {
            super.cacheFixnum(method, value);
        } else {
            method.loadThis();
            method.loadRuntime();
            method.method.ldc(value);
            method.method.invokevirtual(this.scriptCompiler.getClassname(), methodName, CodegenUtils.sig(RubyFixnum.class, Ruby.class, Long.TYPE));
        }
    }
}

