/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.tools.impl;

import java.math.BigDecimal;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public final class SolarisProcfsSupport {
    public static Prusage parsePrusage(String line, Prusage prusage) {
        Prusage proc = prusage == null ? new Prusage() : prusage;
        StringTokenizer t = new StringTokenizer(line);
        try {
            String lineNumber = t.nextToken();
            if ("0000000".equals(lineNumber)) {
                proc.lwpid = SolarisProcfsSupport.parseHex(t.nextToken());
                proc.count = (int)SolarisProcfsSupport.parseHex(t.nextToken());
                proc.tstamp = SolarisProcfsSupport.parseTimespec(t);
            } else if ("0000040".equals(lineNumber)) {
                proc.rtime = SolarisProcfsSupport.parseTimespec(t);
                proc.utime = SolarisProcfsSupport.parseTimespec(t);
            } else if ("0000060".equals(lineNumber)) {
                proc.stime = SolarisProcfsSupport.parseTimespec(t);
            }
        }
        catch (NoSuchElementException ex) {
            throw new IllegalArgumentException("Too few elements in line", ex);
        }
        return proc;
    }

    private static Timespec parseTimespec(StringTokenizer t) {
        return new Timespec(SolarisProcfsSupport.parseHex(t.nextToken()), SolarisProcfsSupport.parseHex(t.nextToken()));
    }

    private static long parseHex(String value) {
        return Long.parseLong(value, 16);
    }

    public static final class Prusage {
        private long lwpid;
        private int count;
        private Timespec tstamp;
        private Timespec rtime;
        private Timespec utime;
        private Timespec stime;

        private Prusage() {
        }

        public long lwpid() {
            return this.lwpid;
        }

        public int count() {
            return this.count;
        }

        public Timespec tstamp() {
            return this.tstamp;
        }

        public Timespec rtime() {
            return this.rtime;
        }

        public Timespec utime() {
            return this.utime;
        }

        public Timespec stime() {
            return this.stime;
        }
    }

    public static final class Timespec {
        private final long sec;
        private final long nsec;

        private Timespec(long sec, long nsec) {
            this.sec = sec;
            this.nsec = nsec;
        }

        public long sec() {
            return this.sec;
        }

        public long nsec() {
            return this.nsec;
        }

        public BigDecimal toBigDecimal() {
            return BigDecimal.valueOf(this.sec).add(BigDecimal.valueOf(this.nsec, 9));
        }
    }
}

