/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.libraries.asm;

import oracle.toplink.libraries.asm.Attribute;
import oracle.toplink.libraries.asm.CodeVisitor;
import oracle.toplink.libraries.asm.Label;

public class CodeAdapter
implements CodeVisitor {
    protected CodeVisitor cv;

    public CodeAdapter(CodeVisitor cv) {
        this.cv = cv;
    }

    public void visitInsn(int opcode) {
        this.cv.visitInsn(opcode);
    }

    public void visitIntInsn(int opcode, int operand) {
        this.cv.visitIntInsn(opcode, operand);
    }

    public void visitVarInsn(int opcode, int var) {
        this.cv.visitVarInsn(opcode, var);
    }

    public void visitTypeInsn(int opcode, String desc) {
        this.cv.visitTypeInsn(opcode, desc);
    }

    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        this.cv.visitFieldInsn(opcode, owner, name, desc);
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        this.cv.visitMethodInsn(opcode, owner, name, desc);
    }

    public void visitJumpInsn(int opcode, Label label) {
        this.cv.visitJumpInsn(opcode, label);
    }

    public void visitLabel(Label label) {
        this.cv.visitLabel(label);
    }

    public void visitLdcInsn(Object cst) {
        this.cv.visitLdcInsn(cst);
    }

    public void visitIincInsn(int var, int increment) {
        this.cv.visitIincInsn(var, increment);
    }

    public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
        this.cv.visitTableSwitchInsn(min, max, dflt, labels);
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        this.cv.visitLookupSwitchInsn(dflt, keys, labels);
    }

    public void visitMultiANewArrayInsn(String desc, int dims) {
        this.cv.visitMultiANewArrayInsn(desc, dims);
    }

    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        this.cv.visitTryCatchBlock(start, end, handler, type);
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        this.cv.visitMaxs(maxStack, maxLocals);
    }

    public void visitLocalVariable(String name, String desc, Label start, Label end, int index) {
        this.cv.visitLocalVariable(name, desc, start, end, index);
    }

    public void visitLineNumber(int line, Label start) {
        this.cv.visitLineNumber(line, start);
    }

    public void visitAttribute(Attribute attr) {
        this.cv.visitAttribute(attr);
    }
}

