/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.sessions;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.toplink.essentials.descriptors.ClassDescriptor;
import oracle.toplink.essentials.exceptions.DatabaseException;
import oracle.toplink.essentials.exceptions.OptimisticLockException;
import oracle.toplink.essentials.internal.helper.DescriptorCompare;
import oracle.toplink.essentials.internal.helper.Helper;
import oracle.toplink.essentials.internal.helper.IdentityHashtable;
import oracle.toplink.essentials.internal.helper.NonSynchronizedVector;
import oracle.toplink.essentials.internal.helper.TOPSort;
import oracle.toplink.essentials.internal.localization.ToStringLocalization;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.internal.sessions.CommitOrderCalculator;
import oracle.toplink.essentials.internal.sessions.ObjectChangeSet;
import oracle.toplink.essentials.internal.sessions.UnitOfWorkChangeSet;
import oracle.toplink.essentials.internal.sessions.UnitOfWorkImpl;
import oracle.toplink.essentials.mappings.DatabaseMapping;
import oracle.toplink.essentials.queryframework.DeleteObjectQuery;
import oracle.toplink.essentials.queryframework.InsertObjectQuery;
import oracle.toplink.essentials.queryframework.UpdateObjectQuery;
import oracle.toplink.essentials.queryframework.WriteObjectQuery;

public class CommitManager {
    protected Vector commitOrder;
    protected IdentityHashtable processedCommits;
    protected IdentityHashtable pendingCommits;
    protected IdentityHashtable preModifyCommits;
    protected IdentityHashtable postModifyCommits;
    protected IdentityHashtable completedCommits;
    protected IdentityHashtable shallowCommits;
    protected AbstractSession session;
    protected boolean isActive;
    protected Hashtable dataModifications;
    protected Vector objectsToDelete;

    public CommitManager(AbstractSession session) {
        this.session = session;
        this.commitOrder = NonSynchronizedVector.newInstance();
        this.isActive = false;
    }

    public void addDataModificationEvent(DatabaseMapping mapping, Object[] event) {
        if (!this.getDataModifications().containsKey(mapping)) {
            this.getDataModifications().put(mapping, new Vector());
        }
        ((Vector)this.getDataModifications().get(mapping)).addElement(event);
    }

    public void addObjectToDelete(Object objectToDelete) {
        this.getObjectsToDelete().addElement(objectToDelete);
    }

    protected void addProcessedCommit(Object domainObject) {
        this.getProcessedCommits().put(domainObject, domainObject);
    }

    public void commitAllObjects(IdentityHashtable domainObjects) throws RuntimeException, DatabaseException, OptimisticLockException {
        this.reinitialize();
        this.setPendingCommits(domainObjects);
        this.setIsActive(true);
        this.getSession().beginTransaction();
        try {
            Enumeration classesEnum = this.getCommitOrder().elements();
            while (classesEnum.hasMoreElements()) {
                Class theClass = (Class)classesEnum.nextElement();
                Enumeration pendingEnum = this.getPendingCommits().elements();
                while (pendingEnum.hasMoreElements()) {
                    Object objectToWrite = pendingEnum.nextElement();
                    if (objectToWrite.getClass() != theClass) continue;
                    this.removePendingCommit(objectToWrite);
                    WriteObjectQuery commitQuery = new WriteObjectQuery();
                    commitQuery.setObject(objectToWrite);
                    if (this.getSession().isUnitOfWork()) {
                        commitQuery.cascadeOnlyDependentParts();
                    } else {
                        commitQuery.cascadeAllParts();
                    }
                    this.getSession().executeQuery(commitQuery);
                }
            }
            Enumeration mappingsEnum = this.getDataModifications().keys();
            Enumeration mappingEventsEnum = this.getDataModifications().elements();
            while (mappingEventsEnum.hasMoreElements()) {
                Vector events = (Vector)mappingEventsEnum.nextElement();
                DatabaseMapping mapping = (DatabaseMapping)mappingsEnum.nextElement();
                Enumeration eventsEnum = events.elements();
                while (eventsEnum.hasMoreElements()) {
                    Object[] event = (Object[])eventsEnum.nextElement();
                    mapping.performDataModificationEvent(event, this.getSession());
                }
            }
            Vector objects = this.getObjectsToDelete();
            this.reinitialize();
            Enumeration objectsToDeleteEnum = objects.elements();
            while (objectsToDeleteEnum.hasMoreElements()) {
                this.getSession().deleteObject(objectsToDeleteEnum.nextElement());
            }
        }
        catch (RuntimeException exception) {
            this.getSession().rollbackTransaction();
            throw exception;
        }
        finally {
            this.reinitialize();
            this.setIsActive(false);
        }
        this.getSession().commitTransaction();
    }

    public void commitAllObjectsWithChangeSet(UnitOfWorkChangeSet uowChangeSet) throws RuntimeException, DatabaseException, OptimisticLockException {
        this.reinitialize();
        this.setIsActive(true);
        this.getSession().beginTransaction();
        try {
            Class theClass;
            if (uowChangeSet.getObjectChanges().size() + uowChangeSet.getNewObjectChangeSets().size() <= 1) {
                Enumeration classNames;
                Enumeration classes = uowChangeSet.getNewObjectChangeSets().keys();
                if (classes.hasMoreElements()) {
                    theClass = (Class)classes.nextElement();
                    this.commitNewObjectsForClassWithChangeSet(uowChangeSet, theClass);
                }
                if ((classNames = uowChangeSet.getObjectChanges().keys()).hasMoreElements()) {
                    String className = (String)classNames.nextElement();
                    this.commitChangedObjectsForClassWithChangeSet(uowChangeSet, className);
                }
            } else {
                Enumeration classesEnum = this.getCommitOrder().elements();
                while (classesEnum.hasMoreElements()) {
                    theClass = (Class)classesEnum.nextElement();
                    this.commitAllObjectsForClassWithChangeSet(uowChangeSet, theClass);
                }
            }
            if (this.hasDataModifications()) {
                Enumeration mappingsEnum = this.getDataModifications().keys();
                Enumeration mappingEventsEnum = this.getDataModifications().elements();
                while (mappingEventsEnum.hasMoreElements()) {
                    Vector events = (Vector)mappingEventsEnum.nextElement();
                    DatabaseMapping mapping = (DatabaseMapping)mappingsEnum.nextElement();
                    Enumeration eventsEnum = events.elements();
                    while (eventsEnum.hasMoreElements()) {
                        Object[] event = (Object[])eventsEnum.nextElement();
                        mapping.performDataModificationEvent(event, this.getSession());
                    }
                }
            }
            if (this.hasObjectsToDelete()) {
                Vector objects = this.getObjectsToDelete();
                this.reinitialize();
                Enumeration objectsToDeleteEnum = objects.elements();
                while (objectsToDeleteEnum.hasMoreElements()) {
                    this.getSession().deleteObject(objectsToDeleteEnum.nextElement());
                }
            }
        }
        catch (RuntimeException exception) {
            this.getSession().rollbackTransaction();
            throw exception;
        }
        finally {
            this.reinitialize();
            this.setIsActive(false);
        }
        this.getSession().commitTransaction();
    }

    protected void commitAllObjectsForClassWithChangeSet(UnitOfWorkChangeSet uowChangeSet, Class theClass) {
        this.commitChangedObjectsForClassWithChangeSet(uowChangeSet, theClass.getName());
        this.commitNewObjectsForClassWithChangeSet(uowChangeSet, theClass);
    }

    protected void commitNewObjectsForClassWithChangeSet(UnitOfWorkChangeSet uowChangeSet, Class theClass) {
        IdentityHashtable newObjectChangesList = (IdentityHashtable)uowChangeSet.getNewObjectChangeSets().get(theClass);
        if (newObjectChangesList != null) {
            ClassDescriptor descriptor = this.getSession().getDescriptor(theClass);
            Enumeration pendingEnum = newObjectChangesList.elements();
            while (pendingEnum.hasMoreElements()) {
                ObjectChangeSet changeSetToWrite = (ObjectChangeSet)pendingEnum.nextElement();
                Object objectToWrite = changeSetToWrite.getUnitOfWorkClone();
                if (!this.getProcessedCommits().containsKey(changeSetToWrite) && !this.getProcessedCommits().containsKey(objectToWrite)) {
                    this.addProcessedCommit(changeSetToWrite);
                    InsertObjectQuery commitQuery = new InsertObjectQuery();
                    commitQuery.setObjectChangeSet(changeSetToWrite);
                    commitQuery.setObject(objectToWrite);
                    commitQuery.cascadeOnlyDependentParts();
                    this.getSession().executeQuery(commitQuery);
                }
                ((UnitOfWorkImpl)this.getSession()).updateChangeTrackersIfRequired(objectToWrite, changeSetToWrite, (UnitOfWorkImpl)this.getSession(), descriptor);
            }
        }
    }

    protected void commitChangedObjectsForClassWithChangeSet(UnitOfWorkChangeSet uowChangeSet, String className) {
        Hashtable objectChangesList = (Hashtable)uowChangeSet.getObjectChanges().get(className);
        if (objectChangesList != null) {
            ClassDescriptor descriptor = null;
            Enumeration pendingEnum = objectChangesList.elements();
            while (pendingEnum.hasMoreElements()) {
                ObjectChangeSet changeSetToWrite = (ObjectChangeSet)pendingEnum.nextElement();
                if (descriptor == null) {
                    descriptor = this.getSession().getDescriptor(changeSetToWrite.getClassType(this.getSession()));
                }
                Object objectToWrite = changeSetToWrite.getUnitOfWorkClone();
                if (!this.getProcessedCommits().containsKey(changeSetToWrite) && !this.getProcessedCommits().containsKey(objectToWrite)) {
                    this.addProcessedCommit(changeSetToWrite);
                    WriteObjectQuery commitQuery = null;
                    commitQuery = changeSetToWrite.isNew() ? new InsertObjectQuery() : new UpdateObjectQuery();
                    commitQuery.setObjectChangeSet(changeSetToWrite);
                    commitQuery.setObject(objectToWrite);
                    commitQuery.cascadeOnlyDependentParts();
                    this.getSession().executeQuery(commitQuery);
                }
                ((UnitOfWorkImpl)this.getSession()).updateChangeTrackersIfRequired(objectToWrite, changeSetToWrite, (UnitOfWorkImpl)this.getSession(), descriptor);
            }
        }
    }

    public void deleteAllObjects(Vector objectsForDeletion) throws RuntimeException, DatabaseException, OptimisticLockException {
        this.setIsActive(true);
        this.getSession().beginTransaction();
        try {
            for (int index = this.getCommitOrder().size() - 1; index >= 0; --index) {
                Class theClass = (Class)this.getCommitOrder().elementAt(index);
                Enumeration objectsForDeletionEnum = objectsForDeletion.elements();
                while (objectsForDeletionEnum.hasMoreElements()) {
                    Object objectToDelete = objectsForDeletionEnum.nextElement();
                    if (objectToDelete.getClass() != theClass) continue;
                    DeleteObjectQuery deleteQuery = new DeleteObjectQuery();
                    deleteQuery.setObject(objectToDelete);
                    deleteQuery.cascadeOnlyDependentParts();
                    this.getSession().executeQuery(deleteQuery);
                }
            }
        }
        catch (RuntimeException exception) {
            try {
                this.getSession().rollbackTransaction();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw exception;
        }
        finally {
            this.setIsActive(false);
        }
        this.getSession().commitTransaction();
    }

    public Vector getCommitOrder() {
        return this.commitOrder;
    }

    protected IdentityHashtable getCompletedCommits() {
        if (this.completedCommits == null) {
            this.completedCommits = new IdentityHashtable();
        }
        return this.completedCommits;
    }

    protected boolean hasDataModifications() {
        return this.dataModifications != null && !this.dataModifications.isEmpty();
    }

    protected Hashtable getDataModifications() {
        if (this.dataModifications == null) {
            this.dataModifications = new Hashtable(10);
        }
        return this.dataModifications;
    }

    protected boolean hasObjectsToDelete() {
        return this.objectsToDelete != null && !this.objectsToDelete.isEmpty();
    }

    protected Vector getObjectsToDelete() {
        if (this.objectsToDelete == null) {
            this.objectsToDelete = new Vector(5);
        }
        return this.objectsToDelete;
    }

    protected IdentityHashtable getProcessedCommits() {
        if (this.processedCommits == null) {
            this.processedCommits = new IdentityHashtable();
        }
        return this.processedCommits;
    }

    protected IdentityHashtable getPendingCommits() {
        if (this.pendingCommits == null) {
            this.pendingCommits = new IdentityHashtable();
        }
        return this.pendingCommits;
    }

    protected IdentityHashtable getPostModifyCommits() {
        if (this.postModifyCommits == null) {
            this.postModifyCommits = new IdentityHashtable();
        }
        return this.postModifyCommits;
    }

    protected IdentityHashtable getPreModifyCommits() {
        if (this.preModifyCommits == null) {
            this.preModifyCommits = new IdentityHashtable();
        }
        return this.preModifyCommits;
    }

    protected AbstractSession getSession() {
        return this.session;
    }

    protected IdentityHashtable getShallowCommits() {
        if (this.shallowCommits == null) {
            this.shallowCommits = new IdentityHashtable();
        }
        return this.shallowCommits;
    }

    public void initializeCommitOrder() {
        int index;
        Vector descriptors = Helper.buildVectorFromMapElements(this.getSession().getDescriptors());
        descriptors = Helper.addAllUniqueToVector(new Vector(descriptors.size()), descriptors);
        Object[] descriptorsArray = new Object[descriptors.size()];
        for (index = 0; index < descriptors.size(); ++index) {
            descriptorsArray[index] = descriptors.elementAt(index);
        }
        TOPSort.quicksort(descriptorsArray, new DescriptorCompare());
        descriptors = new Vector(descriptors.size());
        for (index = 0; index < descriptorsArray.length; ++index) {
            descriptors.addElement(descriptorsArray[index]);
        }
        CommitOrderCalculator calculator = new CommitOrderCalculator(this.getSession());
        calculator.addNodes(descriptors);
        calculator.calculateMappingDependencies();
        calculator.orderCommits();
        descriptors = calculator.getOrderedDescriptors();
        calculator = new CommitOrderCalculator(this.getSession());
        calculator.addNodes(descriptors);
        calculator.calculateSpecifiedDependencies();
        calculator.orderCommits();
        this.setCommitOrder(calculator.getOrderedClasses());
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean isCommitCompleted(Object domainObject) {
        return this.getCompletedCommits().containsKey(domainObject);
    }

    public boolean isCommitInPostModify(Object domainObject) {
        return this.getPostModifyCommits().containsKey(domainObject);
    }

    public boolean isCommitInPreModify(Object domainObject) {
        return this.getPreModifyCommits().containsKey(domainObject);
    }

    public boolean isShallowCommitted(Object domainObject) {
        return this.getShallowCommits().containsKey(domainObject);
    }

    public void markCommitCompleted(Object domainObject) {
        this.getPreModifyCommits().remove(domainObject);
        this.getPostModifyCommits().remove(domainObject);
        if (!this.isActive() && this.getPostModifyCommits().isEmpty() && this.getPreModifyCommits().isEmpty()) {
            this.reinitialize();
            return;
        }
        this.getCompletedCommits().put(domainObject, domainObject);
    }

    public void markPostModifyCommitInProgress(Object domainObject) {
        this.getPreModifyCommits().remove(domainObject);
        this.getPostModifyCommits().put(domainObject, domainObject);
    }

    public void markPreModifyCommitInProgress(Object domainObject) {
        this.removePendingCommit(domainObject);
        this.addProcessedCommit(domainObject);
        this.getPreModifyCommits().put(domainObject, domainObject);
    }

    public void markShallowCommit(Object domainObject) {
        this.getShallowCommits().put(domainObject, domainObject);
    }

    public void reinitialize() {
        this.setPendingCommits(null);
        this.setProcessedCommits(null);
        this.setPreModifyCommits(null);
        this.setPostModifyCommits(null);
        this.setCompletedCommits(null);
        this.setShallowCommits(null);
        this.setObjectsToDelete(null);
        this.setDataModifications(null);
    }

    protected void removePendingCommit(Object domainObject) {
        this.getPendingCommits().remove(domainObject);
    }

    public void setCommitOrder(Vector commitOrder) {
        this.commitOrder = commitOrder;
    }

    protected void setCompletedCommits(IdentityHashtable completedCommits) {
        this.completedCommits = completedCommits;
    }

    protected void setDataModifications(Hashtable dataModifications) {
        this.dataModifications = dataModifications;
    }

    public void setIsActive(boolean isActive) {
        this.isActive = isActive;
    }

    protected void setObjectsToDelete(Vector objectsToDelete) {
        this.objectsToDelete = objectsToDelete;
    }

    protected void setPendingCommits(IdentityHashtable pendingCommits) {
        this.pendingCommits = pendingCommits;
    }

    protected void setProcessedCommits(IdentityHashtable processedCommits) {
        this.processedCommits = processedCommits;
    }

    protected void setPostModifyCommits(IdentityHashtable postModifyCommits) {
        this.postModifyCommits = postModifyCommits;
    }

    protected void setPreModifyCommits(IdentityHashtable preModifyCommits) {
        this.preModifyCommits = preModifyCommits;
    }

    protected void setSession(AbstractSession session) {
        this.session = session;
    }

    protected void setShallowCommits(IdentityHashtable shallowCommits) {
        this.shallowCommits = shallowCommits;
    }

    public String toString() {
        int size = 0;
        if (this.preModifyCommits != null) {
            size += this.getPreModifyCommits().size();
        }
        if (this.postModifyCommits != null) {
            size += this.getPostModifyCommits().size();
        }
        Object[] args = new Object[]{new Integer(size)};
        return Helper.getShortClassName(this.getClass()) + ToStringLocalization.buildMessage("commit_depth", args);
    }
}

