/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.ejb.cmp3.xml.tables;

import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataLogger;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.columns.MetadataJoinColumns;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.tables.MetadataJoinTable;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.XMLHelper;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.columns.XMLJoinColumns;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.tables.XMLTableHelper;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLJoinTable
extends MetadataJoinTable {
    protected XMLHelper m_helper;
    protected NodeList m_joinColumns;
    protected NodeList m_inverseJoinColumns;

    public XMLJoinTable(Node node, XMLHelper helper, MetadataLogger logger) {
        super(logger);
        this.m_helper = helper;
        this.m_name = helper.getNodeValue(node, "@name");
        this.m_schema = helper.getNodeValue(node, "@schema");
        this.m_catalog = helper.getNodeValue(node, "@catalog");
        this.m_joinColumns = helper.getNodes(node, "join-column");
        this.m_inverseJoinColumns = helper.getNodes(node, "inverse-join-column");
        this.processName();
        XMLTableHelper.processUniqueConstraints(node, helper, this.m_databaseTable);
    }

    public boolean loadedFromXML() {
        return true;
    }

    protected MetadataJoinColumns processInverseJoinColumns() {
        return new XMLJoinColumns(this.m_inverseJoinColumns, this.m_helper);
    }

    protected MetadataJoinColumns processJoinColumns() {
        return new XMLJoinColumns(this.m_joinColumns, this.m_helper);
    }
}

