/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.palette.items;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.ext.html.parser.AstNode;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.web.core.syntax.spi.JspContextInfo;
import org.netbeans.modules.web.jsf.api.palette.PaletteItem;
import org.netbeans.modules.web.jsf.palette.JSFPaletteUtilities;
import org.netbeans.modules.web.jsf.palette.items.MetaDataCustomizer;
import org.netbeans.modules.web.jsps.parserapi.JspParserAPI;
import org.netbeans.modules.web.jsps.parserapi.Node;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.ActiveEditorDrop;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class MetaData
implements ActiveEditorDrop,
PaletteItem {
    private HashMap<String, String> properties = new HashMap();
    private static final String TAG_NAME = "h:inputText";
    private static final String NAME_SPACE = "http://java.sun.com/jsf/html";
    private static final String VALUE_NAME = "value";

    public boolean handleTransfer(JTextComponent jTextComponent) {
        this.properties.clear();
        this.findProperties(jTextComponent);
        MetaDataCustomizer metaDataCustomizer = new MetaDataCustomizer(this, jTextComponent);
        boolean bl = metaDataCustomizer.showDialog();
        if (bl) {
            try {
                String string = this.createBody(jTextComponent);
                JSFPaletteUtilities.insert(string, jTextComponent);
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(MetaData.class, (String)"NAME_jsp-JsfMetadata");
    }

    @Override
    public void insert(JTextComponent jTextComponent) {
        this.handleTransfer(jTextComponent);
    }

    private String createBody(JTextComponent jTextComponent) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<f:metadata>\n");
        Set<Map.Entry<String, String>> set = this.properties.entrySet();
        for (Map.Entry<String, String> entry : set) {
            stringBuffer.append("   <f:viewParam id='" + entry.getKey() + "' value='" + entry.getValue() + "'/>\n");
        }
        stringBuffer.append("</f:metadata>\n");
        return stringBuffer.toString();
    }

    public HashMap<String, String> getProperties() {
        return this.properties;
    }

    public String addProperty(String string, String string2) {
        return this.properties.put(string, string2);
    }

    public String removeProperty(String string) {
        return this.properties.remove(string);
    }

    private void findProperties(JTextComponent jTextComponent) {
        BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
        DataObject dataObject = NbEditorUtilities.getDataObject((Document)baseDocument);
        if (dataObject != null) {
            FileObject fileObject = NbEditorUtilities.getDataObject((Document)baseDocument).getPrimaryFile();
            if (fileObject.getMIMEType().equals("text/xhtml")) {
                Source source = Source.create((Document)baseDocument);
                final int n = jTextComponent.getCaretPosition();
                try {
                    ParserManager.parse(Collections.singleton(source), (UserTask)new UserTask(){

                        public void run(ResultIterator resultIterator) throws Exception {
                            HtmlParserResult htmlParserResult;
                            Parser.Result result = resultIterator.getParserResult(n);
                            if (result instanceof HtmlParserResult && (htmlParserResult = (HtmlParserResult)result).getNamespaces().containsKey(MetaData.NAME_SPACE)) {
                                List list = MetaData.this.findValue(htmlParserResult.root(MetaData.NAME_SPACE).children(), MetaData.TAG_NAME, new ArrayList());
                                for (AstNode astNode : list) {
                                    String string = astNode.getAttribute(MetaData.VALUE_NAME).unquotedValue();
                                    String string2 = MetaData.this.generateKey(string);
                                    MetaData.this.properties.put(string2, string);
                                }
                            }
                        }
                    });
                }
                catch (ParseException parseException) {
                    Exceptions.printStackTrace((Throwable)parseException);
                }
            } else {
                JspParserAPI.ParseResult parseResult;
                JspContextInfo jspContextInfo = JspContextInfo.getContextInfo((FileObject)fileObject);
                if (jspContextInfo != null && (parseResult = jspContextInfo.getCachedParseResult(fileObject, false, true)) != null) {
                    Node.Nodes nodes = parseResult.getNodes();
                    List<Node> list = new ArrayList<Node>();
                    list = this.findValue(nodes, TAG_NAME, list);
                    for (Node node : list) {
                        String string = node.getAttributeValue(VALUE_NAME);
                        String string2 = this.generateKey(string);
                        this.properties.put(string2, string);
                    }
                }
            }
        }
    }

    private List<AstNode> findValue(List<AstNode> list, String string, List<AstNode> list2) {
        if (list == null) {
            return list2;
        }
        for (int i = 0; i < list.size(); ++i) {
            AstNode astNode = list.get(i);
            if (string.equals(astNode.name())) {
                list2.add(astNode);
                continue;
            }
            list2 = this.findValue(astNode.children(), string, list2);
        }
        return list2;
    }

    private List<Node> findValue(Node.Nodes nodes, String string, List<Node> list) {
        if (nodes == null) {
            return list;
        }
        for (int i = 0; i < nodes.size(); ++i) {
            Node node = nodes.getNode(i);
            if (string.equals(node.getQName())) {
                list.add(node);
                continue;
            }
            list = this.findValue(node.getBody(), string, list);
        }
        return list;
    }

    private String generateKey(String string) {
        if (string.startsWith("#{")) {
            string = string.substring(2, string.length() - 1);
        }
        String string2 = string.substring(string.lastIndexOf(".") + 1, string.length()).toLowerCase();
        int n = 0;
        String string3 = string2;
        while (this.properties.get(string3) != null) {
            string3 = string2 + ++n;
        }
        return string2;
    }
}

