/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.model.presenters.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.modules.vmd.api.model.DescriptorRegistry;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.Presenter;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.api.model.presenters.actions.ActionContext;
import org.netbeans.modules.vmd.api.model.presenters.actions.ActionsPresenter;
import org.netbeans.modules.vmd.api.model.presenters.actions.AddActionItem;
import org.netbeans.modules.vmd.api.model.presenters.actions.AddActionPresenter;
import org.netbeans.modules.vmd.model.actions.ActionsPresenterForwarder;

public final class ActionsSupport {
    static final String SEPERATOR_KEY = "#SEPARATOR#";
    static final Set<Action> actionsToDelete = new HashSet<Action>();
    private static final TypeID[] EMPTY_TYPEID_ARRAY = new TypeID[0];

    public static synchronized Action[] createAddActionArray(DesignComponent component) {
        return ActionsSupport.createAddActionArray(component, EMPTY_TYPEID_ARRAY);
    }

    public static synchronized Action[] createAddActionArray(final DesignComponent component, final TypeID ... filtersTypeID) {
        final ArrayList actions = new ArrayList();
        component.getDocument().getTransactionManager().readAccess(new Runnable(){

            @Override
            public void run() {
                if (!component.getPresenters(AddActionPresenter.class).isEmpty()) {
                    TreeMap sortedMaps = new TreeMap();
                    DescriptorRegistry registry = component.getDocument().getDescriptorRegistry();
                    for (AddActionPresenter presenter : component.getPresenters(AddActionPresenter.class)) {
                        AddActionItem[] addActionItems = presenter.getAddActionItems();
                        if (addActionItems == null || addActionItems.length < 1) continue;
                        Integer order = presenter.getOrder() == null ? Integer.MAX_VALUE : presenter.getOrder();
                        if (sortedMaps.get(order) == null) {
                            sortedMaps.put(order, new TreeMap());
                            ((Map)sortedMaps.get(order)).put(presenter.getName(), new ArrayList<AddActionItem>(Arrays.asList(addActionItems)));
                            continue;
                        }
                        if (sortedMaps.get(order) != null && ((Map)sortedMaps.get(order)).get(presenter.getName()) == null) {
                            ((Map)sortedMaps.get(order)).put(presenter.getName(), new ArrayList<AddActionItem>(Arrays.asList(addActionItems)));
                            continue;
                        }
                        ((List)((Map)sortedMaps.get(order)).get(presenter.getName())).addAll(Arrays.asList(addActionItems));
                    }
                    for (Map sortedMap : sortedMaps.values()) {
                        for (String name : sortedMap.keySet()) {
                            if (filtersTypeID.length == 0) {
                                if (name != null) {
                                    actions.add(new SeperatorAction(name));
                                }
                                actions.addAll((Collection)sortedMap.get(name));
                                continue;
                            }
                            boolean removeCategory = true;
                            if (name != null) {
                                actions.add(new SeperatorAction(name));
                            }
                            for (Action action : (List)sortedMap.get(name)) {
                                for (TypeID typeID : filtersTypeID) {
                                    TypeID actionTypeID = (TypeID)action.getValue("typeID");
                                    if (!registry.isInHierarchy(typeID, actionTypeID)) continue;
                                    actions.add(action);
                                    removeCategory = false;
                                }
                            }
                            if (name == null || !removeCategory) continue;
                            actions.remove(actions.size() - 1);
                        }
                    }
                }
            }
        });
        return actions.toArray(new Action[actions.size()]);
    }

    public static synchronized Action[] createActionsArray(final DesignComponent component) {
        final ArrayList actions = new ArrayList();
        component.getDocument().getTransactionManager().readAccess(new Runnable(){

            @Override
            public void run() {
                TreeMap<Integer, ArrayList<Action>> sortedLists = new TreeMap<Integer, ArrayList<Action>>();
                DesignDocument document = null;
                Collection<ActionsPresenter> presenters = component.getPresenters(ActionsPresenter.class);
                if (presenters == null) {
                    return;
                }
                for (ActionsPresenter presenter : presenters) {
                    List list;
                    Integer order;
                    List<Action> actions2 = presenter.getActions();
                    if (actions2 == null || actions2.isEmpty()) continue;
                    DesignComponent relatedComponent = presenter.getRelatedComponent();
                    assert (relatedComponent != null) : "No related component for ActionsPresenter " + presenter;
                    for (Action action : actions2) {
                        if (!(action instanceof ActionContext)) continue;
                        ((ActionContext)((Object)action)).setComponent(relatedComponent);
                    }
                    if (document != null) {
                        assert (document == relatedComponent.getDocument());
                    } else {
                        document = relatedComponent.getDocument();
                    }
                    if ((order = presenter.getOrder()) == null) {
                        order = Integer.MAX_VALUE;
                    }
                    if ((list = (List)sortedLists.get(order)) == null) {
                        sortedLists.put(order, new ArrayList<Action>(actions2));
                        continue;
                    }
                    list.addAll(actions2);
                }
                for (List list : sortedLists.values()) {
                    for (Action action : list) {
                        actions.add(action);
                    }
                    actions.add(null);
                }
            }
        });
        return actions.toArray(new Action[actions.size()]);
    }

    public static synchronized Collection<Presenter> createByReference(String referencePropertyName, Class ... actionsToInherit) {
        HashSet<Presenter> presenters = new HashSet<Presenter>();
        for (Class actionClass : actionsToInherit) {
            ActionsPresenterForwarder presenter = ActionsPresenterForwarder.byReference(referencePropertyName, actionClass);
            if (presenter == null) continue;
            presenters.add(presenter);
        }
        return presenters;
    }

    public static synchronized Collection<Presenter> createByParent(Class ... actionsToInherit) {
        HashSet<Presenter> presenters = new HashSet<Presenter>();
        for (Class actionClass : actionsToInherit) {
            ActionsPresenterForwarder presenter = ActionsPresenterForwarder.byParent(actionClass);
            if (presenter == null) continue;
            presenters.add(presenter);
        }
        return presenters;
    }

    private static class SeperatorAction
    extends AbstractAction {
        public SeperatorAction(String name) {
            this.putValue("Name", name);
            this.putValue(ActionsSupport.SEPERATOR_KEY, ActionsSupport.SEPERATOR_KEY);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }

        @Override
        public boolean isEnabled() {
            return false;
        }
    }
}

