/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.api;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.kenai.FeatureData;
import org.netbeans.modules.kenai.api.KenaiService;

public final class KenaiFeature {
    private FeatureData featureData;
    private URL webL;
    private String loc;
    public static final String PROP_FEATURE_CHANGED = "feature_change";
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    KenaiFeature(FeatureData data) {
        this.featureData = data;
        this.loc = this.featureData.url;
        try {
            this.webL = this.featureData.web_url == null ? null : new URL(this.featureData.web_url);
        }
        catch (MalformedURLException malformedURLException) {
            Logger.getLogger(KenaiFeature.class.getName()).log(Level.FINE, malformedURLException.getMessage(), malformedURLException);
        }
    }

    public String getName() {
        return this.featureData.name;
    }

    public KenaiService.Type getType() {
        return KenaiService.Type.forId(this.featureData.type);
    }

    public String getExtendedType() {
        if (this.getType() == KenaiService.Type.SOURCE) {
            return this.featureData.repository_type;
        }
        if (this.getType() == KenaiService.Type.ISSUES) {
            return this.featureData.issue_tracker_type;
        }
        return null;
    }

    public String getService() {
        return this.featureData.service;
    }

    public String getLocation() {
        return this.loc;
    }

    public URL getWebLocation() {
        return this.webL;
    }

    public String getDisplayName() {
        return this.featureData.display_name;
    }

    public String toString() {
        return "KenaiFeature " + this.getName() + ", url=" + this.getLocation();
    }
}

