/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.extras.api.support;

import java.awt.FontMetrics;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.dlight.extras.api.AxisMark;
import org.netbeans.modules.dlight.extras.api.support.AbstractCachingAxisMarksProvider;
import org.netbeans.modules.dlight.util.DLightMath;
import org.netbeans.modules.dlight.util.ValueFormatter;

public final class ValueMarksProvider
extends AbstractCachingAxisMarksProvider {
    private final ValueFormatter formatter;

    public static ValueMarksProvider newInstance() {
        return new ValueMarksProvider(null);
    }

    public static ValueMarksProvider newInstance(ValueFormatter formatter) {
        return new ValueMarksProvider(formatter);
    }

    private ValueMarksProvider(ValueFormatter formatter) {
        this.formatter = formatter;
    }

    @Override
    protected List<AxisMark> getAxisMarksImpl(long viewportStart, long viewportEnd, int axisSize, FontMetrics axisFontMetrics) {
        ArrayList<AxisMark> marks = new ArrayList<AxisMark>();
        this.createMarks(viewportStart, viewportEnd, 0, axisSize, axisFontMetrics, marks);
        marks.add(new AxisMark(axisSize, this.formatValue(viewportEnd)));
        return marks;
    }

    private void createMarks(long minVal, long maxVal, int minPos, int maxPos, FontMetrics axisFontMetrics, List<AxisMark> marks) {
        if (maxPos - minPos <= axisFontMetrics.getAscent()) {
            return;
        }
        int midPos = (minPos + maxPos) / 2;
        long midVal = (minVal + maxVal) / 2L;
        if (axisFontMetrics.getAscent() <= midPos - minPos) {
            this.createMarks(minVal, midVal, minPos, midPos, axisFontMetrics, marks);
        }
        marks.add(new AxisMark(midPos, maxVal - minVal < 2L ? null : this.formatValue(midVal), DLightMath.map((int)(maxPos - minPos), (int)(3 * axisFontMetrics.getAscent() / 2), (int)(2 * axisFontMetrics.getAscent()), (int)0, (int)255), DLightMath.map((int)(maxPos - minPos), (int)(2 * axisFontMetrics.getAscent()), (int)(3 * axisFontMetrics.getAscent()), (int)0, (int)255)));
        if (axisFontMetrics.getAscent() <= maxPos - midPos) {
            this.createMarks(midVal, maxVal, midPos, maxPos, axisFontMetrics, marks);
        }
    }

    private String formatValue(long value) {
        if (this.formatter == null) {
            return String.valueOf(value);
        }
        return this.formatter.format(value);
    }
}

