/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.impl;

import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.j2ee.deployment.common.api.DatasourceAlreadyExistsException;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.deployment.impl.ProgressObjectUtil;
import org.netbeans.modules.j2ee.deployment.impl.ServerInstance;
import org.netbeans.modules.j2ee.deployment.impl.ServerRegistry;
import org.netbeans.modules.j2ee.deployment.impl.ServerTarget;
import org.netbeans.modules.j2ee.deployment.impl.TimedOutException;
import org.netbeans.modules.j2ee.deployment.impl.ui.ProgressUI;
import org.netbeans.modules.j2ee.deployment.plugins.spi.JDBCDriverDeployer;

public final class DeploymentHelper {
    private static final Logger LOGGER = Logger.getLogger(DeploymentHelper.class.getName());

    public static void deployMessageDestinations(J2eeModuleProvider j2eeModuleProvider) throws ConfigurationException {
        ServerInstance serverInstance = ServerRegistry.getInstance().getServerInstance(j2eeModuleProvider.getServerInstanceID());
        if (serverInstance != null) {
            serverInstance.deployMessageDestinations(j2eeModuleProvider.getConfigSupport().getMessageDestinations());
        } else {
            LOGGER.log(Level.WARNING, "The message destinations cannot be deployed because the server instance cannot be found.");
        }
    }

    public static void deployJdbcDrivers(J2eeModuleProvider j2eeModuleProvider, ProgressUI progressUI) throws ConfigurationException, TimedOutException {
        ServerInstance serverInstance = ServerRegistry.getInstance().getServerInstance(j2eeModuleProvider.getServerInstanceID());
        if (serverInstance != null) {
            Target target;
            ServerTarget[] serverTargetArray;
            JDBCDriverDeployer jDBCDriverDeployer;
            Set<Datasource> set = j2eeModuleProvider.getConfigSupport().getDatasources();
            if (set != null && set.size() > 0 && (jDBCDriverDeployer = serverInstance.getJDBCDriverDeployer()) != null && (serverTargetArray = serverInstance.getTargets()).length > 0 && jDBCDriverDeployer.supportsDeployJDBCDrivers(target = serverTargetArray[0].getTarget())) {
                ProgressObject progressObject = jDBCDriverDeployer.deployJDBCDrivers(target, set);
                ProgressObjectUtil.trackProgressObject(progressUI, progressObject, Long.MAX_VALUE);
            }
        } else {
            LOGGER.log(Level.WARNING, "The JDBC drivers cannot be deployed because the server instance cannot be found.");
        }
    }

    public static void deployDatasources(J2eeModuleProvider j2eeModuleProvider) throws ConfigurationException, DatasourceAlreadyExistsException {
        ServerInstance serverInstance = ServerRegistry.getInstance().getServerInstance(j2eeModuleProvider.getServerInstanceID());
        if (serverInstance != null) {
            Set<Datasource> set = j2eeModuleProvider.getConfigSupport().getDatasources();
            serverInstance.deployDatasources(set);
        } else {
            LOGGER.log(Level.WARNING, "The data sources cannot be deployed because the server instance cannot be found.");
        }
    }
}

