/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.visualizers;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.netbeans.modules.dlight.api.storage.DataRow;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.spi.impl.TableDataProvider;
import org.netbeans.modules.dlight.spi.visualizer.Visualizer;
import org.netbeans.modules.dlight.spi.visualizer.VisualizerContainer;
import org.netbeans.modules.dlight.util.DLightExecutorService;
import org.netbeans.modules.dlight.util.UIThread;
import org.netbeans.modules.dlight.visualizers.DualPaneSupport;
import org.netbeans.modules.dlight.visualizers.FunctionsListSheetCell;
import org.netbeans.modules.dlight.visualizers.ImageLoader;
import org.netbeans.modules.dlight.visualizers.OnTimerRefreshVisualizerHandler;
import org.netbeans.modules.dlight.visualizers.OnTimerTask;
import org.netbeans.modules.dlight.visualizers.VisualizerTopComponentTopComponent;
import org.netbeans.modules.dlight.visualizers.api.AdvancedTableViewVisualizerConfiguration;
import org.netbeans.modules.dlight.visualizers.api.impl.AdvancedTableViewVisualizerConfigurationAccessor;
import org.netbeans.swing.etable.ETableColumnModel;
import org.netbeans.swing.outline.Outline;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.OutlineView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

final class AdvancedTableViewVisualizer
extends JPanel
implements Visualizer<AdvancedTableViewVisualizerConfiguration>,
OnTimerTask,
ComponentListener,
ExplorerManager.Provider {
    private static final long MIN_REFRESH_MILLIS = 500L;
    private TableDataProvider provider;
    private AdvancedTableViewVisualizerConfiguration configuration;
    private final List<DataRow> data = new ArrayList<DataRow>();
    private JButton refresh;
    private OnTimerRefreshVisualizerHandler timerHandler;
    private boolean isEmptyContent;
    private boolean isLoadingContent;
    private boolean isShown = true;
    private final OutlineView outlineView;
    private final String nodeColumnName;
    private final String nodeRowColumnID;
    private final ExplorerManager explorerManager;
    private Future<Boolean> task;
    private final Object queryLock = new Object();
    private final Object uiLock = new Object();
    private final String iconColumnID;
    private String resourceID;
    private final boolean dualPaneMode;
    private final DualPaneSupport<DataRow> dualPaneSupport;
    private Map<Integer, Boolean> ascColumnValues = new HashMap<Integer, Boolean>();
    private static final boolean isMacLaf = "Aqua".equals(UIManager.getLookAndFeel().getID());
    private static final Color macBackground = UIManager.getColor("NbExplorerView.background");

    AdvancedTableViewVisualizer(TableDataProvider provider, AdvancedTableViewVisualizerConfiguration configuration) {
        super(new BorderLayout());
        this.provider = provider;
        this.configuration = configuration;
        this.explorerManager = new ExplorerManager();
        this.addComponentListener(this);
        AdvancedTableViewVisualizerConfigurationAccessor accessor = AdvancedTableViewVisualizerConfigurationAccessor.getDefault();
        this.nodeColumnName = accessor.getNodeColumnName(configuration);
        this.nodeRowColumnID = accessor.getRowNodeColumnName(configuration);
        this.outlineView = new OutlineView(configuration.getMetadata().getColumnByName(this.nodeColumnName).getColumnUName());
        this.outlineView.getOutline().setRootVisible(false);
        this.iconColumnID = accessor.getIconColumnID(configuration);
        if (this.iconColumnID == null || configuration.getMetadata().getColumnByName(this.iconColumnID) == null) {
            this.outlineView.getOutline().setDefaultRenderer(Object.class, (TableCellRenderer)new ExtendedTableCellRendererForNode());
        }
        this.resourceID = this.iconColumnID == null ? null : accessor.getIconPath(configuration);
        List<String> hiddenColumns = accessor.getHiddenColumnNames(configuration);
        ArrayList<1> result = new ArrayList<1>();
        ArrayList<DataTableMetadata.Column> columns = new ArrayList<DataTableMetadata.Column>();
        ArrayList<String> columnProperties = new ArrayList<String>();
        for (String columnName : configuration.getMetadata().getColumnNames()) {
            if (this.nodeColumnName.equals(columnName) || this.nodeRowColumnID.equals(columnName) || hiddenColumns.contains(columnName)) continue;
            DataTableMetadata.Column c = configuration.getMetadata().getColumnByName(columnName);
            columns.add(c);
            PropertySupport property = new PropertySupport(c.getColumnName(), c.getColumnClass(), c.getColumnUName(), c.getColumnUName(), true, false){

                public Object getValue() throws IllegalAccessException, InvocationTargetException {
                    return null;
                }

                public void setValue(Object arg0) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                }
            };
            result.add(property);
            columnProperties.add(c.getColumnName());
            columnProperties.add(c.getColumnUName());
        }
        this.outlineView.getOutline().setDefaultRenderer(Node.Property.class, (TableCellRenderer)new FunctionsListSheetCell.OutlineSheetCell(this.outlineView.getOutline(), columns));
        this.outlineView.setPropertyColumns(columnProperties.toArray(new String[0]));
        this.outlineView.setPopupAllowed(false);
        this.outlineView.setDragSource(false);
        this.outlineView.setDropTarget(false);
        this.outlineView.setAllowedDragActions(0);
        this.outlineView.setAllowedDropActions(0);
        final Outline outline = this.outlineView.getOutline();
        outline.getTableHeader().setReorderingAllowed(false);
        outline.setRootVisible(false);
        int columnCount = columns.size() + 1;
        int firstKey = 49;
        for (int i = 1; i <= columnCount; ++i) {
            final int columnNumber = i - 1;
            KeyStroke columnKey = KeyStroke.getKeyStroke(firstKey++, 8, true);
            this.outlineView.getInputMap(1).put(columnKey, "ascSortFor" + i);
            this.outlineView.getActionMap().put("ascSortFor" + i, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int column = columnNumber;
                    ETableColumnModel columnModel = null;
                    if (outline.getColumnModel() instanceof ETableColumnModel) {
                        columnModel = (ETableColumnModel)outline.getColumnModel();
                        columnModel.clearSortedColumns();
                    }
                    boolean asc = !AdvancedTableViewVisualizer.this.ascColumnValues.containsKey(column) ? true : (Boolean)AdvancedTableViewVisualizer.this.ascColumnValues.get(column);
                    outline.setColumnSorted(column, asc, 1);
                    AdvancedTableViewVisualizer.this.ascColumnValues.put(column, !asc);
                    outline.getTableHeader().resizeAndRepaint();
                }
            });
        }
        outline.getSelectionModel().setSelectionMode(0);
        VisualizerTopComponentTopComponent.findInstance().addComponentListener(this);
        KeyStroke returnKey = KeyStroke.getKeyStroke(27, 0, true);
        this.outlineView.getOutline().getInputMap(1).put(returnKey, "return");
        this.outlineView.getOutline().getActionMap().put("return", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AdvancedTableViewVisualizer.this.refresh.requestFocus(false);
            }
        });
        this.dualPaneMode = accessor.isDualPaneMode(configuration);
        this.dualPaneSupport = this.dualPaneMode ? DualPaneSupport.forExplorerManager(this, this.explorerManager, accessor.getDetailsRenderer(configuration), new DualPaneSupport.DataAdapter<Node, DataRow>(){

            @Override
            public DataRow convert(Node obj) {
                if (obj instanceof DataRowNode) {
                    return ((DataRowNode)obj).getDataRow();
                }
                return null;
            }
        }) : null;
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    @Override
    public void requestFocus() {
        if (this.refresh != null) {
            this.refresh.requestFocus();
        } else {
            this.outlineView.requestFocus();
        }
    }

    @Override
    public boolean requestFocusInWindow() {
        if (this.refresh != null) {
            return this.refresh.requestFocusInWindow();
        }
        return this.outlineView.requestFocusInWindow();
    }

    @Override
    public void addNotify() {
        super.addNotify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNotify() {
        super.removeNotify();
        Object object = this.queryLock;
        synchronized (object) {
            if (this.task != null) {
                this.task.cancel(true);
            }
        }
        if (this.timerHandler != null) {
            this.timerHandler.stopTimer();
        }
        this.removeComponentListener(this);
        VisualizerTopComponentTopComponent.findInstance().removeComponentListener(this);
    }

    private void setEmptyContent() {
        this.isEmptyContent = true;
        this.removeAll();
        JLabel label = new JLabel(this.timerHandler != null && this.timerHandler.isSessionAnalyzed() ? AdvancedTableViewVisualizerConfigurationAccessor.getDefault().getEmptyAnalyzeMessage(this.configuration) : AdvancedTableViewVisualizerConfigurationAccessor.getDefault().getEmptyRunningMessage(this.configuration), 0);
        this.add((Component)label, "Center");
        this.add((Component)this.createToolbar(), "West");
        this.repaint();
        this.revalidate();
    }

    private void setLoadingContent() {
        this.isEmptyContent = false;
        this.isLoadingContent = true;
        this.removeAll();
        JLabel label = new JLabel(AdvancedTableViewVisualizer.getMessage("Loading"), 0);
        this.add((Component)label, "Center");
        this.repaint();
        this.revalidate();
    }

    private void setContent(boolean isEmpty) {
        if (this.isLoadingContent && isEmpty) {
            this.isLoadingContent = false;
            this.setEmptyContent();
            return;
        }
        if (this.isLoadingContent && !isEmpty) {
            this.isLoadingContent = false;
            this.setNonEmptyContent();
            return;
        }
        if (this.isEmptyContent && !isEmpty) {
            this.setNonEmptyContent();
            return;
        }
        if (isEmpty) {
            this.setEmptyContent();
            return;
        }
    }

    protected void updateList(final List<DataRow> list) {
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        final boolean isEmptyConent = list == null || list.isEmpty();
        UIThread.invoke((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = AdvancedTableViewVisualizer.this.uiLock;
                synchronized (object) {
                    AdvancedTableViewVisualizer.this.setContent(isEmptyConent);
                    if (!isEmptyConent && !Children.MUTEX.isReadAccess()) {
                        Children.MUTEX.writeAccess(new Runnable(){

                            @Override
                            public void run() {
                                AdvancedTableViewVisualizer.this.explorerManager.setRootContext((Node)new AbstractNode((Children)new DataChildren(list)));
                                AdvancedTableViewVisualizer.this.setNonEmptyContent();
                            }
                        });
                    }
                }
            }
        });
    }

    private void setNonEmptyContent() {
        this.isEmptyContent = false;
        this.removeAll();
        this.add((Component)this.createToolbar(), "West");
        this.add((Component)this.outlineView, "Center");
        this.repaint();
        this.validate();
        ArrayList<Object> order = new ArrayList<Object>();
        order.add(this.outlineView);
        order.add(this.refresh);
        this.refresh.requestFocus();
    }

    private JToolBar createToolbar() {
        JToolBar buttonsToolbar = new JToolBar();
        if (isMacLaf) {
            buttonsToolbar.setBackground(macBackground);
        }
        buttonsToolbar.setFloatable(false);
        buttonsToolbar.setOrientation(1);
        buttonsToolbar.setRollover(true);
        this.refresh = new JButton();
        this.refresh.setIcon(ImageLoader.loadIcon("refresh.png"));
        this.refresh.setToolTipText(AdvancedTableViewVisualizer.getMessage("Refresh.Tooltip"));
        this.refresh.setHorizontalTextPosition(0);
        this.refresh.setVerticalTextPosition(3);
        this.refresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AdvancedTableViewVisualizer.this.asyncFillModel(false);
            }
        });
        buttonsToolbar.add(this.refresh);
        return buttonsToolbar;
    }

    public VisualizerContainer getDefaultContainer() {
        return VisualizerTopComponentTopComponent.findInstance();
    }

    @Override
    public int onTimer() {
        if (!this.isShown || !this.isShowing()) {
            return 0;
        }
        return 0;
    }

    public void refresh() {
        this.asyncFillModel(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void asyncFillModel(boolean cancelIfNotDone) {
        Object object = this.queryLock;
        synchronized (object) {
            if (this.task != null && !this.task.isDone()) {
                if (cancelIfNotDone) {
                    this.task.cancel(true);
                } else {
                    return;
                }
            }
            UIThread.invoke((Runnable)new Runnable(){

                @Override
                public void run() {
                    AdvancedTableViewVisualizer.this.setLoadingContent();
                }
            });
            this.task = DLightExecutorService.submit((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    AdvancedTableViewVisualizer.this.syncFillModel(true);
                    return Boolean.FALSE;
                }
            }, (String)("AdvancedTableViewVisualizer Async data load for " + this.configuration.getID()));
        }
    }

    private void syncFillModel(boolean wait) {
        long startTime = System.currentTimeMillis();
        Future queryDataTask = DLightExecutorService.submit((Callable)new Callable<List<DataRow>>(){

            @Override
            public List<DataRow> call() throws Exception {
                return AdvancedTableViewVisualizer.this.provider.queryData(AdvancedTableViewVisualizer.this.configuration.getMetadata());
            }
        }, (String)("AdvancedTableViewVisualizer Async data from provider  load for " + this.configuration.getID()));
        try {
            final List list = (List)queryDataTask.get();
            long endTime = System.currentTimeMillis();
            long duration = endTime - startTime;
            if (wait && duration < 500L) {
                Thread.sleep(500L - duration);
            }
            final boolean isEmptyConent = list == null || list.isEmpty();
            UIThread.invoke((Runnable)new Runnable(){

                @Override
                public void run() {
                    AdvancedTableViewVisualizer.this.setContent(isEmptyConent);
                    if (isEmptyConent) {
                        return;
                    }
                    AdvancedTableViewVisualizer.this.updateList(list);
                }
            });
        }
        catch (ExecutionException ex) {
            Thread.currentThread().interrupt();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public AdvancedTableViewVisualizerConfiguration getVisualizerConfiguration() {
        return this.configuration;
    }

    public JComponent getComponent() {
        return this.dualPaneMode ? this.dualPaneSupport : this;
    }

    @Override
    public void timerStopped() {
        if (this.isEmptyContent) {
            this.setEmptyContent();
        }
    }

    @Override
    public void componentResized(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
        if (this.isShown) {
            return;
        }
        this.isShown = this.isShowing();
    }

    @Override
    public void componentHidden(ComponentEvent e) {
        this.isShown = false;
    }

    public void updateVisualizerConfiguration(AdvancedTableViewVisualizerConfiguration configuration) {
    }

    private static String getMessage(String key) {
        return NbBundle.getMessage(AdvancedTableViewVisualizer.class, (String)key);
    }

    private class ExtendedTableCellRendererForNode
    extends DefaultTableCellRenderer {
        private ExtendedTableCellRendererForNode() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (column != 0) {
                return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
            PropertyEditor editor = PropertyEditorManager.findEditor(AdvancedTableViewVisualizer.this.configuration.getMetadata().getColumnByName(AdvancedTableViewVisualizer.this.nodeColumnName).getColumnClass());
            if (editor != null && value != null && !(value + "").trim().equals("")) {
                editor.setValue(value);
                return super.getTableCellRendererComponent(table, editor.getAsText(), isSelected, hasFocus, row, column);
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }

    private class DataRowNode
    extends AbstractNode {
        private final DataRow dataRow;
        private Node.PropertySet propertySet;

        DataRowNode(DataRow row) {
            super(Children.LEAF);
            this.dataRow = row;
            this.propertySet = new Node.PropertySet(){

                public Node.Property<?>[] getProperties() {
                    ArrayList<1> result = new ArrayList<1>();
                    for (String columnName : DataRowNode.this.dataRow.getColumnNames()) {
                        if (columnName.equals(AdvancedTableViewVisualizer.this.nodeColumnName) || columnName.equals(AdvancedTableViewVisualizer.this.nodeRowColumnID)) continue;
                        final DataTableMetadata.Column c = AdvancedTableViewVisualizer.this.configuration.getMetadata().getColumnByName(columnName);
                        PropertySupport propery = new PropertySupport(columnName, c.getColumnClass(), c.getColumnUName(), c.getColumnUName(), true, false){

                            public Object getValue() throws IllegalAccessException, InvocationTargetException {
                                return DataRowNode.this.dataRow.getData(c.getColumnName());
                            }

                            public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                            }
                        };
                        result.add(propery);
                    }
                    return result.toArray(new Node.Property[0]);
                }
            };
        }

        public DataRow getDataRow() {
            return this.dataRow;
        }

        public Image getIcon(int type) {
            if (AdvancedTableViewVisualizer.this.iconColumnID == null) {
                return super.getIcon(type);
            }
            return ImageUtilities.loadImage((String)(AdvancedTableViewVisualizer.this.resourceID + "/" + this.dataRow.getStringValue(AdvancedTableViewVisualizer.this.iconColumnID) + ".png"));
        }

        public Image getOpenedIcon(int type) {
            return this.getIcon(type);
        }

        public String getDisplayName() {
            return this.dataRow.getData(AdvancedTableViewVisualizer.this.nodeColumnName) + "";
        }

        public Node.PropertySet[] getPropertySets() {
            return new Node.PropertySet[]{this.propertySet};
        }
    }

    public class DataChildren
    extends Children.Keys<DataRow> {
        private final List<DataRow> list;

        public DataChildren(List<DataRow> list) {
            this.list = list;
        }

        protected Node[] createNodes(DataRow key) {
            return new Node[]{new DataRowNode(key)};
        }

        protected void addNotify() {
            this.setKeys(this.list);
        }
    }
}

