/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.ruby;

import java.util.ListIterator;
import java.util.Set;
import javax.swing.text.Document;
import org.jrubyparser.ast.ArgumentNode;
import org.jrubyparser.ast.ClassNode;
import org.jrubyparser.ast.ClassVarAsgnNode;
import org.jrubyparser.ast.ClassVarDeclNode;
import org.jrubyparser.ast.ClassVarNode;
import org.jrubyparser.ast.ConstNode;
import org.jrubyparser.ast.GlobalAsgnNode;
import org.jrubyparser.ast.GlobalVarNode;
import org.jrubyparser.ast.IScopingNode;
import org.jrubyparser.ast.InstAsgnNode;
import org.jrubyparser.ast.InstVarNode;
import org.jrubyparser.ast.MethodDefNode;
import org.jrubyparser.ast.ModuleNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.SClassNode;
import org.jrubyparser.ast.SymbolNode;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.netbeans.modules.refactoring.ruby.RetoucheUtils;
import org.netbeans.modules.ruby.Arity;
import org.netbeans.modules.ruby.AstPath;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.ContextKnowledge;
import org.netbeans.modules.ruby.RubyIndex;
import org.netbeans.modules.ruby.RubyType;
import org.netbeans.modules.ruby.RubyTypeInferencer;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.elements.AstElement;
import org.netbeans.modules.ruby.elements.Element;
import org.netbeans.modules.ruby.elements.IndexedElement;
import org.netbeans.modules.ruby.elements.IndexedMethod;
import org.netbeans.modules.ruby.lexer.Call;
import org.netbeans.modules.ruby.lexer.LexUtilities;
import org.openide.filesystems.FileObject;

public class RubyElementCtx {
    private Node node;
    private Node root;
    private ParserResult info;
    private FileObject fileObject;
    private AstPath path;
    private int caret;
    private BaseDocument document;
    private Element element;
    private ElementKind kind;
    private String name;
    private String simpleName;
    private Arity arity;
    private String defClass;

    public RubyElementCtx(Node root, Node node, Element element, FileObject fileObject, ParserResult info) {
        this.initialize(root, node, element, fileObject, info);
    }

    public RubyElementCtx(ParserResult parserResult, int caret) {
        Node _root = AstUtilities.getRoot((Parser.Result)parserResult);
        int astOffset = AstUtilities.getAstOffset((Parser.Result)parserResult, (int)caret);
        this.path = new AstPath(_root, astOffset);
        Node leaf = this.path.leaf();
        if (leaf == null) {
            return;
        }
        ListIterator it = this.path.leafToRoot();
        block3: while (it.hasNext()) {
            leaf = (Node)it.next();
            switch (leaf.getNodeType()) {
                case ARGUMENTNODE: 
                case LOCALVARNODE: 
                case LOCALASGNNODE: 
                case DVARNODE: 
                case DASGNNODE: 
                case SYMBOLNODE: 
                case FCALLNODE: 
                case VCALLNODE: 
                case CALLNODE: 
                case GLOBALVARNODE: 
                case GLOBALASGNNODE: 
                case INSTVARNODE: 
                case INSTASGNNODE: 
                case CLASSVARNODE: 
                case CLASSVARASGNNODE: 
                case CLASSVARDECLNODE: 
                case COLON2NODE: 
                case CONSTNODE: 
                case CONSTDECLNODE: {
                    break block3;
                }
                default: {
                    if (it.hasNext()) continue block3;
                    leaf = this.path.leaf();
                    break block3;
                }
            }
        }
        AstElement _element = AstElement.create((ParserResult)parserResult, (Node)leaf);
        this.initialize(_root, leaf, (Element)_element, RubyUtils.getFileObject((Parser.Result)parserResult), parserResult);
    }

    public RubyElementCtx(RubyElementCtx ctx, Node node) {
        AstElement _element = AstElement.create((ParserResult)this.info, (Node)node);
        this.initialize(ctx.getRoot(), node, (Element)_element, ctx.getFileObject(), ctx.getInfo());
    }

    public RubyElementCtx(IndexedElement element) {
        ParserResult[] infoHolder = new ParserResult[1];
        Node _node = AstUtilities.getForeignNode((IndexedElement)element, (Parser.Result[])infoHolder);
        ParserResult _info = infoHolder[0];
        AstElement e = AstElement.create((ParserResult)_info, (Node)_node);
        FileObject fo = element.getFileObject();
        this.document = RetoucheUtils.getDocument(null, fo);
        this.initialize(this.root, _node, (Element)e, fo, _info);
    }

    private void initialize(Node root, Node node, Element element, FileObject fileObject, ParserResult info) {
        this.root = root;
        this.node = node;
        this.element = element;
        this.fileObject = fileObject;
        this.info = info;
    }

    public Node getRoot() {
        return this.root;
    }

    public Element getElement() {
        return this.element;
    }

    public void setElement(Element element) {
        this.element = element;
    }

    public FileObject getFileObject() {
        return this.fileObject;
    }

    public void setFileObject(FileObject fileObject) {
        this.fileObject = fileObject;
    }

    public ElementKind getKind() {
        if (this.kind == null) {
            switch (this.node.getNodeType()) {
                case DEFNNODE: 
                case DEFSNODE: {
                    this.kind = AstUtilities.isConstructorMethod((MethodDefNode)((MethodDefNode)this.node)) ? ElementKind.CONSTRUCTOR : ElementKind.METHOD;
                    break;
                }
                case FCALLNODE: 
                case VCALLNODE: 
                case CALLNODE: {
                    this.kind = ElementKind.METHOD;
                    break;
                }
                case CLASSNODE: 
                case SCLASSNODE: {
                    this.kind = ElementKind.CLASS;
                    break;
                }
                case MODULENODE: {
                    this.kind = ElementKind.MODULE;
                    break;
                }
                case LOCALVARNODE: 
                case LOCALASGNNODE: 
                case DVARNODE: 
                case DASGNNODE: {
                    this.kind = ElementKind.VARIABLE;
                    break;
                }
                case ARGUMENTNODE: {
                    AstPath _path = this.getPath();
                    if (_path.leafParent() instanceof MethodDefNode) {
                        this.kind = AstUtilities.isConstructorMethod((MethodDefNode)((MethodDefNode)_path.leafParent())) ? ElementKind.CONSTRUCTOR : ElementKind.METHOD;
                        break;
                    }
                    this.kind = ElementKind.PARAMETER;
                    break;
                }
                case SYMBOLNODE: {
                    if (Character.isUpperCase(((SymbolNode)this.node).getName().charAt(0))) {
                        this.kind = ElementKind.CLASS;
                        break;
                    }
                    this.kind = ElementKind.METHOD;
                    break;
                }
                case ALIASNODE: {
                    this.kind = ElementKind.METHOD;
                    break;
                }
                case COLON2NODE: 
                case CONSTNODE: {
                    Node n = this.getPath().leafParent();
                    if (n instanceof ClassNode || n instanceof SClassNode) {
                        this.kind = ElementKind.CLASS;
                        break;
                    }
                    if (n instanceof ModuleNode) {
                        this.kind = ElementKind.MODULE;
                        break;
                    }
                    if (this.node instanceof ConstNode) {
                        this.kind = ElementKind.CLASS;
                        break;
                    }
                    this.kind = ElementKind.CONSTANT;
                    break;
                }
                case CONSTDECLNODE: {
                    this.kind = ElementKind.CONSTANT;
                    break;
                }
                case GLOBALVARNODE: 
                case GLOBALASGNNODE: {
                    this.kind = ElementKind.GLOBAL;
                    break;
                }
                case INSTVARNODE: 
                case INSTASGNNODE: 
                case CLASSVARNODE: 
                case CLASSVARASGNNODE: 
                case CLASSVARDECLNODE: {
                    this.kind = ElementKind.FIELD;
                }
            }
        }
        return this.kind;
    }

    public void setKind(ElementKind kind) {
        this.kind = kind;
    }

    public Node getNode() {
        return this.node;
    }

    public void setNode(Node node) {
        this.node = node;
    }

    public ParserResult getInfo() {
        return this.info;
    }

    public AstPath getPath() {
        if (this.path == null) {
            this.path = new AstPath(this.root, this.node);
        }
        return this.path;
    }

    public int getCaret() {
        return this.caret;
    }

    public String getName() {
        if (this.name == null) {
            String[] names = RetoucheUtils.getNodeNames(this.node);
            this.name = names[0];
            this.simpleName = names[1];
        }
        return this.name;
    }

    public String getSimpleName() {
        if (this.name == null) {
            this.getName();
        }
        return this.simpleName;
    }

    public void setNames(String name, String simpleName) {
        this.name = name;
        this.simpleName = simpleName;
    }

    public Arity getArity() {
        if (this.arity == null) {
            AstPath _path;
            if (this.node instanceof MethodDefNode) {
                this.arity = Arity.getDefArity((Node)this.node);
            } else if (AstUtilities.isCall((Node)this.node)) {
                this.arity = Arity.getCallArity((Node)this.node);
            } else if (this.node instanceof ArgumentNode && (_path = this.getPath()).leafParent() instanceof MethodDefNode) {
                this.arity = Arity.getDefArity((Node)_path.leafParent());
            }
        }
        return this.arity;
    }

    public BaseDocument getDocument() {
        if (this.document == null) {
            this.document = RetoucheUtils.getDocument(this.info, RubyUtils.getFileObject((Parser.Result)this.info));
        }
        return this.document;
    }

    private String getViewControllerRequire(FileObject view) {
        return null;
    }

    public String getDefClass() {
        if (this.defClass == null) {
            if (RubyUtils.isRhtmlFile((FileObject)this.fileObject)) {
                this.defClass = "ActionView::Base";
            } else if (AstUtilities.isCall((Node)this.node)) {
                BaseDocument doc = this.getDocument();
                TokenHierarchy th = TokenHierarchy.get((Document)doc);
                int astOffset = AstUtilities.getCallRange((Node)this.node).getStart();
                Call call = Call.getCallType((BaseDocument)doc, (TokenHierarchy)th, (int)astOffset);
                int lexOffset = LexUtilities.getLexerOffset((Parser.Result)this.info, (int)astOffset);
                RubyType types = RubyType.unknown();
                RubyType callType = call.getType();
                if (callType.isKnown() && !call.isLHSConstant()) {
                    types = callType;
                }
                String lhs = call.getLhs();
                if (!types.isKnown() && lhs != null && this.node != null && call.isSimpleIdentifier()) {
                    Node method = AstUtilities.findLocalScope((Node)this.node, (AstPath)this.getPath());
                    if (method != null) {
                        ContextKnowledge knowledge = new ContextKnowledge(null, method, this.node, astOffset, lexOffset, this.info);
                        RubyTypeInferencer rti = RubyTypeInferencer.create((ContextKnowledge)knowledge, (boolean)false);
                        types = rti.inferType(lhs);
                    }
                } else if (call == Call.LOCAL) {
                    Set methods;
                    IndexedMethod method;
                    RubyIndex index = RubyIndex.get((Parser.Result)this.info);
                    String fqn = AstUtilities.getFqnName((AstPath)this.getPath());
                    if (fqn == null || fqn.length() == 0) {
                        fqn = "Object";
                    }
                    IndexedMethod indexedMethod = method = !(methods = index.getMethods(this.getName(), fqn, QuerySupport.Kind.EXACT)).isEmpty() ? (IndexedMethod)methods.iterator().next() : index.getSuperMethod(fqn, this.getName(), false);
                    if (method != null) {
                        this.defClass = method.getIn();
                    }
                }
                if (this.defClass == null) {
                    this.defClass = !types.isKnown() && (lhs == null || "self".equals(lhs)) ? AstUtilities.getFqnName((AstPath)this.getPath()) : (types.isKnown() ? (types.isSingleton() ? types.first() : null) : "<Unknown>");
                }
            } else {
                IScopingNode clz;
                if (this.getPath() != null && (clz = AstUtilities.findClassOrModule((AstPath)this.getPath())) != null) {
                    this.defClass = AstUtilities.getClassOrModuleName((IScopingNode)clz);
                }
                if (this.defClass == null && this.element != null) {
                    this.defClass = this.element.getIn();
                }
                if (this.defClass == null) {
                    this.defClass = "Object";
                }
            }
        }
        return this.defClass;
    }

    public String toString() {
        return "node= " + this.node + ";kind=" + this.getKind() + ";" + super.toString();
    }

    public String getStripPrefix() {
        if (this.node instanceof GlobalVarNode || this.node instanceof GlobalAsgnNode) {
            return "$";
        }
        if (this.node instanceof InstVarNode || this.node instanceof InstAsgnNode) {
            return "@";
        }
        if (this.node instanceof ClassVarNode || this.node instanceof ClassVarDeclNode || this.node instanceof ClassVarAsgnNode) {
            return "@@";
        }
        return null;
    }
}

