/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.retriever.impl;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Map;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.xml.retriever.RetrieveEntry;
import org.netbeans.modules.xml.retriever.Retriever;
import org.netbeans.modules.xml.retriever.XMLCatalogProvider;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.retriever.impl.RetrieverEngineImpl;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class RetrieverImpl
extends Retriever {
    File seedFile = null;
    RetrieverEngineImpl instance;
    private boolean newThread = false;
    boolean retrieveRecursively = true;
    boolean overwriteFiles = true;

    void setNewThread(boolean thread) {
        this.newThread = thread;
    }

    @Override
    public FileObject retrieveResource(FileObject destinationDir, URI relativePathToCatalogFile, URI resourceToRetrieve) throws UnknownHostException, URISyntaxException, IOException {
        return this.retrieveResource(destinationDir, relativePathToCatalogFile, resourceToRetrieve, false);
    }

    @Override
    public FileObject retrieveResource(FileObject destinationDir, URI resourceToRetrieve) throws UnknownHostException, URISyntaxException, IOException {
        return this.retrieveResource(destinationDir, null, resourceToRetrieve);
    }

    @Override
    public FileObject retrieveResourceClosureIntoSingleDirectory(FileObject destinationDir, URI resourceToRetrieve) throws UnknownHostException, URISyntaxException, IOException {
        return this.retrieveResource(destinationDir, null, resourceToRetrieve, true);
    }

    public FileObject retrieveResource(FileObject destinationDir, URI relativePathToCatalogFile, URI resourceToRetrieve, boolean save2singleFolder) throws UnknownHostException, URISyntaxException, IOException {
        Project prj = FileOwnerQuery.getOwner((FileObject)destinationDir);
        if (relativePathToCatalogFile == null) {
            assert (prj != null);
            XMLCatalogProvider catProvider = (XMLCatalogProvider)prj.getLookup().lookup(XMLCatalogProvider.class);
            if (catProvider == null) {
                return this.retrieveResourceImpl(destinationDir, resourceToRetrieve, null, save2singleFolder);
            }
            relativePathToCatalogFile = catProvider.getProjectWideCatalog();
            if (relativePathToCatalogFile == null) {
                return this.retrieveResourceImpl(destinationDir, resourceToRetrieve, null, save2singleFolder);
            }
        }
        URI cfuri = null;
        if (!relativePathToCatalogFile.isAbsolute()) {
            FileObject prjRtFO = prj.getProjectDirectory();
            cfuri = FileUtil.toFile((FileObject)prjRtFO).toURI().resolve(relativePathToCatalogFile);
        } else {
            cfuri = relativePathToCatalogFile;
        }
        File cffile = new File(cfuri);
        if (!cffile.isFile()) {
            cffile.createNewFile();
        }
        FileObject catalogFileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)cffile));
        return this.retrieveResourceImpl(destinationDir, resourceToRetrieve, catalogFileObject, save2singleFolder);
    }

    private FileObject retrieveResourceImpl(FileObject destinationDir, URI resourceToRetrieve, FileObject catalogFileObject, boolean save2singleFolder) throws UnknownHostException, URISyntaxException, IOException {
        File result;
        this.instance = new RetrieverEngineImpl(FileUtil.toFile((FileObject)destinationDir), this.newThread);
        this.instance.setFileOverwrite(this.overwriteFiles);
        this.instance.setSave2SingleFolder(save2singleFolder);
        if (catalogFileObject != null) {
            this.instance.setCatalogFile(catalogFileObject);
        }
        this.instance.setShowErrorPopup(false);
        RetrieveEntry rent = null;
        rent = new RetrieveEntry(null, resourceToRetrieve.toString(), null, null, Utilities.DocumentTypesEnum.schema, this.retrieveRecursively);
        this.instance.addResourceToRetrieve(rent);
        this.instance.start();
        this.seedFile = result = this.instance.getSeedFileLocation();
        if (result == null) {
            return null;
        }
        return FileUtil.toFileObject((File)FileUtil.normalizeFile((File)result));
    }

    private Project getProject(File result) {
        FileObject fob = FileUtil.toFileObject((File)result);
        return FileOwnerQuery.getOwner((FileObject)fob);
    }

    @Override
    public File getProjectCatalog() {
        if (this.seedFile == null) {
            return null;
        }
        FileObject prjRootFo = this.getProject(this.seedFile).getProjectDirectory();
        File prjRt = FileUtil.toFile((FileObject)prjRootFo);
        File catalogFile = new File(prjRt, "catalog.xml");
        return catalogFile;
    }

    @Override
    public Map<RetrieveEntry, Exception> getRetrievedResourceExceptionMap() {
        if (this.instance != null) {
            return this.instance.getRetrievedResourceExceptionMap();
        }
        return null;
    }

    @Override
    public File retrieveResource(File targetFolder, URI source) throws UnknownHostException, URISyntaxException, IOException {
        FileObject fobj = this.retrieveResource(FileUtil.toFileObject((File)FileUtil.normalizeFile((File)targetFolder)), source);
        if (fobj != null) {
            return FileUtil.toFile((FileObject)fobj);
        }
        return null;
    }

    @Override
    public void setRecursiveRetrieve(boolean retrieveRecursively) {
        this.retrieveRecursively = retrieveRecursively;
    }

    @Override
    public void setOverwriteFilesWithSameName(boolean overwriteFiles) {
        this.overwriteFiles = overwriteFiles;
    }
}

