/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.perfan.spi;

import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.api.extexecution.input.InputProcessor;
import org.netbeans.api.extexecution.input.InputProcessors;
import org.netbeans.modules.dlight.api.datafilter.DataFilter;
import org.netbeans.modules.dlight.api.execution.AttachableTarget;
import org.netbeans.modules.dlight.api.execution.DLightTarget;
import org.netbeans.modules.dlight.api.execution.DLightTargetChangeEvent;
import org.netbeans.modules.dlight.api.execution.ValidationListener;
import org.netbeans.modules.dlight.api.execution.ValidationStatus;
import org.netbeans.modules.dlight.api.storage.DataRow;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.management.api.DLightManager;
import org.netbeans.modules.dlight.perfan.SunStudioDCConfiguration;
import org.netbeans.modules.dlight.perfan.impl.SunStudioDCConfigurationAccessor;
import org.netbeans.modules.dlight.perfan.spi.MonitorsUpdateService;
import org.netbeans.modules.dlight.perfan.spi.datafilter.CollectedObjectsFilter;
import org.netbeans.modules.dlight.perfan.spi.datafilter.SunStudioFiltersProvider;
import org.netbeans.modules.dlight.perfan.spi.datafilter.THAFilter;
import org.netbeans.modules.dlight.perfan.spi.datafilter.THAStartupFilter;
import org.netbeans.modules.dlight.perfan.storage.impl.PerfanDataStorage;
import org.netbeans.modules.dlight.spi.SunStudioLocator;
import org.netbeans.modules.dlight.spi.SunStudioLocatorFactory;
import org.netbeans.modules.dlight.spi.collector.DataCollector;
import org.netbeans.modules.dlight.spi.collector.DataCollectorListener;
import org.netbeans.modules.dlight.spi.indicator.IndicatorDataProvider;
import org.netbeans.modules.dlight.spi.storage.DataStorage;
import org.netbeans.modules.dlight.spi.storage.DataStorageType;
import org.netbeans.modules.dlight.util.DLightExecutorService;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.netbeans.modules.dlight.util.usagetracking.SunStudioUserCounter;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.AsynchronousAction;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.InputOutput;

public class SunStudioDataCollector
extends IndicatorDataProvider<SunStudioDCConfiguration>
implements DataCollector<SunStudioDCConfiguration>,
SunStudioFiltersProvider {
    private static final String COLLECTOR_NAME = "SunStudio";
    private static final DataStorageType supportedStorageType;
    private static final AtomicInteger uid;
    private static final Logger log;
    private static final DataTableMetadata cpuInfoTable;
    private static final DataTableMetadata syncInfoTable;
    private static final DataTableMetadata memInfoTable;
    private static final DataTableMetadata summaryInfoTable;
    private static final DataTableMetadata memSummaryInfoTable;
    private static final DataTableMetadata deadlocksSummaryInfoTable;
    private static final DataTableMetadata dataracesSummaryInfoTable;
    private final Object lock = SunStudioDataCollector.class.getName() + "Lock";
    private final Collection<DataTableMetadata> dataTablesMetadata;
    private final Collection<ValidationListener> validationListeners;
    private final Set<SunStudioDCConfiguration.CollectedInfo> collectedInfo;
    private final List<DataFilter> dataFilters;
    private ValidationStatus validationStatus = ValidationStatus.initialStatus();
    private CollectorConfiguration config = null;
    private DLightTarget validatedTarget;
    private Future<Integer> collectTaskResult = null;
    private MonitorsUpdateService monitorsUpdater = null;
    private String cmd;
    private String sproHome;
    private boolean isAttachable = true;
    private HostInfo hostInfo = null;
    private final List<DataCollectorListener> listeners = new ArrayList<DataCollectorListener>();

    public SunStudioDataCollector(Set<SunStudioDCConfiguration.CollectedInfo> collectedInfoList) {
        this.collectedInfo = EnumSet.noneOf(SunStudioDCConfiguration.CollectedInfo.class);
        this.dataTablesMetadata = new HashSet<DataTableMetadata>();
        this.validationListeners = new CopyOnWriteArraySet<ValidationListener>();
        this.dataFilters = new ArrayList<DataFilter>();
        this.addCollectedInfo(collectedInfoList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addCollectedInfo(Set<SunStudioDCConfiguration.CollectedInfo> collectedInfoList) {
        Object object = this.lock;
        synchronized (object) {
            this.collectedInfo.addAll(collectedInfoList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addDataCollectorListener(DataCollectorListener listener) {
        if (listener == null) {
            return;
        }
        SunStudioDataCollector sunStudioDataCollector = this;
        synchronized (sunStudioDataCollector) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeDataCollectorListener(DataCollectorListener listener) {
        SunStudioDataCollector sunStudioDataCollector = this;
        synchronized (sunStudioDataCollector) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void notifyListeners(final DataCollector.CollectorState state) {
        DataCollectorListener[] ll;
        SunStudioDataCollector sunStudioDataCollector = this;
        synchronized (sunStudioDataCollector) {
            ll = this.listeners.toArray(new DataCollectorListener[0]);
        }
        final CountDownLatch doneFlag = new CountDownLatch(ll.length);
        for (final DataCollectorListener l : ll) {
            DLightExecutorService.submit((Runnable)new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        l.collectorStateChanged((DataCollector)SunStudioDataCollector.this, state);
                    }
                    finally {
                        doneFlag.countDown();
                    }
                }
            }, (String)("Notifying " + l));
        }
        try {
            doneFlag.await();
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
    }

    public void targetStateChanged(DLightTargetChangeEvent event) {
        switch (event.state) {
            case STARTING: {
                return;
            }
            case RUNNING: {
                this.targetStarted(event.target);
                return;
            }
            case FAILED: {
                this.targetFinished(event.target);
                return;
            }
            case TERMINATED: {
                this.targetFinished(event.target);
                return;
            }
            case DONE: {
                this.targetFinished(event.target);
                return;
            }
            case STOPPED: {
                this.targetFinished(event.target);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValidationStatus validate(DLightTarget target) {
        Object object = this.lock;
        synchronized (object) {
            if (this.validationStatus.isKnown()) {
                return this.validationStatus;
            }
            ExecutionEnvironment execEnv = target.getExecEnv();
            String command = null;
            String sprohome = null;
            try {
                this.hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)execEnv);
                switch (this.hostInfo.getOSFamily()) {
                    case LINUX: 
                    case SUNOS: {
                        break;
                    }
                    default: {
                        this.validationStatus = ValidationStatus.invalidStatus((String)SunStudioDataCollector.loc("ValidationStatus.UnsupportedPlatform", new String[0]));
                        return this.validationStatus;
                    }
                }
                Collection factories = Lookup.getDefault().lookupAll(SunStudioLocatorFactory.class);
                boolean notFound = true;
                block9: for (SunStudioLocatorFactory factory : factories) {
                    Collection ssDescriptions = factory.getInstance(execEnv).getSunStudioLocations();
                    for (SunStudioLocator.SunStudioDescription ss : ssDescriptions) {
                        sprohome = ss.getPath();
                        command = sprohome + "/bin/collect";
                        if (!HostInfoUtils.fileExists((ExecutionEnvironment)execEnv, (String)command)) continue;
                        notFound = false;
                        continue block9;
                    }
                }
                if (notFound) {
                    this.validationStatus = ValidationStatus.invalidStatus((String)SunStudioDataCollector.loc("ValidationStatus.NoSunStudioFound.html", new String[0]));
                    return this.validationStatus;
                }
            }
            catch (IOException ex) {
                ConnectionManager mgr = ConnectionManager.getInstance();
                Runnable onConnect = new Runnable(){

                    @Override
                    public void run() {
                        DLightManager.getDefault().revalidateSessions();
                    }
                };
                AsynchronousAction connectAction = mgr.getConnectToAction(execEnv, onConnect);
                this.validationStatus = ValidationStatus.unknownStatus((String)SunStudioDataCollector.loc("ValidationStatus.ErrorWhileValidation", ex.getMessage()), (AsynchronousAction)connectAction);
                return this.validationStatus;
            }
            catch (InterruptedException ex) {
                this.validationStatus = ValidationStatus.invalidStatus((String)SunStudioDataCollector.loc("ValidationStatus.InterruptedWhileValidation", new String[0]));
                return this.validationStatus;
            }
            this.validateCollectedInfo();
            this.validationStatus = ValidationStatus.validStatus();
            this.cmd = command;
            this.sproHome = sprohome;
            this.validatedTarget = target;
            SunStudioUserCounter.countGizmo(sprohome, (ExecutionEnvironment)execEnv);
            return this.validationStatus;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate() {
        Object object = this.lock;
        synchronized (object) {
            this.validationStatus = ValidationStatus.initialStatus();
            this.validatedTarget = null;
            this.config = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValidationStatus getValidationStatus() {
        Object object = this.lock;
        synchronized (object) {
            return this.validationStatus;
        }
    }

    public void addValidationListener(ValidationListener listener) {
        this.validationListeners.add(listener);
    }

    public void removeValidationListener(ValidationListener listener) {
        this.validationListeners.remove(listener);
    }

    public Collection<DataStorageType> getRequiredDataStorageTypes() {
        return Collections.singletonList(supportedStorageType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DataTableMetadata> getDataTablesMetadata() {
        Object object = this.lock;
        synchronized (object) {
            return new ArrayList<DataTableMetadata>(this.dataTablesMetadata);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateCollectedInfo() {
        Object object = this.lock;
        synchronized (object) {
            EnumSet<SunStudioDCConfiguration.CollectedInfo> ci = EnumSet.copyOf(this.collectedInfo);
            HashSet<DataTableMetadata> dtm = new HashSet<DataTableMetadata>();
            boolean bAttachable = true;
            boolean isChanged = false;
            if (ci.contains((Object)SunStudioDCConfiguration.CollectedInfo.DEADLOCKS) || ci.contains((Object)SunStudioDCConfiguration.CollectedInfo.DATARACES)) {
                isChanged = ci.retainAll(EnumSet.of(SunStudioDCConfiguration.CollectedInfo.DEADLOCKS, SunStudioDCConfiguration.CollectedInfo.DATARACES));
            }
            if (!isChanged) {
                for (SunStudioDCConfiguration.CollectedInfo info : this.collectedInfo) {
                    ci.add(info);
                    switch (info) {
                        case FUNCTIONS_LIST: {
                            dtm.add(cpuInfoTable);
                            break;
                        }
                        case MEMORY: {
                            dtm.add(memInfoTable);
                            bAttachable = false;
                            break;
                        }
                        case MEMSUMMARY: {
                            dtm.add(memSummaryInfoTable);
                            bAttachable = false;
                            break;
                        }
                        case SYNCHRONIZATION: {
                            dtm.add(syncInfoTable);
                            bAttachable = false;
                            break;
                        }
                        case SYNCSUMMARY: {
                            dtm.add(summaryInfoTable);
                            bAttachable = false;
                            break;
                        }
                        case DEADLOCKS: {
                            dtm.add(deadlocksSummaryInfoTable);
                            bAttachable = false;
                            break;
                        }
                        case DATARACES: {
                            dtm.add(dataracesSummaryInfoTable);
                            bAttachable = false;
                        }
                    }
                }
            } else {
                for (SunStudioDCConfiguration.CollectedInfo info : ci) {
                    switch (info) {
                        case DEADLOCKS: {
                            dtm.add(deadlocksSummaryInfoTable);
                            bAttachable = false;
                            break;
                        }
                        case DATARACES: {
                            dtm.add(dataracesSummaryInfoTable);
                            bAttachable = false;
                        }
                    }
                }
            }
            this.collectedInfo.clear();
            this.collectedInfo.addAll(ci);
            this.dataTablesMetadata.clear();
            this.dataTablesMetadata.addAll(dtm);
            this.isAttachable = bAttachable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(Map<DataStorageType, DataStorage> storages, DLightTarget target) {
        Object object = this.lock;
        synchronized (object) {
            DataStorage storage = storages.get(supportedStorageType);
            if (!(storage instanceof PerfanDataStorage)) {
                throw new IllegalArgumentException("Storage " + storage + " cannot be used for PerfanDataCollector!");
            }
            DLightLogger.assertTrue((this.validatedTarget == target ? 1 : 0) != 0, (String)"Validation was performed against another target");
            String experimentDir = this.hostInfo.getTempDir() + "/experiment_" + uid.incrementAndGet() + ".er";
            this.config = new CollectorConfiguration((PerfanDataStorage)storage, target, target.getExecEnv(), experimentDir, this.sproHome, this.collectedInfo);
            this.reinit();
        }
    }

    @Override
    public List<DataFilter> getDataFilters() {
        return this.dataFilters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reinit() {
        boolean result = true;
        Object object = this.lock;
        synchronized (object) {
            try {
                result = this.prepareExperimentDirectory(this.config.execEnv, this.config.experimentDirectory);
                if (result) {
                    this.config.dataStorage.init(this.config.execEnv, this.config.sproHome, this.config.experimentDirectory, this);
                    this.monitorsUpdater = new MonitorsUpdateService(this, this.config.execEnv, this.config.sproHome, this.config.experimentDirectory, this.config.collectedInfo);
                }
            }
            catch (Throwable ex) {
                result = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAttachable() {
        Object object = this.lock;
        synchronized (object) {
            return this.isAttachable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCmd() {
        Object object = this.lock;
        synchronized (object) {
            return this.cmd;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getArgs() {
        Object object = this.lock;
        synchronized (object) {
            boolean dataraces;
            if (this.cmd == null) {
                throw new IllegalStateException("Args can be retrieved for validated and valid collector only");
            }
            ArrayList<String> args = new ArrayList<String>();
            if (!log.isLoggable(Level.FINEST)) {
                args.add("-O");
                args.add("/dev/null");
            }
            boolean deadlocks = this.collectedInfo.contains((Object)SunStudioDCConfiguration.CollectedInfo.DEADLOCKS);
            THAFilter thaFilter = null;
            THAStartupFilter thaStartupFilter = null;
            for (DataFilter dataFilter : this.dataFilters) {
                if (dataFilter instanceof THAFilter) {
                    thaFilter = (THAFilter)dataFilter;
                    continue;
                }
                if (!(dataFilter instanceof THAStartupFilter)) continue;
                thaStartupFilter = (THAStartupFilter)dataFilter;
            }
            boolean bl = dataraces = this.collectedInfo.contains((Object)SunStudioDCConfiguration.CollectedInfo.DATARACES) && (thaFilter == null || thaFilter.getType().equals((Object)THAFilter.CollectedDataType.DATARACES));
            if (deadlocks || dataraces) {
                args.add("-r");
                if (deadlocks && dataraces) {
                    args.add("deadlocks,races");
                } else if (deadlocks) {
                    args.add("deadlocks");
                } else if (dataraces) {
                    args.add("races");
                }
                args.add("-y");
                if (thaStartupFilter != null && thaStartupFilter.getStartMode() == THAStartupFilter.StartMode.STARTUP) {
                    args.add("USR1,r");
                } else {
                    args.add("USR1");
                }
            } else {
                if (this.collectedInfo.contains((Object)SunStudioDCConfiguration.CollectedInfo.SYNCHRONIZATION) || this.collectedInfo.contains((Object)SunStudioDCConfiguration.CollectedInfo.SYNCSUMMARY)) {
                    args.add("-s");
                    args.add("1000");
                }
                if (this.collectedInfo.contains((Object)SunStudioDCConfiguration.CollectedInfo.MEMORY) || this.collectedInfo.contains((Object)SunStudioDCConfiguration.CollectedInfo.MEMSUMMARY)) {
                    args.add("-H");
                    args.add("on");
                }
            }
            args.add("-o");
            args.add(this.config.experimentDirectory);
            return args.toArray(new String[0]);
        }
    }

    public String getName() {
        return COLLECTOR_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void targetFinished(DLightTarget source) {
        Object object = this.lock;
        synchronized (object) {
            log.fine("Stopping PerfanDataCollector: " + this.cmd);
            if (this.isAttachable() && this.collectTaskResult != null) {
                this.collectTaskResult.cancel(true);
            }
            this.collectTaskResult = null;
            if (this.monitorsUpdater != null) {
                this.monitorsUpdater.stop();
            }
        }
    }

    protected void updateIndicators(List<DataRow> data) {
        this.notifyIndicators(data);
    }

    void notifyIndicatorsThatProviderFinished() {
        super.suggestIndicatorsRepaint();
        this.notifyIndicators(Arrays.asList(new DataRow(Arrays.asList("sunstudio.finished"), Arrays.asList(Boolean.TRUE))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void targetStarted(DLightTarget source) {
        Object object = this.lock;
        synchronized (object) {
            if (source != this.config.target) {
                return;
            }
            if (this.isAttachable()) {
                AttachableTarget at = (AttachableTarget)this.config.target;
                NativeProcessBuilder npb = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)this.config.execEnv);
                npb.setExecutable(this.cmd);
                npb.setArguments(new String[]{"-P", "" + at.getPID(), "-o", this.config.experimentDirectory});
                ExecutionDescriptor descr = new ExecutionDescriptor();
                if (log.isLoggable(Level.FINEST)) {
                    descr = descr.errProcessorFactory((ExecutionDescriptor.InputProcessorFactory)new StdErrRedirectorFactory());
                    descr = descr.outProcessorFactory((ExecutionDescriptor.InputProcessorFactory)new StdErrRedirectorFactory());
                }
                descr = descr.inputOutput(InputOutput.NULL);
                ExecutionService service = ExecutionService.newService((Callable)npb, (ExecutionDescriptor)descr, (String)"collect");
                this.collectTaskResult = service.run();
            }
            if (this.monitorsUpdater != null) {
                this.monitorsUpdater.start();
            }
        }
    }

    private static String loc(String key, String ... params) {
        return NbBundle.getMessage(SunStudioDataCollector.class, (String)key, (Object[])params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dataFiltersChanged(List<DataFilter> newSet, boolean isAdjusting) {
        List<DataFilter> list = this.dataFilters;
        synchronized (list) {
            this.dataFilters.clear();
            for (DataFilter filter : newSet) {
                if (filter instanceof CollectedObjectsFilter) {
                    this.dataFilters.add(filter);
                    continue;
                }
                if (filter instanceof THAFilter) {
                    this.dataFilters.add(filter);
                    continue;
                }
                if (!(filter instanceof THAStartupFilter)) continue;
                this.dataFilters.add(filter);
            }
        }
    }

    private boolean prepareExperimentDirectory(ExecutionEnvironment execEnv, String experimentDirectory) {
        log.fine("Prepare PerfanDataCollector. Clean directory " + experimentDirectory);
        boolean result = true;
        try {
            Integer rmResult = null;
            Future rmFuture = CommonTasksSupport.rmDir((ExecutionEnvironment)execEnv, (String)experimentDirectory, (boolean)true, null);
            rmResult = (Integer)rmFuture.get();
            if (rmResult == null || rmResult != 0) {
                log.info("SunStudioDataCollector: unable to delete directory " + execEnv.toString() + ":" + experimentDirectory);
                result = false;
            }
            if (result) {
                File lockFile = new File(new File(experimentDirectory).getParentFile(), "_collector_directory_lock");
                rmFuture = CommonTasksSupport.rmFile((ExecutionEnvironment)execEnv, (String)lockFile.getPath(), null);
                rmResult = (Integer)rmFuture.get();
            }
        }
        catch (Throwable th) {
            result = false;
        }
        if (!result) {
            log.severe("Unable to prepare an experiment directory!");
        }
        return result;
    }

    static {
        uid = new AtomicInteger(0);
        log = DLightLogger.getLogger(SunStudioDataCollector.class);
        SunStudioDCConfigurationAccessor dcAccess = SunStudioDCConfigurationAccessor.getDefault();
        supportedStorageType = PerfanDataStorage.storageType;
        cpuInfoTable = new DataTableMetadata(dcAccess.getCPUTableName(), Arrays.asList(SunStudioDCConfiguration.c_name, SunStudioDCConfiguration.c_iUser, SunStudioDCConfiguration.c_eUser), null);
        syncInfoTable = new DataTableMetadata(dcAccess.getSyncTableName(), Arrays.asList(SunStudioDCConfiguration.c_name, SunStudioDCConfiguration.c_eSync, SunStudioDCConfiguration.c_eSyncn), null);
        memInfoTable = new DataTableMetadata(dcAccess.getMemTableName(), Arrays.asList(SunStudioDCConfiguration.c_name, SunStudioDCConfiguration.c_leakCount, SunStudioDCConfiguration.c_leakSize), null);
        summaryInfoTable = new DataTableMetadata("SunStudioSummaryData", Arrays.asList(SunStudioDCConfiguration.c_ulockSummary), null);
        memSummaryInfoTable = new DataTableMetadata("SunStudioMemorySummaryData", Arrays.asList(SunStudioDCConfiguration.c_leakSize), null);
        deadlocksSummaryInfoTable = new DataTableMetadata(dcAccess.getDeadlockTableName(), Arrays.asList(SunStudioDCConfiguration.c_Deadlocks), null);
        dataracesSummaryInfoTable = new DataTableMetadata(dcAccess.getDataraceTableName(), Arrays.asList(SunStudioDCConfiguration.c_Datarace), null);
    }

    private static class CollectorConfiguration {
        final PerfanDataStorage dataStorage;
        final DLightTarget target;
        final ExecutionEnvironment execEnv;
        final String experimentDirectory;
        final String sproHome;
        final Set<SunStudioDCConfiguration.CollectedInfo> collectedInfo;

        public CollectorConfiguration(PerfanDataStorage dataStorage, DLightTarget target, ExecutionEnvironment execEnv, String experimentDirectory, String sproHome, Set<SunStudioDCConfiguration.CollectedInfo> collectedInfo) {
            this.target = target;
            this.dataStorage = dataStorage;
            this.execEnv = execEnv;
            this.experimentDirectory = experimentDirectory;
            this.sproHome = sproHome;
            this.collectedInfo = Collections.unmodifiableSet(EnumSet.copyOf(collectedInfo));
        }
    }

    private static class StdErrRedirectorFactory
    implements ExecutionDescriptor.InputProcessorFactory {
        private StdErrRedirectorFactory() {
        }

        public InputProcessor newInputProcessor(InputProcessor p) {
            return InputProcessors.copying((Writer)new OutputStreamWriter(System.err){
                final StringBuilder sb;
                static final String prefix = "!!!!! COLLECTOR SAYS !!!! : ";
                {
                    this.sb = new StringBuilder();
                }

                @Override
                public void write(char[] chars) throws IOException {
                    this.sb.setLength(0);
                    this.sb.append(prefix);
                    for (int i = 0; i < chars.length; ++i) {
                        this.sb.append(chars[i]);
                        if (i >= chars.length - 1 || chars[i] != '\n') continue;
                        this.sb.append(prefix);
                    }
                    super.write(this.sb.toString().toCharArray());
                }
            });
        }
    }
}

