/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output2;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.logging.Logger;
import org.netbeans.core.output2.AbstractLines;
import org.netbeans.core.output2.Controller;
import org.netbeans.core.output2.OutWriter;
import org.netbeans.core.output2.Storage;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

class FileMapStorage
implements Storage {
    private FileChannel fileChannel;
    private static final int BASE_BUFFER_SIZE = 8196;
    private static final long MAX_MAP_RANGE = 0x100000L;
    private static final RequestProcessor RP = new RequestProcessor("FileMapStorage");
    private ByteBuffer master;
    private ByteBuffer contents;
    private long mappedRange;
    private long mappedStart;
    private ByteBuffer buffer = null;
    protected int bytesWritten = 0;
    private File outfile = null;
    private int outstandingBufferCount = 0;
    private boolean closed;

    FileMapStorage() {
        this.init();
    }

    private void init() {
        this.contents = null;
        this.mappedRange = -1L;
        this.mappedStart = 0L;
        this.master = ByteBuffer.allocateDirect(8196);
        this.fileChannel = null;
        this.buffer = null;
        this.bytesWritten = 0;
        this.closed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void ensureFileExists() throws IOException {
        File dir;
        if (this.outfile != null) return;
        String outdir = System.getProperty("java.io.tmpdir");
        if (!outdir.endsWith(File.separator)) {
            outdir = outdir + File.separator;
        }
        if (!(dir = new File(outdir)).exists()) {
            IllegalStateException ise = new IllegalStateException("Cannot find temp directory " + outdir);
            Exceptions.attachLocalizedMessage((Throwable)ise, (String)NbBundle.getMessage(OutWriter.class, (String)"FMT_CannotWrite", (Object)outdir));
            throw ise;
        }
        Class<FileMapStorage> clazz = FileMapStorage.class;
        synchronized (FileMapStorage.class) {
            StringBuilder fname = new StringBuilder(outdir).append("output").append(Long.toString(System.currentTimeMillis()));
            this.outfile = new File(fname.toString());
            while (this.outfile.exists()) {
                fname.append('x');
                this.outfile = new File(fname.toString());
            }
            this.outfile.createNewFile();
            if (!this.outfile.exists() || !this.outfile.canWrite()) {
                IllegalStateException ise = new IllegalStateException("Cannot write to " + fname);
                Exceptions.attachLocalizedMessage((Throwable)ise, (String)NbBundle.getMessage(OutWriter.class, (String)"FMT_CannotWrite", (Object)outdir));
                throw ise;
            }
            this.outfile.deleteOnExit();
            // ** MonitorExit[var3_4] (shouldn't be in output)
            return;
        }
    }

    public String toString() {
        return this.outfile == null ? "[unused or disposed FileMapStorage]" : this.outfile.getPath();
    }

    private FileChannel writeChannel() {
        FileChannel channel = this.fileChannel();
        this.closed = !channel.isOpen();
        return channel;
    }

    private FileChannel fileChannel() {
        try {
            if (this.fileChannel == null || !this.fileChannel.isOpen()) {
                this.ensureFileExists();
                RandomAccessFile raf = new RandomAccessFile(this.outfile, "rw");
                this.fileChannel = raf.getChannel();
            }
            return this.fileChannel;
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return null;
    }

    @Override
    public synchronized ByteBuffer getWriteBuffer(int size) {
        if (this.master.capacity() - this.master.position() < size) {
            int newSize = Math.max(16392, size + 8196);
            this.master = ByteBuffer.allocateDirect(newSize);
        }
        if (this.buffer == null) {
            this.buffer = this.master.slice();
        } else {
            int charsRemaining = AbstractLines.toCharIndex(this.buffer.capacity() - this.buffer.position());
            if (charsRemaining < size) {
                this.buffer.flip();
                this.buffer = this.master.slice();
            }
        }
        ++this.outstandingBufferCount;
        return this.buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(ByteBuffer bb) throws IOException {
        FileMapStorage fileMapStorage = this;
        synchronized (fileMapStorage) {
            if (bb == this.buffer) {
                this.buffer = null;
            }
        }
        int position = this.size();
        int byteCount = bb.position();
        bb.flip();
        FileChannel channel = this.writeChannel();
        if (channel.isOpen()) {
            Thread.interrupted();
            channel.write(bb);
            FileMapStorage fileMapStorage2 = this;
            synchronized (fileMapStorage2) {
                this.bytesWritten += byteCount;
                --this.outstandingBufferCount;
            }
        }
        return position;
    }

    @Override
    public synchronized void dispose() {
        if (Controller.LOG) {
            Controller.log("Disposing file map storage");
            Controller.logStack();
        }
        final FileChannel oldChannel = this.fileChannel;
        final File oldFile = this.outfile;
        final MappedByteBuffer mbb = this.contents instanceof MappedByteBuffer ? (MappedByteBuffer)this.contents : null;
        this.fileChannel = null;
        this.closed = true;
        this.outfile = null;
        this.buffer = null;
        this.contents = null;
        if (oldChannel != null || oldFile != null) {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (mbb != null) {
                            FileMapStorage.this.unmap(mbb);
                        }
                        if (oldChannel != null && oldChannel.isOpen()) {
                            oldChannel.close();
                        }
                        if (oldFile != null && oldFile.exists()) {
                            oldFile.delete();
                        }
                    }
                    catch (Exception e) {
                        Exceptions.printStackTrace((Throwable)e);
                    }
                }
            });
        }
    }

    File getOutputFile() {
        return this.outfile;
    }

    private void unmap(Object buffer) {
        try {
            Method getCleanerMethod = buffer.getClass().getMethod("cleaner", new Class[0]);
            getCleanerMethod.setAccessible(true);
            Object cleaner = getCleanerMethod.invoke(buffer, new Object[0]);
            cleaner.getClass().getMethod("clean", new Class[0]).invoke(cleaner, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer getReadBuffer(int start, int byteCount) throws IOException {
        ByteBuffer cont;
        FileMapStorage fileMapStorage = this;
        synchronized (fileMapStorage) {
            cont = this.contents;
            if (cont == null || (long)(start + byteCount) > this.mappedRange || (long)start < this.mappedStart) {
                FileChannel ch = this.fileChannel();
                this.mappedStart = Math.max(0L, (long)start - 524288L);
                long prevMappedRange = this.mappedRange;
                long map = (long)byteCount > 524288L ? (long)(byteCount + byteCount / 10) : 524288L;
                this.mappedRange = Math.min(ch.size(), (long)start + map);
                try {
                    try {
                        this.contents = cont = ch.map(FileChannel.MapMode.READ_ONLY, this.mappedStart, this.mappedRange - this.mappedStart);
                    }
                    catch (IOException ioe) {
                        Logger.getAnonymousLogger().info("Failed to memory map output file for reading. Trying to read it normally.");
                        cont = ByteBuffer.allocate((int)(this.mappedRange - this.mappedStart));
                        ch.read(cont, this.mappedStart);
                        this.contents = cont;
                    }
                }
                catch (IOException ioe) {
                    Logger.getAnonymousLogger().info("Failed to read output file. Start:" + start + " bytes reqd=" + byteCount + " mapped range=" + this.mappedRange + " previous mapped range=" + prevMappedRange + " channel size: " + ch.size());
                    throw ioe;
                }
            }
            if ((long)start - this.mappedStart > (long)(cont.limit() - byteCount)) {
                cont.position(Math.max(0, cont.limit() - byteCount));
            } else {
                cont.position((int)((long)start - this.mappedStart));
            }
        }
        int limit = Math.min(cont.limit(), byteCount);
        try {
            return (ByteBuffer)cont.slice().limit(limit);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error setting limit to " + limit + " contents size = " + cont.limit() + " requested: read " + "buffer from " + start + " to be " + byteCount + " bytes");
        }
    }

    @Override
    public synchronized int size() {
        return this.bytesWritten;
    }

    @Override
    public void flush() throws IOException {
        if (this.buffer != null) {
            if (Controller.LOG) {
                Controller.log("FILEMAP STORAGE flush(): " + this.outstandingBufferCount);
            }
            this.write(this.buffer);
            this.fileChannel.force(false);
            this.buffer = null;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.fileChannel != null) {
            this.flush();
        }
        this.closed = true;
    }

    @Override
    public boolean isClosed() {
        return this.fileChannel == null || this.closed;
    }
}

