/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.dd.impl.common.annotation;

import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.netbeans.modules.j2ee.dd.api.common.CommonDDBean;
import org.netbeans.modules.j2ee.dd.api.common.Icon;
import org.netbeans.modules.j2ee.dd.api.common.NameAlreadyUsedException;
import org.netbeans.modules.j2ee.dd.api.common.PortComponentRef;
import org.netbeans.modules.j2ee.dd.api.common.ServiceRef;
import org.netbeans.modules.j2ee.dd.api.common.ServiceRefHandler;
import org.netbeans.modules.j2ee.dd.api.common.ServiceRefHandlerChains;
import org.netbeans.modules.j2ee.dd.api.common.VersionNotSupportedException;
import org.netbeans.modules.j2ee.dd.impl.common.annotation.PortComponentRefImpl;
import org.netbeans.modules.j2ee.dd.impl.common.annotation.ResourceImpl;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationModelHelper;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.parser.AnnotationParser;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.parser.ParseResult;

public class ServiceRefImpl
implements ServiceRef {
    private final TypeElement typeElement;
    private final TypeElement parentElement;
    private final Element element;
    private final AnnotationModelHelper helper;
    private String serviceRefName;
    private String wsdlFile;
    private String value;
    private String type;
    private PortComponentRef[] portComponentRefs;

    public ServiceRefImpl(Element element, TypeElement typeElement, TypeElement typeElement2, AnnotationModelHelper annotationModelHelper) {
        this.typeElement = typeElement;
        this.helper = annotationModelHelper;
        this.element = element;
        this.parentElement = typeElement2;
        Map map = annotationModelHelper.getAnnotationsByType(element.getAnnotationMirrors());
        AnnotationParser annotationParser = AnnotationParser.create((AnnotationModelHelper)annotationModelHelper);
        annotationParser.expectString("name", null);
        annotationParser.expectString("wsdlLocation", null);
        annotationParser.expectClass("value", null);
        annotationParser.expectClass("type", null);
        ParseResult parseResult = annotationParser.parse((AnnotationMirror)map.get("javax.xml.ws.WebServiceRef"));
        this.serviceRefName = (String)parseResult.get("name", String.class);
        this.wsdlFile = (String)parseResult.get("wsdlLocation", String.class);
        this.value = (String)parseResult.get("value", String.class);
        this.type = (String)parseResult.get("type", String.class);
    }

    public ServiceRefImpl(ResourceImpl resourceImpl) {
        this.serviceRefName = resourceImpl.getName();
        this.value = resourceImpl.getType();
        this.typeElement = null;
        this.element = null;
        this.helper = null;
        this.parentElement = null;
    }

    @Override
    public URI getWsdlFile() {
        URI uRI = null;
        if (this.wsdlFile != null) {
            try {
                uRI = new URI(this.wsdlFile);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return uRI;
    }

    @Override
    public String getServiceRefName() {
        if (this.serviceRefName != null) {
            return this.serviceRefName;
        }
        if (this.parentElement != null && this.element != null) {
            return this.parentElement.getQualifiedName().toString() + "/" + this.element.getSimpleName().toString();
        }
        if (this.value != null) {
            return "service/" + this.getClassNameFromClass(this.value);
        }
        if (this.type != null) {
            return "service/" + this.getClassNameFromClass(this.type);
        }
        return "service/" + this.typeElement.getSimpleName().toString();
    }

    @Override
    public String getServiceInterface() {
        if (this.value != null) {
            return this.value;
        }
        if (this.type != null) {
            return this.type;
        }
        return this.typeElement.getQualifiedName().toString();
    }

    @Override
    public PortComponentRef[] getPortComponentRef() {
        this.initPortComponentRefs();
        return this.portComponentRefs;
    }

    @Override
    public int sizePortComponentRef() {
        this.initPortComponentRefs();
        return this.portComponentRefs.length;
    }

    @Override
    public PortComponentRef getPortComponentRef(int n) {
        this.initPortComponentRefs();
        return this.portComponentRefs[n];
    }

    private void initPortComponentRefs() {
        if (this.portComponentRefs == null) {
            ArrayList<PortComponentRefImpl> arrayList = new ArrayList<PortComponentRefImpl>();
            String string = null;
            if (this.value != null) {
                string = this.type != null ? this.type : this.typeElement.getQualifiedName().toString();
            }
            if (string != null) {
                arrayList.add(new PortComponentRefImpl(string));
            }
            this.portComponentRefs = arrayList.toArray(new PortComponentRef[arrayList.size()]);
        }
    }

    @Override
    public String getJaxrpcMappingFile() {
        return null;
    }

    @Override
    public int addPortComponentRef(PortComponentRef portComponentRef) {
        if (!(portComponentRef instanceof PortComponentRefImpl)) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        if (this.portComponentRefs != null) {
            PortComponentRef[] portComponentRefArray = new PortComponentRef[this.portComponentRefs.length + 1];
            for (int i = 0; i < this.portComponentRefs.length; ++i) {
                portComponentRefArray[i] = this.portComponentRefs[i];
            }
            portComponentRefArray[this.portComponentRefs.length] = portComponentRef;
            this.portComponentRefs = portComponentRefArray;
        } else {
            this.portComponentRefs = new PortComponentRef[]{portComponentRef};
        }
        return this.portComponentRefs.length - 1;
    }

    @Override
    public Object clone() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setServiceRefName(String string) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setServiceInterface(String string) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setWsdlFile(URI uRI) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setJaxrpcMappingFile(String string) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setServiceQname(String string) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getServiceQname() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setPortComponentRef(int n, PortComponentRef portComponentRef) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setPortComponentRef(PortComponentRef[] portComponentRefArray) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int removePortComponentRef(PortComponentRef portComponentRef) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setHandler(int n, ServiceRefHandler serviceRefHandler) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ServiceRefHandler getHandler(int n) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setHandler(ServiceRefHandler[] serviceRefHandlerArray) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ServiceRefHandler[] getHandler() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int sizeHandler() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int addHandler(ServiceRefHandler serviceRefHandler) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int removeHandler(ServiceRefHandler serviceRefHandler) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setMappedName(String string) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getMappedName() throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setHandlerChains(ServiceRefHandlerChains serviceRefHandlerChains) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ServiceRefHandlerChains getHandlerChains() throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public PortComponentRef newPortComponentRef() throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ServiceRefHandler newServiceRefHandler() throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ServiceRefHandlerChains newServiceRefHandlerChains() throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setId(String string) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getId() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Object getValue(String string) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setDescription(String string, String string2) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setDescription(String string) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setAllDescriptions(Map map) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getDescription(String string) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getDefaultDescription() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Map getAllDescriptions() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void removeDescriptionForLocale(String string) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void removeDescription() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void removeAllDescriptions() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setDisplayName(String string, String string2) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setDisplayName(String string) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setAllDisplayNames(Map map) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getDisplayName(String string) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getDefaultDisplayName() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Map getAllDisplayNames() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void removeDisplayNameForLocale(String string) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void removeDisplayName() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void removeAllDisplayNames() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public CommonDDBean createBean(String string) throws ClassNotFoundException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public CommonDDBean addBean(String string, String[] stringArray, Object[] objectArray, String string2) throws ClassNotFoundException, NameAlreadyUsedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public CommonDDBean addBean(String string) throws ClassNotFoundException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public CommonDDBean findBeanByName(String string, String string2, String string3) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setSmallIcon(String string, String string2) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setSmallIcon(String string) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setLargeIcon(String string, String string2) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setLargeIcon(String string) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setAllIcons(String[] stringArray, String[] stringArray2, String[] stringArray3) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setIcon(Icon icon) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getSmallIcon(String string) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getSmallIcon() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getLargeIcon(String string) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getLargeIcon() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Icon getDefaultIcon() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Map getAllIcons() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void removeSmallIcon(String string) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void removeLargeIcon(String string) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void removeIcon(String string) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void removeSmallIcon() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void removeLargeIcon() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void removeIcon() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void removeAllIcons() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private String getClassNameFromClass(String string) {
        int n = string.lastIndexOf(46);
        return string.substring(n + 1);
    }
}

