/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common;

import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.cnd.debugger.common.CallStackFrame;
import org.netbeans.modules.cnd.debugger.common.EditorContext;
import org.netbeans.modules.cnd.debugger.common.breakpoints.AddressBreakpoint;
import org.netbeans.modules.cnd.debugger.common.breakpoints.CndBreakpoint;
import org.netbeans.modules.cnd.debugger.common.breakpoints.LineBreakpoint;
import org.netbeans.modules.cnd.debugger.common.disassembly.DisassemblyService;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Annotation;
import org.openide.util.Utilities;

public class EditorContextBridge {
    public static final String FUNCTION = "function";
    public static final String LINE = "line";
    private static EditorContext context;

    public static EditorContext getContext() {
        if (context == null) {
            List l = DebuggerManager.getDebuggerManager().lookup(null, EditorContext.class);
            context = (EditorContext)l.get(0);
            int k = l.size();
            for (int i = 1; i < k; ++i) {
                context = new CompoundContextProvider((EditorContext)l.get(i), context);
            }
        }
        return context;
    }

    public static boolean showSource(String url, int lineNumber, Object timeStamp) {
        return EditorContextBridge.getContext().showSource(url, lineNumber, timeStamp);
    }

    public static boolean showSource(CallStackFrame csf, boolean inDis) {
        if (inDis) {
            return EditorContextBridge.showDis(csf);
        }
        return EditorContextBridge.showCode(csf);
    }

    public static boolean showCode(CallStackFrame csf) {
        FileObject fo;
        File file;
        String fullname = csf.getFullname();
        if (fullname != null && (file = new File(fullname)).exists() && (fo = FileUtil.toFileObject((File)CndFileUtils.normalizeFile((File)file))) != null) {
            try {
                return EditorContextBridge.getContext().showSource(DataObject.find((FileObject)fo), csf.getLineNumber(), null);
            }
            catch (DataObjectNotFoundException dex) {
                // empty catch block
            }
        }
        return false;
    }

    public static DisassemblyService getCurrentDisassemblyService() {
        DebuggerEngine currentEngine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        if (currentEngine == null) {
            return null;
        }
        return (DisassemblyService)currentEngine.lookupFirst(null, DisassemblyService.class);
    }

    public static boolean showDis(CallStackFrame csf) {
        DisassemblyService disService = EditorContextBridge.getCurrentDisassemblyService();
        if (disService != null) {
            return disService.showAddress(csf.getAddr());
        }
        return false;
    }

    public static String getUrl(File file) {
        String url;
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        FileObject fo = FileUtil.toFileObject((File)file);
        try {
            url = fo.getURL().toExternalForm();
        }
        catch (FileStateInvalidException ex) {
            url = Utilities.isWindows() ? "file:/" + fo.getPath().replace(" ", "%20") : "file:/" + fo.getPath();
        }
        return url;
    }

    public static void createTimeStamp(Object timeStamp) {
        EditorContextBridge.getContext().createTimeStamp(timeStamp);
    }

    public static void disposeTimeStamp(Object timeStamp) {
        EditorContextBridge.getContext().disposeTimeStamp(timeStamp);
    }

    public static Annotation annotate(CallStackFrame csf, String annotationType) {
        FileObject fo;
        File file;
        String fullname = csf.getFullname();
        if (fullname != null && (file = new File(fullname)).exists() && (fo = FileUtil.toFileObject((File)CndFileUtils.normalizeFile((File)file))) != null) {
            try {
                return EditorContextBridge.getContext().annotate(DataObject.find((FileObject)fo), csf.getLineNumber(), annotationType, null);
            }
            catch (DataObjectNotFoundException dex) {
                // empty catch block
            }
        }
        return null;
    }

    public static Annotation annotateDis(CallStackFrame csf, String annotationType) {
        DisassemblyService disService = EditorContextBridge.getCurrentDisassemblyService();
        if (disService != null) {
            return disService.annotateAddress(csf.getAddr(), annotationType);
        }
        return null;
    }

    public static void removeAnnotation(Annotation annotation) {
        EditorContextBridge.getContext().removeAnnotation(annotation);
    }

    public static int getLineNumber(Object annotation, Object timeStamp) {
        return EditorContextBridge.getContext().getLineNumber(annotation, timeStamp);
    }

    public static int getCurrentLineNumber() {
        return EditorContextBridge.getContext().getCurrentLineNumber();
    }

    public static int getMostRecentLineNumber() {
        return EditorContextBridge.getContext().getMostRecentLineNumber();
    }

    public static String getCurrentURL() {
        return EditorContextBridge.getContext().getCurrentURL();
    }

    public static String getMostRecentURL() {
        return EditorContextBridge.getContext().getMostRecentURL();
    }

    public static String getCurrentFunctionName() {
        return EditorContextBridge.getContext().getCurrentFunctionName();
    }

    public static String getSelectedFunctionName() {
        return EditorContextBridge.getContext().getSelectedFunctionName();
    }

    public static int getFieldLineNumber(String url, String className, String fieldName) {
        return EditorContextBridge.getContext().getFieldLineNumber(url, className, fieldName);
    }

    public String getCurrentMIMEType() {
        return EditorContextBridge.getContext().getCurrentMIMEType();
    }

    public static String getMostRecentMIMEType() {
        return EditorContextBridge.getContext().getMostRecentMIMEType();
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        EditorContextBridge.getContext().addPropertyChangeListener(l);
    }

    public static void removePropertyChangeListener(PropertyChangeListener l) {
        EditorContextBridge.getContext().removePropertyChangeListener(l);
    }

    public static String getFileName(CndBreakpoint b) {
        try {
            return EditorContextBridge.basename(new File(new URL(b.getURL()).getFile()).getName());
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    private static String basename(String name) {
        int idx = name.lastIndexOf(47);
        if (idx > 0) {
            return name.substring(idx);
        }
        return name;
    }

    public static boolean showSource(CndBreakpoint b, Object timeStamp) {
        DisassemblyService disService;
        if (b instanceof LineBreakpoint) {
            if (b.getLineNumber() < 1) {
                return EditorContextBridge.showSource(b.getURL(), 1, timeStamp);
            }
            return EditorContextBridge.showSource(b.getURL(), b.getLineNumber(), timeStamp);
        }
        if (b instanceof AddressBreakpoint && (disService = EditorContextBridge.getCurrentDisassemblyService()) != null) {
            return disService.showBreakpoint((AddressBreakpoint)b);
        }
        return false;
    }

    public static String getDefaultType() {
        return LINE;
    }

    public static String getRelativePath(String className) {
        return className.replace('.', '/') + ".java";
    }

    private static String convertSlash(String original) {
        return original.replace(File.separatorChar, '/');
    }

    private static class CompoundAnnotation
    extends Annotation {
        Annotation annotation1;
        Annotation annotation2;

        private CompoundAnnotation() {
        }

        public String getAnnotationType() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public String getShortDescription() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private static class CompoundContextProvider
    extends EditorContext {
        private EditorContext cp1;
        private EditorContext cp2;

        CompoundContextProvider(EditorContext cp1, EditorContext cp2) {
            this.cp1 = cp1;
            this.cp2 = cp2;
        }

        @Override
        public void createTimeStamp(Object timeStamp) {
            this.cp1.createTimeStamp(timeStamp);
            this.cp2.createTimeStamp(timeStamp);
        }

        @Override
        public void disposeTimeStamp(Object timeStamp) {
            this.cp1.disposeTimeStamp(timeStamp);
            this.cp2.disposeTimeStamp(timeStamp);
        }

        @Override
        public void updateTimeStamp(Object timeStamp, String url) {
            this.cp1.updateTimeStamp(timeStamp, url);
            this.cp2.updateTimeStamp(timeStamp, url);
        }

        @Override
        public String getCurrentURL() {
            String s = this.cp1.getCurrentURL();
            if (s.trim().length() < 1) {
                return this.cp2.getCurrentURL();
            }
            return s;
        }

        @Override
        public String getMostRecentURL() {
            String s = this.cp1.getMostRecentURL();
            if (s.trim().length() < 1) {
                return this.cp2.getMostRecentURL();
            }
            return s;
        }

        @Override
        public int getCurrentLineNumber() {
            int i = this.cp1.getCurrentLineNumber();
            if (i < 1) {
                return this.cp2.getCurrentLineNumber();
            }
            return i;
        }

        @Override
        public int getMostRecentLineNumber() {
            int i = this.cp1.getMostRecentLineNumber();
            if (i < 1) {
                return this.cp2.getMostRecentLineNumber();
            }
            return i;
        }

        @Override
        public String getCurrentFunctionName() {
            String s = this.cp1.getCurrentFunctionName();
            if (s == null || s.trim().length() < 1) {
                return this.cp2.getCurrentFunctionName();
            }
            return s;
        }

        @Override
        public DataObject getCurrentDataObject() {
            DataObject dobj = this.cp1.getCurrentDataObject();
            if (dobj == null) {
                dobj = this.cp2.getCurrentDataObject();
            }
            return dobj;
        }

        @Override
        public DataObject getMostRecentDataObject() {
            DataObject dobj = this.cp1.getMostRecentDataObject();
            if (dobj == null) {
                dobj = this.cp2.getMostRecentDataObject();
            }
            return dobj;
        }

        @Override
        public FileObject getMostRecentFileObject() {
            FileObject fobj = this.cp1.getMostRecentFileObject();
            if (fobj == null) {
                fobj = this.cp2.getMostRecentFileObject();
            }
            return fobj;
        }

        @Override
        public FileObject getCurrentFileObject() {
            FileObject fo = this.cp1.getCurrentFileObject();
            if (fo == null) {
                fo = this.cp2.getCurrentFileObject();
            }
            return fo;
        }

        @Override
        public String getSelectedFunctionName() {
            String s = this.cp1.getSelectedFunctionName();
            if (s == null || s.trim().length() < 1) {
                return this.cp2.getSelectedFunctionName();
            }
            return s;
        }

        @Override
        public void removeAnnotation(Annotation annotation) {
            CompoundAnnotation ca = (CompoundAnnotation)annotation;
            this.cp1.removeAnnotation(ca.annotation1);
            this.cp2.removeAnnotation(ca.annotation2);
        }

        @Override
        public Annotation annotate(String sourceName, int lineNumber, String annotationType, Object timeStamp) {
            CompoundAnnotation ca = new CompoundAnnotation();
            ca.annotation1 = this.cp1.annotate(sourceName, lineNumber, annotationType, timeStamp);
            ca.annotation2 = this.cp2.annotate(sourceName, lineNumber, annotationType, timeStamp);
            return ca;
        }

        @Override
        public Annotation annotate(DataObject dobj, int lineNumber, String annotationType, Object timeStamp) {
            CompoundAnnotation ca = new CompoundAnnotation();
            ca.annotation1 = this.cp1.annotate(dobj, lineNumber, annotationType, timeStamp);
            ca.annotation2 = this.cp2.annotate(dobj, lineNumber, annotationType, timeStamp);
            return ca;
        }

        @Override
        public int getLineNumber(Object annotation, Object timeStamp) {
            CompoundAnnotation ca = new CompoundAnnotation();
            int ln = this.cp1.getLineNumber(ca.annotation1, timeStamp);
            if (ln >= 0) {
                return ln;
            }
            return this.cp2.getLineNumber(ca.annotation2, timeStamp);
        }

        @Override
        public boolean showSource(String sourceName, int lineNumber, Object timeStamp) {
            return this.cp1.showSource(sourceName, lineNumber, timeStamp) | this.cp2.showSource(sourceName, lineNumber, timeStamp);
        }

        @Override
        public boolean showSource(DataObject dobj, int lineNumber, Object timeStamp) {
            return this.cp1.showSource(dobj, lineNumber, timeStamp) | this.cp2.showSource(dobj, lineNumber, timeStamp);
        }

        @Override
        public int getFieldLineNumber(String url, String className, String fieldName) {
            int ln = this.cp1.getFieldLineNumber(url, className, fieldName);
            if (ln != -1) {
                return ln;
            }
            return this.cp2.getFieldLineNumber(url, className, fieldName);
        }

        @Override
        public String getCurrentMIMEType() {
            String s = this.cp1.getCurrentMIMEType();
            if (s == null) {
                return this.cp2.getCurrentMIMEType();
            }
            return s;
        }

        @Override
        public String getMostRecentMIMEType() {
            String s = this.cp1.getMostRecentMIMEType();
            if (s == null) {
                return this.cp2.getMostRecentMIMEType();
            }
            return s;
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener l) {
            this.cp1.addPropertyChangeListener(l);
            this.cp2.addPropertyChangeListener(l);
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener l) {
            this.cp1.removePropertyChangeListener(l);
            this.cp2.removePropertyChangeListener(l);
        }
    }
}

