/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jboss4;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.shared.DConfigBeanVersionType;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.DeploymentConfiguration;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.DConfigBeanVersionUnsupportedException;
import javax.enterprise.deploy.spi.exceptions.InvalidModuleException;
import javax.enterprise.deploy.spi.exceptions.TargetException;
import javax.enterprise.deploy.spi.status.ProgressObject;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.jboss4.JBDeployer;
import org.netbeans.modules.j2ee.jboss4.JBDeploymentFactory;
import org.netbeans.modules.j2ee.jboss4.ide.JBJ2eePlatformFactory;
import org.netbeans.modules.j2ee.jboss4.ide.ui.JBPluginUtils;
import org.netbeans.modules.j2ee.jboss4.util.JBProperties;

public class JBDeploymentManager
implements DeploymentManager {
    private static final Logger LOGGER = Logger.getLogger(JBDeploymentManager.class.getName());
    private DeploymentManager dm;
    private String realUri;
    private MBeanServerConnection rmiServer;
    private int debuggingPort = 8787;
    private InstanceProperties instanceProperties;
    private boolean needsRestart;
    private static Map propertiesToIsRunning = Collections.synchronizedMap(new WeakHashMap());
    private JBJ2eePlatformFactory.J2eePlatformImplImpl jbPlatform;

    public JBDeploymentManager(DeploymentManager deploymentManager, String string, String string2, String string3) {
        this.realUri = string;
        this.dm = deploymentManager;
        this.rmiServer = null;
    }

    public String getHost() {
        String string = InstanceProperties.getInstanceProperties((String)this.realUri).getProperty("host");
        return string;
    }

    public int getPort() {
        String string = InstanceProperties.getInstanceProperties((String)this.realUri).getProperty("port");
        return new Integer(string);
    }

    public int getDebuggingPort() {
        return this.debuggingPort;
    }

    public String getUrl() {
        return this.realUri;
    }

    public InstanceProperties getInstanceProperties() {
        if (this.instanceProperties == null) {
            this.instanceProperties = InstanceProperties.getInstanceProperties((String)this.realUri);
        }
        return this.instanceProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized MBeanServerConnection getRMIServer() {
        if (this.rmiServer == null) {
            ClassLoader classLoader = null;
            try {
                classLoader = Thread.currentThread().getContextClassLoader();
                InstanceProperties instanceProperties = this.getInstanceProperties();
                URLClassLoader uRLClassLoader = JBDeploymentFactory.getJBClassLoader(instanceProperties.getProperty("root-dir"), instanceProperties.getProperty("server-dir"));
                Thread.currentThread().setContextClassLoader(uRLClassLoader);
                JBProperties jBProperties = this.getProperties();
                Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
                String string = JBPluginUtils.getJnpPort(instanceProperties.getProperty("server-dir"));
                string = string != null && string.trim().length() > 0 ? string.trim() : "1099";
                hashtable.put("java.naming.factory.initial", "org.jboss.naming.NamingContextFactory");
                hashtable.put("java.naming.provider.url", "jnp://localhost" + (string.length() > 0 ? ":" + string : ""));
                hashtable.put("java.naming.factory.object", "org.jboss.naming");
                hashtable.put("java.naming.factory.url.pkgs", "org.jboss.naming:org.jnp.interfaces");
                hashtable.put("jnp.disableDiscovery", Boolean.TRUE);
                String string2 = System.getProperty("java.security.auth.login.config");
                File file = new File(jBProperties.getRootDir(), "/client/auth.conf");
                if (file.exists()) {
                    hashtable.put("java.naming.factory.initial", "org.jboss.security.jndi.LoginInitialContextFactory");
                    hashtable.put("java.naming.security.principal", jBProperties.getUsername());
                    hashtable.put("java.naming.security.credentials", jBProperties.getPassword());
                    System.setProperty("java.security.auth.login.config", file.getAbsolutePath());
                }
                InitialContext initialContext = new InitialContext(hashtable);
                if (string2 != null) {
                    System.setProperty("java.security.auth.login.config", string2);
                } else {
                    System.clearProperty("java.security.auth.login.config");
                }
                this.rmiServer = (MBeanServerConnection)initialContext.lookup("/jmx/invoker/RMIAdaptor");
            }
            catch (NameNotFoundException nameNotFoundException) {
                LOGGER.log(Level.FINE, null, nameNotFoundException);
            }
            catch (NamingException namingException) {
                LOGGER.log(Level.FINE, null, namingException);
            }
            catch (Exception exception) {
                LOGGER.log(Level.FINE, null, exception);
            }
            finally {
                if (classLoader != null) {
                    Thread.currentThread().setContextClassLoader(classLoader);
                }
            }
        }
        return this.rmiServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeMBeanOperation(ObjectName objectName, String string, Object[] objectArray, String[] stringArray) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        MBeanServerConnection mBeanServerConnection = null;
        Object object = this;
        synchronized (object) {
            mBeanServerConnection = this.getRMIServer();
        }
        object = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(mBeanServerConnection.getClass().getClassLoader());
            Object object2 = mBeanServerConnection.invoke(objectName, string, objectArray, stringArray);
            return object2;
        }
        finally {
            Thread.currentThread().setContextClassLoader((ClassLoader)object);
        }
    }

    public synchronized MBeanServerConnection refreshRMIServer() {
        this.rmiServer = null;
        return this.getRMIServer();
    }

    public static boolean isRunningLastCheck(InstanceProperties instanceProperties) {
        boolean bl = propertiesToIsRunning.containsKey(instanceProperties) && propertiesToIsRunning.get(instanceProperties).equals(Boolean.TRUE);
        return bl;
    }

    public static void setRunningLastCheck(InstanceProperties instanceProperties, Boolean bl) {
        assert (instanceProperties != null);
        propertiesToIsRunning.put(instanceProperties, bl);
    }

    public ProgressObject distribute(Target[] targetArray, File file, File file2) throws IllegalStateException {
        return new JBDeployer(this.realUri, this).deploy(targetArray, file, file2, this.getHost(), this.getPort());
    }

    public DeploymentConfiguration createConfiguration(DeployableObject deployableObject) throws InvalidModuleException {
        throw new RuntimeException("This method should never be called.");
    }

    public ProgressObject redeploy(TargetModuleID[] targetModuleIDArray, InputStream inputStream, InputStream inputStream2) throws UnsupportedOperationException, IllegalStateException {
        return this.dm.redeploy(targetModuleIDArray, inputStream, inputStream2);
    }

    public ProgressObject distribute(Target[] targetArray, InputStream inputStream, InputStream inputStream2) throws IllegalStateException {
        return this.dm.distribute(targetArray, inputStream, inputStream2);
    }

    public ProgressObject distribute(Target[] targetArray, ModuleType moduleType, InputStream inputStream, InputStream inputStream2) throws IllegalStateException {
        return this.distribute(targetArray, inputStream, inputStream2);
    }

    public ProgressObject undeploy(TargetModuleID[] targetModuleIDArray) throws IllegalStateException {
        return this.dm.undeploy(targetModuleIDArray);
    }

    public ProgressObject stop(TargetModuleID[] targetModuleIDArray) throws IllegalStateException {
        return this.dm.stop(targetModuleIDArray);
    }

    public ProgressObject start(TargetModuleID[] targetModuleIDArray) throws IllegalStateException {
        return this.dm.start(targetModuleIDArray);
    }

    public void setLocale(Locale locale) throws UnsupportedOperationException {
        this.dm.setLocale(locale);
    }

    public boolean isLocaleSupported(Locale locale) {
        return this.dm.isLocaleSupported(locale);
    }

    public TargetModuleID[] getAvailableModules(ModuleType moduleType, Target[] targetArray) throws TargetException, IllegalStateException {
        return new TargetModuleID[0];
    }

    public TargetModuleID[] getNonRunningModules(ModuleType moduleType, Target[] targetArray) throws TargetException, IllegalStateException {
        return new TargetModuleID[0];
    }

    public TargetModuleID[] getRunningModules(ModuleType moduleType, Target[] targetArray) throws TargetException, IllegalStateException {
        return this.dm.getRunningModules(moduleType, targetArray);
    }

    public ProgressObject redeploy(TargetModuleID[] targetModuleIDArray, File file, File file2) throws UnsupportedOperationException, IllegalStateException {
        return new JBDeployer(this.realUri, this).redeploy(targetModuleIDArray, file, file2);
    }

    public void setDConfigBeanVersion(DConfigBeanVersionType dConfigBeanVersionType) throws DConfigBeanVersionUnsupportedException {
        this.dm.setDConfigBeanVersion(dConfigBeanVersionType);
    }

    public boolean isDConfigBeanVersionSupported(DConfigBeanVersionType dConfigBeanVersionType) {
        return this.dm.isDConfigBeanVersionSupported(dConfigBeanVersionType);
    }

    public void release() {
        if (this.dm != null) {
            this.dm.release();
        }
    }

    public boolean isRedeploySupported() {
        return this.dm.isRedeploySupported();
    }

    public Locale getCurrentLocale() {
        return this.dm.getCurrentLocale();
    }

    public DConfigBeanVersionType getDConfigBeanVersion() {
        return this.dm.getDConfigBeanVersion();
    }

    public Locale getDefaultLocale() {
        return this.dm.getDefaultLocale();
    }

    public Locale[] getSupportedLocales() {
        return this.dm.getSupportedLocales();
    }

    public Target[] getTargets() throws IllegalStateException {
        return this.dm.getTargets();
    }

    public JBJ2eePlatformFactory.J2eePlatformImplImpl getJBPlatform() {
        if (this.jbPlatform == null) {
            this.jbPlatform = (JBJ2eePlatformFactory.J2eePlatformImplImpl)new JBJ2eePlatformFactory().getJ2eePlatformImpl(this);
        }
        return this.jbPlatform;
    }

    public JBProperties getProperties() {
        return new JBProperties(this);
    }

    public synchronized void setNeedsRestart(boolean bl) {
        this.needsRestart = bl;
    }

    public synchronized boolean getNeedsRestart() {
        return this.needsRestart;
    }
}

