/*
 * Decompiled with CFR 0.152.
 */
package org.rubyforge.debugcommons.reader;

import java.io.IOException;
import java.util.ArrayList;
import org.rubyforge.debugcommons.Util;
import org.rubyforge.debugcommons.model.RubyFrameInfo;
import org.rubyforge.debugcommons.reader.ErrorReader;
import org.rubyforge.debugcommons.reader.XmlStreamReader;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public final class FramesReader
extends XmlStreamReader {
    private RubyFrameInfo[] frames;

    public FramesReader(XmlPullParser xpp) {
        super(xpp);
    }

    private void parse() throws XmlPullParserException, IOException {
        ArrayList<RubyFrameInfo> _frames = new ArrayList<RubyFrameInfo>();
        assert (this.xpp.getName().equals("frames"));
        while (this.nextEvent() != 3 || !"frames".equals(this.xpp.getName())) {
            ErrorReader.flushPossibleMessage(this.xpp);
            if (Util.isEndTag(this.xpp, "frames")) break;
            assert (this.xpp.getName().equals("frame")) : this.xpp.getName() + " encountered";
            String file = this.getAttributeValue("file");
            int line = this.getAttributeIntValue("line");
            int index = this.getAttributeIntValue("no");
            _frames.add(new RubyFrameInfo(file, line, index));
            this.ensureEndTag("frame");
        }
        this.frames = _frames.toArray(new RubyFrameInfo[_frames.size()]);
    }

    public static RubyFrameInfo[] readFrames(XmlPullParser xpp) throws IOException, XmlPullParserException {
        FramesReader reader = new FramesReader(xpp);
        reader.parse();
        return reader.frames;
    }
}

