/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.game.model;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.event.EventListenerList;
import org.netbeans.modules.vmd.game.dialog.RenameSequenceDialog;
import org.netbeans.modules.vmd.game.editor.sequece.SequenceEditingPanel;
import org.netbeans.modules.vmd.game.model.Editable;
import org.netbeans.modules.vmd.game.model.GlobalRepository;
import org.netbeans.modules.vmd.game.model.Identifiable;
import org.netbeans.modules.vmd.game.model.ImageResource;
import org.netbeans.modules.vmd.game.model.Previewable;
import org.netbeans.modules.vmd.game.model.SequenceListener;
import org.netbeans.modules.vmd.game.model.StaticTile;
import org.netbeans.modules.vmd.game.preview.SequencePreviewPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;

public class Sequence
implements Previewable,
Editable,
Identifiable {
    private long id = -1L;
    public static final boolean DEBUG = false;
    public static final int DEFAULT_FRAMES = 1;
    public static final int DEFAULT_SHOWTIME_MS = 200;
    public static final String PROPERTY_NAME = "sequence.prop.name";
    public static final String PROPERTY_FRAME_MS = "sequence.prop.frames.ms";
    EventListenerList listenerList = new EventListenerList();
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private SequenceEditingPanel editor;
    private String name;
    private ImageResource imageResource;
    private boolean zeroBasedIndex;
    private int frameWidth;
    private int frameHeight;
    private int frameMs;
    private ArrayList<StaticTile> frames;

    Sequence(String string, ImageResource imageResource, int n, int n2, boolean bl) {
        this(string, imageResource, 1, n, n2, bl);
    }

    Sequence(String string, ImageResource imageResource, int n, int n2, int n3, boolean bl) {
        this.name = string;
        this.imageResource = imageResource;
        this.frameWidth = n2;
        this.frameHeight = n3;
        this.zeroBasedIndex = bl;
        this.frames = new ArrayList();
        for (int i = 0; i < n; ++i) {
            this.frames.add((StaticTile)imageResource.getTile(0, this.frameWidth, this.frameHeight, this.zeroBasedIndex));
        }
        this.frameMs = 200;
    }

    Sequence(String string, Sequence sequence) {
        this.name = string;
        this.imageResource = sequence.getImageResource();
        this.frameHeight = sequence.getFrameHeight();
        this.frameWidth = sequence.getFrameWidth();
        this.frameMs = sequence.frameMs;
        this.zeroBasedIndex = sequence.zeroBasedIndex;
        this.frames = new ArrayList();
        this.frames.addAll(sequence.getFrames());
    }

    public GlobalRepository getGameDesign() {
        return this.imageResource.getGameDesign();
    }

    public boolean isZeroBasedIndex() {
        return this.zeroBasedIndex;
    }

    public void setName(String string) {
        if (string == null) {
            return;
        }
        if (this.getName().equals(string)) {
            return;
        }
        if (!this.getGameDesign().isComponentNameAvailable(string)) {
            throw new IllegalArgumentException("Sequence cannot be renamed because component name '" + string + "' already exists.");
        }
        String string2 = this.name;
        this.name = string;
        this.propertyChangeSupport.firePropertyChange(PROPERTY_NAME, string2, string);
    }

    public void setFrames(int[] nArray) {
        ArrayList<StaticTile> arrayList = new ArrayList<StaticTile>();
        for (int i = 0; i < nArray.length; ++i) {
            StaticTile staticTile = new StaticTile(this.imageResource, nArray[i], this.frameWidth, this.frameHeight, this.zeroBasedIndex);
            arrayList.add(staticTile);
        }
        this.frames = arrayList;
        this.fireFramesChanged();
    }

    public void addFrame(StaticTile staticTile) {
        if (staticTile == null) {
            staticTile = (StaticTile)this.imageResource.getTile(0, this.frameWidth, this.frameHeight, this.zeroBasedIndex);
        }
        this.frames.add(staticTile);
        int n = this.frames.indexOf(staticTile);
        this.fireFrameAdded(staticTile, n);
    }

    public void insertFrame(StaticTile staticTile, int n) {
        if (staticTile == null) {
            staticTile = (StaticTile)this.imageResource.getTile(0, this.frameWidth, this.frameHeight, this.zeroBasedIndex);
        }
        this.frames.add(n, staticTile);
        this.fireFrameAdded(staticTile, n);
    }

    public void removeFrame(int n) {
        StaticTile staticTile = this.frames.remove(n);
        this.fireFrameRemoved(staticTile, n);
    }

    public void removeFrames(Set<Integer> set) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(set);
        Collections.sort(arrayList, new Comparator<Integer>(){

            @Override
            public int compare(Integer n, Integer n2) {
                return n > n2 ? -1 : (n.intValue() == n2.intValue() ? 0 : 1);
            }
        });
        for (Integer n : arrayList) {
            this.removeFrame(n);
        }
    }

    public StaticTile getFrame(int n) {
        return this.frames.get(n);
    }

    public void setFrame(StaticTile staticTile, int n) {
        if (staticTile == null) {
            staticTile = (StaticTile)this.imageResource.getTile(0, this.frameWidth, this.frameHeight, this.zeroBasedIndex);
        }
        this.frames.ensureCapacity(n + 1);
        this.frames.set(n, staticTile);
        this.fireFrameModified(staticTile, n);
    }

    public int getFrameMs() {
        return this.frameMs;
    }

    public void setFrameMs(int n) {
        int n2 = this.frameMs;
        this.frameMs = n;
        this.propertyChangeSupport.firePropertyChange(PROPERTY_FRAME_MS, n2, n);
    }

    public int getFrameHeight() {
        return this.frameHeight;
    }

    public int getFrameWidth() {
        return this.frameWidth;
    }

    public int getFrameCount() {
        return this.frames.size();
    }

    public Dimension getFrameSize() {
        return new Dimension(this.getFrameWidth(), this.getFrameHeight());
    }

    public List getFrames() {
        return Collections.unmodifiableList(this.frames);
    }

    public int[] getFramesAsArray() {
        int[] nArray = new int[this.frames.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.frames.get(i).getIndex();
        }
        return nArray;
    }

    private void fireFramesChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != SequenceListener.class) continue;
            ((SequenceListener)objectArray[i + 1]).framesChanged(this);
        }
    }

    private void fireFrameAdded(StaticTile staticTile, int n) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != SequenceListener.class) continue;
            ((SequenceListener)objectArray[i + 1]).frameAdded(this, n);
        }
    }

    private void fireFrameRemoved(StaticTile staticTile, int n) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != SequenceListener.class) continue;
            ((SequenceListener)objectArray[i + 1]).frameRemoved(this, n);
        }
    }

    private void fireFrameModified(StaticTile staticTile, int n) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != SequenceListener.class) continue;
            ((SequenceListener)objectArray[i + 1]).frameModified(this, n);
        }
    }

    @Override
    public JComponent getEditor() {
        return this.editor == null ? (this.editor = new SequenceEditingPanel(this)) : this.editor;
    }

    public ImageResource getImageResource() {
        return this.imageResource;
    }

    @Override
    public Editable.ImageResourceInfo getImageResourceInfo() {
        return new Editable.ImageResourceInfo(this.imageResource, this.frameWidth, this.frameHeight, this.zeroBasedIndex);
    }

    @Override
    public JComponent getNavigator() {
        return null;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public synchronized void addSequenceListener(SequenceListener sequenceListener) {
        this.listenerList.add(SequenceListener.class, sequenceListener);
    }

    public synchronized void removeSequenceListener(SequenceListener sequenceListener) {
        this.listenerList.remove(SequenceListener.class, sequenceListener);
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public void paint(Graphics2D graphics2D, int n, int n2) {
        this.getFrame(0).paint(graphics2D, n, n2);
    }

    @Override
    public int getWidth() {
        return this.frameWidth;
    }

    @Override
    public int getHeight() {
        return this.frameHeight;
    }

    @Override
    public JComponent getPreview() {
        return new SequencePreviewPanel(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<Action> getActions() {
        ArrayList<AbstractAction> arrayList = new ArrayList<AbstractAction>();
        arrayList.add(new RenameSequenceAction());
        arrayList.add(new EditSequenceAction());
        return Collections.unmodifiableList(arrayList);
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long l) {
        this.id = l;
    }

    public class RenameSequenceAction
    extends AbstractAction {
        public RenameSequenceAction() {
            this.putValue("Name", NbBundle.getMessage(Sequence.class, (String)"Sequence.RenameSequenceAction.text"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            RenameSequenceDialog renameSequenceDialog = new RenameSequenceDialog(Sequence.this);
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)renameSequenceDialog, NbBundle.getMessage(Sequence.class, (String)"Sequence.RenameSequenceAction.text"));
            dialogDescriptor.setButtonListener((ActionListener)renameSequenceDialog);
            dialogDescriptor.setValid(false);
            renameSequenceDialog.setDialogDescriptor(dialogDescriptor);
            Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
            dialog.setVisible(true);
        }
    }

    public class EditSequenceAction
    extends AbstractAction {
        public EditSequenceAction() {
            this.putValue("Name", NbBundle.getMessage(Sequence.class, (String)"Sequence.EditSequenceAction.text"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Sequence.this.getGameDesign().getMainView().requestEditing(Sequence.this);
        }
    }
}

