/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.game.model;

import java.awt.Dialog;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import org.netbeans.modules.vmd.game.dialog.NewSequenceDialog;
import org.netbeans.modules.vmd.game.dialog.RenameAnimatedTileDialog;
import org.netbeans.modules.vmd.game.editor.sequece.SequenceContainerEditor;
import org.netbeans.modules.vmd.game.editor.sequece.SequenceContainerNavigator;
import org.netbeans.modules.vmd.game.model.Editable;
import org.netbeans.modules.vmd.game.model.GlobalRepository;
import org.netbeans.modules.vmd.game.model.Identifiable;
import org.netbeans.modules.vmd.game.model.ImageResource;
import org.netbeans.modules.vmd.game.model.Sequence;
import org.netbeans.modules.vmd.game.model.SequenceContainer;
import org.netbeans.modules.vmd.game.model.SequenceContainerListener;
import org.netbeans.modules.vmd.game.model.Tile;
import org.netbeans.modules.vmd.game.preview.SequenceContainerPreview;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class AnimatedTile
extends Tile
implements SequenceContainer,
Editable,
Identifiable {
    private long id = -1L;
    public static final boolean DEBUG = false;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private SequenceContainer.SequenceContainerImpl sequenceContainer;
    private SequenceContainerEditor editor;
    private JComponent navigator;
    private String name;

    AnimatedTile(String string, ImageResource imageResource, int n, Sequence sequence, int n2, int n3) {
        super(imageResource, n, n2, n3);
        this.sequenceContainer = new SequenceContainer.SequenceContainerImpl(this, null, this.propertyChangeSupport, imageResource, n2, n3, false);
        this.name = string;
        this.setDefaultSequence(sequence);
    }

    AnimatedTile(String string, ImageResource imageResource, int n, int n2, int n3) {
        super(imageResource, n, n2, n3);
        this.sequenceContainer = new SequenceContainer.SequenceContainerImpl(this, null, this.propertyChangeSupport, imageResource, n2, n3, false);
        this.name = string;
        String string2 = this.getNextSequenceName(this.name + "seq");
        Sequence sequence = this.createSequence(string2, 1, n2, n3);
        this.setDefaultSequence(sequence);
    }

    @Override
    public String getNextSequenceName(String string) {
        return this.sequenceContainer.getNextSequenceName(string);
    }

    @Override
    public GlobalRepository getGameDesign() {
        return this.getImageResource().getGameDesign();
    }

    @Override
    public void addSequenceContainerListener(SequenceContainerListener sequenceContainerListener) {
        this.sequenceContainer.addSequenceContainerListener(sequenceContainerListener);
    }

    @Override
    public void removeSequenceContainerListener(SequenceContainerListener sequenceContainerListener) {
        this.sequenceContainer.removeSequenceContainerListener(sequenceContainerListener);
    }

    public void setName(String string) {
        if (string == null) {
            return;
        }
        if (this.getName().equals(string)) {
            return;
        }
        if (!this.getGameDesign().isComponentNameAvailable(string)) {
            throw new IllegalArgumentException("AnimatedTile cannot be renamed because component name '" + string + "' already exists.");
        }
        String string2 = this.name;
        this.name = string;
        this.propertyChangeSupport.firePropertyChange("editable.prop.name", string2, string);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Sequence createSequence(String string, int n, int n2, int n3) {
        return this.sequenceContainer.createSequence(string, n, n2, n3);
    }

    @Override
    public Sequence createSequence(String string, Sequence sequence) {
        return this.sequenceContainer.createSequence(string, sequence);
    }

    @Override
    public boolean append(Sequence sequence) {
        return this.sequenceContainer.append(sequence);
    }

    @Override
    public boolean insert(Sequence sequence, int n) {
        return this.sequenceContainer.insert(sequence, n);
    }

    @Override
    public boolean remove(Sequence sequence) {
        return this.sequenceContainer.remove(sequence);
    }

    @Override
    public void move(Sequence sequence, int n) {
        this.sequenceContainer.move(sequence, n);
    }

    @Override
    public List<Sequence> getSequences() {
        return this.sequenceContainer.getSequences();
    }

    @Override
    public int getSequenceCount() {
        return this.sequenceContainer.getSequenceCount();
    }

    @Override
    public Sequence getSequenceByName(String string) {
        return this.sequenceContainer.getSequenceByName(string);
    }

    @Override
    public void setDefaultSequence(Sequence sequence) {
        this.sequenceContainer.setDefaultSequence(sequence);
    }

    @Override
    public Sequence getDefaultSequence() {
        return this.sequenceContainer.getDefaultSequence();
    }

    @Override
    public int indexOf(Sequence sequence) {
        return this.sequenceContainer.indexOf(sequence);
    }

    @Override
    public Sequence getSequenceAt(int n) {
        return this.sequenceContainer.getSequenceAt(n);
    }

    @Override
    public List<Action> getActionsForSequence(Sequence sequence) {
        return this.sequenceContainer.getActionsForSequence(sequence);
    }

    @Override
    public JComponent getEditor() {
        return this.editor == null ? (this.editor = new SequenceContainerEditor(this)) : this.editor;
    }

    @Override
    public Editable.ImageResourceInfo getImageResourceInfo() {
        return new Editable.ImageResourceInfo(this.getImageResource(), this.getWidth(), this.getHeight(), false);
    }

    @Override
    public List<Action> getActions() {
        ArrayList<AbstractAction> arrayList = new ArrayList<AbstractAction>();
        arrayList.add(new RenameAction());
        arrayList.add(new AddSequenceAction());
        arrayList.add(new DeleteAction());
        return Collections.unmodifiableList(arrayList);
    }

    @Override
    public JComponent getPreview() {
        return new SequenceContainerPreview(NbBundle.getMessage(AnimatedTile.class, (String)"AnimatedTile.previewLabel.text"), this);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    @Override
    public void paint(Graphics2D graphics2D, int n, int n2) {
        this.getDefaultSequence().getFrame(0).paint(graphics2D, n, n2);
    }

    @Override
    public void paint(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        this.getDefaultSequence().getFrame(0).paint(graphics2D, n, n2, n3, n4);
    }

    @Override
    public JComponent getNavigator() {
        return this.navigator == null ? (this.navigator = new SequenceContainerNavigator(this)) : this.navigator;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long l) {
        this.id = l;
    }

    public class DeleteAction
    extends AbstractAction {
        public DeleteAction() {
            this.putValue("Name", NbBundle.getMessage(AnimatedTile.class, (String)"AnimatedTile.DeleteAction.name"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = DialogDisplayer.getDefault().notify(new NotifyDescriptor((Object)NbBundle.getMessage(AnimatedTile.class, (String)"AnimatedTile.DeleteDialog.text", (Object)AnimatedTile.this.getName()), NbBundle.getMessage(AnimatedTile.class, (String)"AnimatedTile.DeleteAnimatedTile.text"), 0, 3, new Object[]{NotifyDescriptor.YES_OPTION, NotifyDescriptor.NO_OPTION}, NotifyDescriptor.YES_OPTION));
            if (object == NotifyDescriptor.YES_OPTION) {
                AnimatedTile.this.getImageResource().removeAnimatedTile(AnimatedTile.this.getIndex());
            }
        }
    }

    public class RenameAction
    extends AbstractAction {
        public RenameAction() {
            this.putValue("Name", NbBundle.getMessage(AnimatedTile.class, (String)"AnimatedTile.RenameAction.name"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            RenameAnimatedTileDialog renameAnimatedTileDialog = new RenameAnimatedTileDialog(AnimatedTile.this);
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)renameAnimatedTileDialog, NbBundle.getMessage(AnimatedTile.class, (String)"AnimatedTile.RenameAction.name"));
            dialogDescriptor.setButtonListener((ActionListener)renameAnimatedTileDialog);
            dialogDescriptor.setValid(false);
            renameAnimatedTileDialog.setDialogDescriptor(dialogDescriptor);
            Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
            dialog.setVisible(true);
        }
    }

    public class AddSequenceAction
    extends AbstractAction {
        public AddSequenceAction() {
            this.putValue("Name", NbBundle.getMessage(AnimatedTile.class, (String)"AnimatedTile.AddSequenceAction.name"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            NewSequenceDialog newSequenceDialog = new NewSequenceDialog(AnimatedTile.this, AnimatedTile.this.getWidth(), AnimatedTile.this.getHeight());
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)newSequenceDialog, NbBundle.getMessage(AnimatedTile.class, (String)"AnimatedTile.AddSequenceAction.name"));
            dialogDescriptor.setButtonListener((ActionListener)newSequenceDialog);
            dialogDescriptor.setValid(false);
            newSequenceDialog.setDialogDescriptor(dialogDescriptor);
            Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
            dialog.setVisible(true);
        }
    }
}

