/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.utils;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import org.netbeans.modules.cnd.apt.structure.APT;
import org.netbeans.modules.cnd.apt.structure.APTFile;

public class APTTraceUtils {
    private APTTraceUtils() {
    }

    public static String toFileString(APTFile aptFile) {
        if (aptFile == null) {
            return "<no file>";
        }
        File file = new File(((Object)aptFile.getPath()).toString());
        File parentFile = file.getParentFile();
        if (parentFile == null) {
            return file.getName();
        }
        return parentFile.getName() + "/" + file.getName();
    }

    public static String toStringList(APT t) {
        StringBuilder ts = new StringBuilder();
        if (t.getFirstChild() != null) {
            ts.append(" (");
        }
        ts.append(" ").append(t.toString());
        if (t.getFirstChild() != null) {
            ts.append(APTTraceUtils.toStringList(t.getFirstChild()));
        }
        if (t.getFirstChild() != null) {
            ts.append(" )");
        }
        if (t.getNextSibling() != null) {
            ts.append(APTTraceUtils.toStringList(t.getNextSibling()));
        }
        return ts.toString();
    }

    public static String toStringTree(APT t) {
        StringBuilder ts = new StringBuilder();
        if (t.getFirstChild() != null) {
            ts.append(" (");
        }
        ts.append(" ").append(t.toString());
        if (t.getFirstChild() != null) {
            ts.append(APTTraceUtils.toStringTree(t.getFirstChild()));
        }
        if (t.getFirstChild() != null) {
            ts.append(" )");
        }
        return ts.toString();
    }

    public static void xmlSerialize(APT t, Writer out) throws IOException {
        for (APT node = t; node != null; node = node.getNextSibling()) {
            if (node.getFirstChild() == null) {
                APTTraceUtils.xmlSerializeNode(node, out);
                continue;
            }
            APTTraceUtils.xmlSerializeRootOpen(node, out);
            APTTraceUtils.xmlSerialize(node.getFirstChild(), out);
            APTTraceUtils.xmlSerializeRootClose(node, out);
        }
    }

    private static void xmlSerializeNode(APT t, Writer out) throws IOException {
        out.write("<" + APTTraceUtils.xmlNodeText(t) + "\"/>\n");
    }

    private static void xmlSerializeRootOpen(APT t, Writer out) throws IOException {
        out.write("<" + APTTraceUtils.xmlNodeText(t) + "\">\n");
    }

    private static void xmlSerializeRootClose(APT t, Writer out) throws IOException {
        out.write("</" + t.getClass().getSimpleName() + ">\n");
    }

    private static String xmlNodeText(APT t) {
        StringBuilder buf = new StringBuilder(100);
        buf.append(t.getClass().getSimpleName());
        buf.append(" type=\"").append(APTTraceUtils.encode(APTTraceUtils.getTypeName(t)));
        buf.append("\" text=\"").append(APTTraceUtils.encode(t.toString()));
        return buf.toString();
    }

    private static String decode(String text) {
        StringBuilder n = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '&') {
                char c1 = text.charAt(i + 1);
                char c2 = text.charAt(i + 2);
                char c3 = text.charAt(i + 3);
                char c4 = text.charAt(i + 4);
                char c5 = text.charAt(i + 5);
                if (c1 == 'a' && c2 == 'm' && c3 == 'p' && c4 == ';') {
                    n.append("&");
                    i += 5;
                    continue;
                }
                if (c1 == 'l' && c2 == 't' && c3 == ';') {
                    n.append("<");
                    i += 4;
                    continue;
                }
                if (c1 == 'g' && c2 == 't' && c3 == ';') {
                    n.append(">");
                    i += 4;
                    continue;
                }
                if (c1 == 'q' && c2 == 'u' && c3 == 'o' && c4 == 't' && c5 == ';') {
                    n.append("\"");
                    i += 6;
                    continue;
                }
                if (c1 == 'a' && c2 == 'p' && c3 == 'o' && c4 == 's' && c5 == ';') {
                    n.append("'");
                    i += 6;
                    continue;
                }
                n.append("&");
                continue;
            }
            n.append(c);
        }
        return new String(n);
    }

    private static String encode(String text) {
        StringBuilder n = new StringBuilder();
        block7: for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '&': {
                    n.append("&amp;");
                    continue block7;
                }
                case '<': {
                    n.append("&lt;");
                    continue block7;
                }
                case '>': {
                    n.append("&gt;");
                    continue block7;
                }
                case '\"': {
                    n.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    n.append("&apos;");
                    continue block7;
                }
                default: {
                    n.append(c);
                }
            }
        }
        return new String(n);
    }

    public static String getTypeName(APT t) {
        int type = t.getType();
        String str = "<unknown>";
        switch (type) {
            case 0: {
                str = "INVALID";
                break;
            }
            case 1: {
                str = "FILE";
                break;
            }
            case 2: {
                str = "TOKEN_STREAM";
                break;
            }
            case 3: {
                str = "INCLUDE";
                break;
            }
            case 4: {
                str = "INCLUDE_NEXT";
                break;
            }
            case 5: {
                str = "DEFINE";
                break;
            }
            case 6: {
                str = "UNDEF";
                break;
            }
            case 7: {
                str = "IFDEF";
                break;
            }
            case 8: {
                str = "IFNDEF";
                break;
            }
            case 9: {
                str = "IF";
                break;
            }
            case 10: {
                str = "ELIF";
                break;
            }
            case 11: {
                str = "ELSE";
                break;
            }
            case 12: {
                str = "ENDIF";
                break;
            }
            case 13: {
                str = "PRAGMA";
                break;
            }
            case 14: {
                str = "LINE";
                break;
            }
            case 15: {
                str = "ERROR";
                break;
            }
            case 16: {
                str = "PREPROC_UNKNOWN";
                break;
            }
        }
        return str;
    }
}

