/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.support;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.repository.support.KeyFactory;
import org.netbeans.modules.cnd.repository.support.SelfPersistent;
import org.netbeans.modules.cnd.utils.cache.FilePathCache;

public final class StartEntry
implements Persistent,
SelfPersistent {
    private final CharSequence startFile;
    private final Key startFileProject;

    public StartEntry(String startFile, Key startFileProject) {
        this.startFile = FilePathCache.getManager().getString((CharSequence)startFile);
        this.startFileProject = startFileProject;
    }

    public CharSequence getStartFile() {
        return this.startFile;
    }

    public Key getStartFileProject() {
        return this.startFileProject;
    }

    public void write(DataOutput output) throws IOException {
        assert (output != null);
        output.writeUTF(((Object)this.startFile).toString());
        KeyFactory.getDefaultFactory().writeKey(this.startFileProject, output);
    }

    public StartEntry(DataInput input) throws IOException {
        assert (input != null);
        this.startFile = FilePathCache.getManager().getString((CharSequence)input.readUTF());
        this.startFileProject = KeyFactory.getDefaultFactory().readKey(input);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StartEntry other = (StartEntry)obj;
        if (!(this.startFile == other.startFile || this.startFile != null && this.startFile.equals(other.startFile))) {
            return false;
        }
        return this.startFileProject == other.startFileProject || this.startFileProject != null && this.startFileProject.equals(other.startFileProject);
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + (this.startFile != null ? this.startFile.hashCode() : 0);
        hash = 89 * hash + (this.startFileProject != null ? this.startFileProject.hashCode() : 0);
        return hash;
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        out.append("Start Entry: from file=" + this.startFile + "\nof project=" + this.startFileProject);
        return out.toString();
    }
}

