/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.editing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.mozilla.nb.javascript.Node;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.lexer.TokenUtilities;
import org.netbeans.modules.csl.api.InstantRenamer;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.javascript.editing.AstPath;
import org.netbeans.modules.javascript.editing.AstUtilities;
import org.netbeans.modules.javascript.editing.JsParseResult;
import org.netbeans.modules.javascript.editing.VariableVisitor;
import org.netbeans.modules.javascript.editing.lexer.JsCommentLexer;
import org.netbeans.modules.javascript.editing.lexer.JsCommentTokenId;
import org.netbeans.modules.javascript.editing.lexer.JsTokenId;
import org.netbeans.modules.javascript.editing.lexer.LexUtilities;
import org.netbeans.modules.parsing.spi.Parser;
import org.openide.util.NbBundle;

public class JsRenameHandler
implements InstantRenamer {
    public boolean isRenameAllowed(ParserResult parserResult, int n, String[] stringArray) {
        JsParseResult jsParseResult = AstUtilities.getParseResult((Parser.Result)parserResult);
        if (jsParseResult == null) {
            if (stringArray != null) {
                stringArray[0] = NbBundle.getMessage(JsRenameHandler.class, (String)"NoRenameWithErrors");
            }
            return false;
        }
        int n2 = AstUtilities.getAstOffset((Parser.Result)parserResult, n);
        if (n2 == -1) {
            return false;
        }
        TokenSequence<? extends JsTokenId> tokenSequence = LexUtilities.getPositionedSequence(parserResult.getSnapshot(), n2);
        if (tokenSequence != null && tokenSequence.token().id() == JsTokenId.BLOCK_COMMENT) {
            TokenSequence tokenSequence2 = tokenSequence.embedded(JsCommentTokenId.language());
            boolean bl = false;
            if (tokenSequence2 != null) {
                boolean bl2 = bl = this.getParameterName((TokenSequence<? extends JsCommentTokenId>)tokenSequence2, n) != null;
            }
            if (!bl && stringArray != null) {
                stringArray[0] = NbBundle.getMessage(JsRenameHandler.class, (String)"RenameOnlyParams");
            }
            return bl;
        }
        Node node = jsParseResult.getRootNode();
        if (node == null) {
            return false;
        }
        AstPath astPath = new AstPath(node, n2);
        Node node2 = astPath.leaf();
        switch (node2.getType()) {
            case 39: 
            case 49: 
            case 163: 
            case 164: {
                return true;
            }
            case 165: {
                return AstUtilities.isLabelledFunction(node2);
            }
        }
        return false;
    }

    public Set<OffsetRange> getRenameRegions(ParserResult parserResult, int n) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        JsParseResult jsParseResult = AstUtilities.getParseResult((Parser.Result)parserResult);
        if (jsParseResult == null) {
            return Collections.emptySet();
        }
        Node node = jsParseResult.getRootNode();
        if (node == null) {
            return Collections.emptySet();
        }
        int n2 = AstUtilities.getAstOffset((Parser.Result)parserResult, n);
        if (n2 == -1) {
            return Collections.emptySet();
        }
        Object object7 = null;
        TokenSequence<? extends JsTokenId> tokenSequence = LexUtilities.getPositionedSequence(parserResult.getSnapshot(), n2);
        if (tokenSequence != null && tokenSequence.token().id() == JsTokenId.BLOCK_COMMENT) {
            object6 = tokenSequence.embedded(JsCommentTokenId.language());
            if (object6 != null) {
                object7 = this.getParameterName((TokenSequence<? extends JsCommentTokenId>)object6, n2);
            } else {
                return Collections.emptySet();
            }
        }
        if ((object6 = object7) != null) {
            assert (tokenSequence != null);
            boolean bl = false;
            boolean bl2 = false;
            while (tokenSequence.moveNext()) {
                object5 = tokenSequence.token();
                object4 = (JsTokenId)object5.id();
                if (object4 == JsTokenId.FUNCTION) {
                    bl = true;
                    continue;
                }
                if (object4 == JsTokenId.LPAREN) {
                    assert (bl);
                    bl2 = true;
                    n2 = tokenSequence.offset() + 1;
                    break;
                }
                if (object4 != JsTokenId.BLOCK_COMMENT) continue;
                break;
            }
            if (!bl2) {
                return Collections.emptySet();
            }
        }
        VariableVisitor variableVisitor = jsParseResult.getVariableVisitor();
        AstPath astPath = new AstPath(node, n2);
        object5 = astPath.leaf();
        if (object6 == null) {
            if (!(object5 instanceof Node.StringNode)) {
                return Collections.emptySet();
            }
            object6 = object5.getString();
        }
        if (!object6.equals(object5.getString()) && object7 != null) {
            object4 = new ArrayList();
            object3 = AstUtilities.findLocalScope((Node)object5, astPath);
            AstUtilities.addNodesByType(object3, new int[]{163}, (List<Node>)object4);
            object2 = object4.iterator();
            while (object2.hasNext()) {
                object = (Node)object2.next();
                if (!object.getString().equals(object7)) continue;
                object5 = object;
                break;
            }
        }
        object4 = variableVisitor.getVarOccurrences((Node)object5);
        object3 = new HashSet();
        object2 = null;
        if (object4 != null) {
            object = object4.iterator();
            while (object.hasNext()) {
                Node node2 = (Node)object.next();
                object3.add(AstUtilities.getNameRange(node2));
                if (node2.getType() != 163) continue;
                object2 = node2;
            }
        }
        if (object3.size() > 0) {
            object = new HashSet(2 * object3.size());
            for (OffsetRange offsetRange : object3) {
                OffsetRange offsetRange2 = LexUtilities.getLexerOffsets(jsParseResult, offsetRange);
                if (offsetRange2 == OffsetRange.NONE) continue;
                object.add(offsetRange2);
            }
            object3 = object;
        }
        if (object2 != null && (object = this.findParameterDoc(jsParseResult, (Node)object2, (String)object6)) != OffsetRange.NONE) {
            object3.add(object);
        }
        return object3;
    }

    @NonNull
    private OffsetRange findParameterDoc(JsParseResult jsParseResult, Node node, String string) {
        Node node2;
        for (node2 = node.getParentNode(); node2 != null && node2.getType() != 108; node2 = node2.getParentNode()) {
        }
        if (node2 == null) {
            return OffsetRange.NONE;
        }
        TokenSequence<? extends JsCommentTokenId> tokenSequence = AstUtilities.getCommentFor(jsParseResult, node2);
        if (tokenSequence != null) {
            tokenSequence.moveStart();
            while (tokenSequence.moveNext()) {
                String string2;
                CharSequence charSequence;
                Token token = tokenSequence.token();
                TokenId tokenId = token.id();
                if (tokenId != JsCommentTokenId.COMMENT_TAG || !TokenUtilities.textEquals((CharSequence)"@param", (CharSequence)(charSequence = token.text()))) continue;
                int n = tokenSequence.index();
                String string3 = JsCommentLexer.nextType(tokenSequence);
                if (string3 == null) {
                    tokenSequence.moveIndex(n);
                    tokenSequence.moveNext();
                }
                if ((string2 = JsCommentLexer.nextIdent(tokenSequence)) != null) {
                    if (!string.equals(string2)) continue;
                    int n2 = tokenSequence.offset();
                    return new OffsetRange(n2, n2 + string.length());
                }
                tokenSequence.moveIndex(n);
                tokenSequence.moveNext();
            }
        }
        return OffsetRange.NONE;
    }

    @CheckForNull
    private String getParameterName(TokenSequence<? extends JsCommentTokenId> tokenSequence, int n) {
        assert (tokenSequence != null);
        tokenSequence.move(n);
        if (!tokenSequence.moveNext() || tokenSequence.token().id() != JsCommentTokenId.IDENT) {
            return null;
        }
        tokenSequence.moveStart();
        while (tokenSequence.moveNext()) {
            String string;
            CharSequence charSequence;
            Token token = tokenSequence.token();
            TokenId tokenId = token.id();
            if (tokenId != JsCommentTokenId.COMMENT_TAG || !TokenUtilities.textEquals((CharSequence)"@param", (CharSequence)(charSequence = token.text()))) continue;
            int n2 = tokenSequence.index() + 1;
            String string2 = JsCommentLexer.nextType(tokenSequence);
            if (string2 == null) {
                tokenSequence.moveIndex(n2);
                tokenSequence.moveNext();
            }
            if ((string = JsCommentLexer.nextIdent(tokenSequence)) != null) {
                int n3 = tokenSequence.offset();
                if (n < n3 || n > n3 + string.length()) continue;
                return string;
            }
            tokenSequence.moveIndex(n2);
            tokenSequence.moveNext();
        }
        return null;
    }
}

