/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.wizard.fromdb;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.dbschema.SchemaElement;
import org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit;
import org.netbeans.modules.j2ee.persistence.entitygenerator.DbSchemaEjbGenerator;
import org.netbeans.modules.j2ee.persistence.entitygenerator.EntityClass;
import org.netbeans.modules.j2ee.persistence.entitygenerator.EntityRelation;
import org.netbeans.modules.j2ee.persistence.entitygenerator.GeneratedTables;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.DBSchemaFileList;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.PersistenceGenerator;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.SelectedTables;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.Table;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.TableClosure;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.TableSource;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.UpdateType;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class RelatedCMPHelper {
    private final Project project;
    private final FileObject configFilesFolder;
    private final PersistenceGenerator persistenceGen;
    private final DBSchemaFileList dbschemaFileList;
    private SchemaElement schemaElement;
    private DatabaseConnection dbconn;
    private FileObject dbschemaFile;
    private String datasourceName;
    private TableClosure tableClosure;
    private SelectedTables selectedTables;
    private SourceGroup location;
    private String packageName;
    private boolean cmpFieldsInInterface;
    private boolean generateFinderMethods;
    private DbSchemaEjbGenerator generator;
    private TableSource tableSource;
    private PersistenceUnit persistenceUnit;
    private boolean createPU = false;
    private boolean fullyQualifiedTableNames = false;
    private EntityRelation.FetchType fetchType = EntityRelation.FetchType.DEFAULT;
    private boolean regenTablesAttrs = false;
    private EntityRelation.CollectionType collectionType = EntityRelation.CollectionType.COLLECTION;

    public boolean isCreatePU() {
        return this.createPU;
    }

    public void setCreatePU(boolean bl) {
        this.createPU = bl;
    }

    public RelatedCMPHelper(Project project, FileObject fileObject, PersistenceGenerator persistenceGenerator) {
        this.project = project;
        this.configFilesFolder = fileObject;
        this.persistenceGen = persistenceGenerator;
        this.tableSource = TableSource.get(project);
        this.dbschemaFileList = new DBSchemaFileList(project, fileObject);
    }

    public Project getProject() {
        return this.project;
    }

    FileObject getConfigFilesFolder() {
        return this.configFilesFolder;
    }

    PersistenceGenerator getPersistenceGenerator() {
        return this.persistenceGen;
    }

    public DBSchemaFileList getDBSchemaFileList() {
        return this.dbschemaFileList;
    }

    public void setTableClosure(TableClosure tableClosure) {
        assert (tableClosure != null);
        this.tableClosure = tableClosure;
    }

    public TableClosure getTableClosure() {
        return this.tableClosure;
    }

    public void setSelectedTables(SelectedTables selectedTables) {
        assert (selectedTables != null);
        this.selectedTables = selectedTables;
    }

    public void setTableSource(SchemaElement schemaElement, DatabaseConnection databaseConnection, String string) {
        this.schemaElement = schemaElement;
        this.dbconn = databaseConnection;
        this.dbschemaFile = null;
        this.datasourceName = string;
        this.updateTableSource();
    }

    public void setTableSource(SchemaElement schemaElement, FileObject fileObject) {
        this.schemaElement = schemaElement;
        this.dbconn = null;
        this.dbschemaFile = fileObject;
        this.datasourceName = null;
        this.updateTableSource();
    }

    public TableSource getTableSource() {
        return this.tableSource;
    }

    private void updateTableSource() {
        this.tableSource = this.dbconn != null ? (this.datasourceName != null ? new TableSource(this.datasourceName, TableSource.Type.DATA_SOURCE) : new TableSource(this.dbconn.getName(), TableSource.Type.CONNECTION)) : (this.dbschemaFile != null ? new TableSource(FileUtil.toFile((FileObject)this.dbschemaFile).getAbsolutePath(), TableSource.Type.SCHEMA_FILE) : null);
    }

    public SchemaElement getSchemaElement() {
        return this.schemaElement;
    }

    public DatabaseConnection getDatabaseConnection() {
        return this.dbconn;
    }

    public FileObject getDBSchemaFile() {
        return this.dbschemaFile;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String string) {
        this.packageName = string;
    }

    public SourceGroup getLocation() {
        return this.location;
    }

    public void setLocation(SourceGroup sourceGroup) {
        this.location = sourceGroup;
    }

    public boolean isCmpFieldsInInterface() {
        return this.cmpFieldsInInterface;
    }

    public void setCmpFieldsInInterface(boolean bl) {
        this.cmpFieldsInInterface = bl;
    }

    public boolean isGenerateFinderMethods() {
        return this.generateFinderMethods;
    }

    public void setGenerateFinderMethods(boolean bl) {
        this.generateFinderMethods = bl;
    }

    public boolean isFullyQualifiedTableNames() {
        return this.fullyQualifiedTableNames;
    }

    public void setFullyQualifiedTableNames(boolean bl) {
        this.fullyQualifiedTableNames = bl;
    }

    public EntityRelation.FetchType getFetchType() {
        return this.fetchType;
    }

    public void setFetchType(EntityRelation.FetchType fetchType) {
        this.fetchType = fetchType;
    }

    public boolean isRegenTablesAttrs() {
        return this.regenTablesAttrs;
    }

    public void setRegenTablesAttrs(boolean bl) {
        this.regenTablesAttrs = bl;
    }

    public EntityRelation.CollectionType getCollectionType() {
        return this.collectionType;
    }

    public void setCollectionType(EntityRelation.CollectionType collectionType) {
        this.collectionType = collectionType;
    }

    public void buildBeans() {
        TableSource.put(this.project, this.tableSource);
        GenerateTablesImpl generateTablesImpl = new GenerateTablesImpl();
        FileObject fileObject = this.getLocation().getRootFolder();
        String string = this.getPackageName();
        for (Table table : this.selectedTables.getTables()) {
            generateTablesImpl.addTable(table.getCatalog(), table.getSchema(), table.getName(), fileObject, string, this.selectedTables.getClassName(table), this.selectedTables.getUpdateType(table), table.getUniqueConstraints());
        }
        this.generator = new DbSchemaEjbGenerator(generateTablesImpl, this.schemaElement, this.collectionType);
    }

    public EntityClass[] getBeans() {
        return this.generator.getBeans();
    }

    public EntityRelation[] getRelations() {
        return this.generator.getRelations();
    }

    private static final class GenerateTablesImpl
    implements GeneratedTables {
        private String catalog;
        private String schema;
        private final Set<String> tableNames = new HashSet<String>();
        private final Map<String, FileObject> rootFolders = new HashMap<String, FileObject>();
        private final Map<String, String> packageNames = new HashMap<String, String>();
        private final Map<String, String> classNames = new HashMap<String, String>();
        private final Map<String, UpdateType> updateTypes = new HashMap<String, UpdateType>();
        private final Map<String, Set<List<String>>> allUniqueConstraints = new HashMap<String, Set<List<String>>>();

        private GenerateTablesImpl() {
        }

        @Override
        public Set<String> getTableNames() {
            return Collections.unmodifiableSet(this.tableNames);
        }

        private void addTable(String string, String string2, String string3, FileObject fileObject, String string4, String string5, UpdateType updateType, Set<List<String>> set) {
            this.tableNames.add(string3);
            this.catalog = string;
            this.schema = string2;
            this.rootFolders.put(string3, fileObject);
            this.packageNames.put(string3, string4);
            this.classNames.put(string3, string5);
            this.updateTypes.put(string3, updateType);
            this.allUniqueConstraints.put(string3, set);
        }

        @Override
        public String getCatalog() {
            return this.catalog;
        }

        @Override
        public String getSchema() {
            return this.schema;
        }

        @Override
        public FileObject getRootFolder(String string) {
            return this.rootFolders.get(string);
        }

        @Override
        public String getPackageName(String string) {
            return this.packageNames.get(string);
        }

        @Override
        public String getClassName(String string) {
            return this.classNames.get(string);
        }

        @Override
        public UpdateType getUpdateType(String string) {
            return this.updateTypes.get(string);
        }

        @Override
        public Set<List<String>> getUniqueConstraints(String string) {
            return this.allUniqueConstraints.get(string);
        }
    }
}

