/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.graph.layout.orthogonalsupport;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.DirectionalGraph;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.EmbeddedPlanarGraph;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.Face;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.Logger;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.MGraph;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.OrthogonalRepresentation;

public class RectangularCompactor {
    private static int startOfNextBar;

    public void compact(Collection<OrthogonalRepresentation> ors) {
        startOfNextBar = 0;
        for (OrthogonalRepresentation or : ors) {
            this.compact(or);
        }
    }

    private void compact(OrthogonalRepresentation or) {
        this.insertBendVertices(or);
        this.assignEdgeDirections(or);
        this.refineShapes(or);
        DirectionalGraph hGraph = DirectionalGraph.createGraph(or, MGraph.Edge.Direction.HORIZONTAL);
        Collection<DirectionalGraph.Bar> bars = hGraph.getBars();
        Object[] barArray = new DirectionalGraph.Bar[bars.size()];
        bars.toArray(barArray);
        Arrays.sort(barArray);
        int x = startOfNextBar;
        int maxWidth = -1;
        for (Object bar : barArray) {
            x += maxWidth + 55;
            maxWidth = -1;
            for (MGraph.Vertex v : ((DirectionalGraph.Bar)bar).getVertices()) {
                int vWidth;
                if (v instanceof MGraph.DummyVertex) continue;
                v.setX(x);
                Dimension vDim = v.getSize();
                if (vDim == null || (vWidth = vDim.width) <= maxWidth) continue;
                maxWidth = vWidth;
            }
        }
        startOfNextBar = x + maxWidth;
        DirectionalGraph vGraph = DirectionalGraph.createGraph(or, MGraph.Edge.Direction.VERTICAL);
        bars = vGraph.getBars();
        barArray = new DirectionalGraph.Bar[bars.size()];
        bars.toArray(barArray);
        Arrays.sort(barArray);
        int y = 0;
        int maxHeight = 0;
        for (Object bar : barArray) {
            y += maxHeight + 55;
            maxHeight = -1;
            for (MGraph.Vertex v : ((DirectionalGraph.Bar)bar).getVertices()) {
                int vHeight;
                if (v instanceof MGraph.DummyVertex) continue;
                v.setY(y);
                Dimension vDim = v.getSize();
                if (vDim == null || (vHeight = vDim.height) <= maxHeight) continue;
                maxHeight = vHeight;
            }
        }
    }

    private void insertBendVertices(OrthogonalRepresentation or) {
        MGraph originalGraph = or.getOriginalGraph().getOriginalGraph();
        HashMap<MGraph.Edge, ArrayList<MGraph.Edge>> edgeMap = new HashMap<MGraph.Edge, ArrayList<MGraph.Edge>>();
        for (OrthogonalRepresentation.OrthogonalShape shape : or.getShapes()) {
            Face face = shape.getFace();
            ArrayList<Face.Dart> darts = new ArrayList<Face.Dart>(face.getDarts());
            for (Face.Dart dart : darts) {
                OrthogonalRepresentation.Tuple tuple = shape.getTuple(dart);
                if (tuple == null) continue;
                BitSet bends = tuple.getBends();
                int numOfBends = tuple.getNumberOfBends();
                if (numOfBends == 0) continue;
                MGraph.Edge edge = dart.getEdge();
                ArrayList<MGraph.Edge> newEdges = (ArrayList<MGraph.Edge>)edgeMap.get(edge);
                if (newEdges == null) {
                    newEdges = new ArrayList<MGraph.Edge>();
                    edgeMap.put(edge, newEdges);
                    MGraph.Vertex v = dart.getV();
                    MGraph.Vertex w = dart.getW();
                    for (int i = 0; i < numOfBends; ++i) {
                        MGraph.DummyVertex dv = originalGraph.insertDummyVertex(edge, MGraph.DummyVertex.Type.BEND);
                        newEdges.add(v.getEdge(dv));
                        edge = dv.getEdge(w);
                        v = dv;
                    }
                    newEdges.add(edge);
                }
                shape.updateTuple(tuple, newEdges);
            }
        }
    }

    private void assignEdgeDirections(OrthogonalRepresentation or) {
        Face outerFace = or.getOriginalGraph().getFaces().get(0);
        HashSet<Face> visitedFace = new HashSet<Face>();
        OrthogonalRepresentation.OrthogonalShape startingShape = or.getShape(outerFace);
        MGraph.Edge startingEdge = startingShape.getFace().getDarts().get(0).getEdge();
        startingEdge.setDirection(MGraph.Edge.Direction.HORIZONTAL);
        this.assignEdgeDirections(startingShape, startingEdge, or, visitedFace);
    }

    private void assignEdgeDirections(OrthogonalRepresentation.OrthogonalShape shape, MGraph.Edge startingEdge, OrthogonalRepresentation or, Set<Face> visitedFaces) {
        Face face = shape.getFace();
        visitedFaces.add(face);
        EmbeddedPlanarGraph epg = or.getOriginalGraph();
        List<Face.Dart> darts = face.getDarts();
        int startingIndex = 0;
        int size = darts.size();
        for (int i = 0; i < size; ++i) {
            if (startingEdge != darts.get(i).getEdge()) continue;
            startingIndex = i;
            break;
        }
        int index = startingIndex;
        MGraph.Edge.Direction prevDirection = null;
        do {
            Face oppositeFace;
            Face.Dart dart;
            MGraph.Edge edge;
            MGraph.Edge.Direction direction;
            if ((direction = (edge = (dart = darts.get(index)).getEdge()).getDirection()) == null) {
                OrthogonalRepresentation.Tuple t = shape.getTuple(dart);
                int angles = t.getAngles();
                direction = this.computeDirection(prevDirection, angles);
                edge.setDirection(direction);
            }
            if (!(oppositeFace = epg.getOppositeFace(face, dart)).isOuterFace() && !visitedFaces.contains(oppositeFace)) {
                this.assignEdgeDirections(or.getShape(oppositeFace), edge, or, visitedFaces);
            }
            prevDirection = direction;
            if (++index != size) continue;
            index = 0;
        } while (index != startingIndex);
    }

    private MGraph.Edge.Direction computeDirection(MGraph.Edge.Direction direction, int turns) {
        for (int i = 0; i < turns; ++i) {
            direction = direction == MGraph.Edge.Direction.HORIZONTAL ? MGraph.Edge.Direction.VERTICAL : MGraph.Edge.Direction.HORIZONTAL;
        }
        return direction;
    }

    private void refineShapes(OrthogonalRepresentation or) {
        HashMap<MGraph.Edge, Collection<MGraph.Edge>> edgeMap = new HashMap<MGraph.Edge, Collection<MGraph.Edge>>();
        OrthogonalRepresentation.OrthogonalShape outerShape = null;
        for (OrthogonalRepresentation.OrthogonalShape shape : or.getShapes()) {
            Face face = shape.getFace();
            if (face.isOuterFace()) {
                outerShape = shape;
                continue;
            }
            this.refineShape(shape, or, edgeMap);
        }
        this.refineShape(outerShape, or, edgeMap);
        this.addDummyOuterFace(outerShape, or);
    }

    private void updateShape(OrthogonalRepresentation.OrthogonalShape shape, Map<MGraph.Edge, Collection<MGraph.Edge>> edgeMap) {
        if (edgeMap.isEmpty()) {
            return;
        }
        Face face = shape.getFace();
        Face.Dart currentDart = face.getDarts().get(0);
        while (true) {
            MGraph.Edge edge;
            Collection<MGraph.Edge> newEdges;
            if ((newEdges = edgeMap.get(edge = currentDart.getEdge())) != null) {
                OrthogonalRepresentation.Tuple tuple = shape.getTuple(currentDart);
                shape.updateTuple(tuple, newEdges);
                currentDart = face.getDarts().get(0);
                continue;
            }
            if ((currentDart = face.getNextDart(currentDart)) == face.getDarts().get(0)) break;
        }
    }

    private void refineShape(OrthogonalRepresentation.OrthogonalShape shape, OrthogonalRepresentation or, Map<MGraph.Edge, Collection<MGraph.Edge>> edgeMap) {
        this.updateShape(shape, edgeMap);
        MGraph originalGraph = or.getOriginalGraph().getOriginalGraph();
        while (this.refineShapeSub(shape, originalGraph, edgeMap)) {
        }
    }

    private boolean refineShapeSub(OrthogonalRepresentation.OrthogonalShape shape, MGraph originalGraph, Map<MGraph.Edge, Collection<MGraph.Edge>> edgeMap) {
        Face.Dart firstDart;
        Face face = shape.getFace();
        Logger.log(0, "refining face " + face);
        ArrayList<Face.Dart> darts = new ArrayList<Face.Dart>(face.getDarts());
        Face.Dart currentDart = firstDart = darts.get(0);
        do {
            int turns = 0;
            Face.Dart nextDart = face.getNextDart(currentDart);
            Face.Dart frontDart = null;
            int numOfTurns = 0;
            Logger.log(0, "currentDart = " + currentDart);
            while (true) {
                Logger.log(0, "nextDart = " + nextDart);
                OrthogonalRepresentation.Tuple nextTuple = shape.getTuple(nextDart);
                int angles = nextTuple.getAngles();
                Logger.log(0, "angles = " + angles);
                ++numOfTurns;
                if (angles == 1) {
                    --turns;
                    Logger.log(0, "right turn");
                } else if (angles == 3) {
                    ++turns;
                    Logger.log(0, "left turn");
                } else if (angles == 4) {
                    turns += 2;
                    Logger.log(0, "2 right turns");
                } else {
                    if (numOfTurns == 0) {
                        Logger.log(0, "break");
                        break;
                    }
                    --numOfTurns;
                    Logger.log(0, "straight");
                }
                if (turns == -1 && numOfTurns > 1) {
                    frontDart = nextDart;
                    Logger.log(0, "FRONT DART = " + frontDart);
                    Logger.log(0, "CURRENT DART = " + currentDart);
                    break;
                }
                if (numOfTurns == 4 || turns == 0 || nextDart == currentDart) break;
                nextDart = face.getNextDart(nextDart);
            }
            if (frontDart == null) continue;
            MGraph.Edge currentEdge = currentDart.getEdge();
            MGraph.Edge.Direction direction = currentEdge.getDirection();
            OrthogonalRepresentation.Tuple currentTuple = shape.getTuple(currentDart);
            if (currentTuple.getAngles() != -1) {
                ArrayList<MGraph.Edge> newEdges = new ArrayList<MGraph.Edge>();
                edgeMap.put(currentEdge, newEdges);
                MGraph.DummyVertex dv = originalGraph.insertDummyVertex(currentEdge, MGraph.DummyVertex.Type.TEMPORARY);
                MGraph.DummyEdge de = originalGraph.addDummyEdge(dv, frontDart.getV());
                if (direction == MGraph.Edge.Direction.VERTICAL) {
                    de.setDirection(MGraph.Edge.Direction.HORIZONTAL);
                } else {
                    de.setDirection(MGraph.Edge.Direction.VERTICAL);
                }
                MGraph.Vertex currentV = currentDart.getV();
                MGraph.Edge de1 = currentV.getEdge(dv);
                de1.setDirection(direction);
                newEdges.add(de1);
                MGraph.Vertex currentW = currentDart.getW();
                MGraph.Edge de2 = dv.getEdge(currentW);
                de2.setDirection(direction);
                newEdges.add(de2);
                shape.updateTuple(shape.getTuple(currentDart), newEdges);
                shape.insertEdge(de);
            } else {
                MGraph.DummyEdge de = originalGraph.addDummyEdge(currentDart.getV(), frontDart.getV());
                if (direction == MGraph.Edge.Direction.VERTICAL) {
                    de.setDirection(MGraph.Edge.Direction.HORIZONTAL);
                } else {
                    de.setDirection(MGraph.Edge.Direction.VERTICAL);
                }
                shape.insertEdge(de);
            }
            return true;
        } while ((currentDart = face.getNextDart(currentDart)) != firstDart);
        return false;
    }

    private void addDummyOuterFace(OrthogonalRepresentation.OrthogonalShape shape, OrthogonalRepresentation or) {
        MGraph.DummyVertex dv;
        MGraph graph = or.getOriginalGraph().getOriginalGraph();
        ArrayList<MGraph.Edge> dummyEdges1 = new ArrayList<MGraph.Edge>();
        ArrayList<MGraph.Edge> dummyEdges2 = new ArrayList<MGraph.Edge>();
        MGraph.DummyVertex cornerVertex = dv = graph.addDummyVertex(MGraph.DummyVertex.Type.TEMPORARY);
        for (int i = 0; i < 4; ++i) {
            MGraph.DummyVertex dw = null;
            dw = i < 3 ? graph.addDummyVertex(MGraph.DummyVertex.Type.TEMPORARY) : cornerVertex;
            MGraph.DummyEdge de = graph.addDummyEdge(dv, dw);
            dummyEdges1.add(de);
            if (i == 0 || i == 2) {
                de.setDirection(MGraph.Edge.Direction.VERTICAL);
            } else {
                de.setDirection(MGraph.Edge.Direction.HORIZONTAL);
            }
            dummyEdges2.add(null);
            dv = dw;
        }
        Face face = shape.getFace();
        List<Face.Dart> darts = face.getDarts();
        Face.Dart firstDart = darts.get(0);
        Face.Dart lastDart = darts.get(darts.size() - 1);
        Face.Dart currentDart = firstDart;
        int index = 0;
        int counter = 0;
        int firstIndex = -1;
        boolean needToSwap = false;
        boolean swapped = false;
        boolean projected = false;
        if (firstDart.getDirection() == MGraph.Edge.Direction.VERTICAL) {
            index = 1;
        }
        while (true) {
            Face.Dart nextDart;
            int angles;
            if ((angles = shape.getTuple(nextDart = face.getNextDart(currentDart)).getAngles()) == 3 || angles == 4) {
                int turns = 0;
                while (true) {
                    OrthogonalRepresentation.Tuple nextTuple;
                    if ((angles = (nextTuple = shape.getTuple(nextDart)).getAngles()) == 1) {
                        --turns;
                    } else if (angles == 3) {
                        ++turns;
                    } else if (angles == 4) {
                        turns += 2;
                    }
                    if (turns == 4) {
                        projected = true;
                        if (firstIndex == -1) {
                            firstIndex = index;
                        }
                        MGraph.Edge de = (MGraph.Edge)dummyEdges1.get(index);
                        MGraph.Edge.Direction direction = de.getDirection();
                        MGraph.Vertex v = de.getV();
                        MGraph.Vertex w = de.getW();
                        dv = graph.insertDummyVertex(de, MGraph.DummyVertex.Type.TEMPORARY);
                        de = graph.addDummyEdge(currentDart.getW(), dv);
                        if (direction == MGraph.Edge.Direction.HORIZONTAL) {
                            de.setDirection(MGraph.Edge.Direction.VERTICAL);
                        } else {
                            de.setDirection(MGraph.Edge.Direction.HORIZONTAL);
                        }
                        MGraph.Edge e1 = dv.getEdge(w);
                        e1.setDirection(direction);
                        dummyEdges1.set(index, e1);
                        MGraph.Edge e2 = v.getEdge(dv);
                        e2.setDirection(direction);
                        if (dummyEdges2.get(index) != null) break;
                        dummyEdges2.set(index, e2);
                        break;
                    }
                    if (nextDart == currentDart) break;
                    nextDart = face.getNextDart(nextDart);
                }
            }
            if ((currentDart = face.getNextDart(currentDart)) == firstDart) break;
            angles = shape.getTuple(currentDart).getAngles();
            if (angles == 1) {
                if (--index == -1) {
                    index = 3;
                }
                --counter;
            } else if (angles == 3) {
                if (++index == 4) {
                    index = 0;
                }
                ++counter;
            } else if (angles == 4) {
                if ((index += 2) >= 4) {
                    index -= 4;
                }
                counter += 2;
            }
            if (counter == 3 && !needToSwap) {
                needToSwap = true;
            }
            if (!needToSwap || swapped || index != firstIndex) continue;
            swapped = true;
            MGraph.Edge de = (MGraph.Edge)dummyEdges2.get(firstIndex);
            if (de == null) continue;
            dummyEdges1.set(firstIndex, de);
        }
        if (projected) {
            or.setCornerVertex(cornerVertex);
        }
    }
}

