/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor.hints;

import java.util.Collections;
import java.util.List;
import javax.lang.model.element.ExecutableElement;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.core.syntax.completion.api.ELExpression;
import org.netbeans.modules.web.jsf.api.editor.JSFBeanCache;
import org.netbeans.modules.web.jsf.api.facesmodel.ResourceBundle;
import org.netbeans.modules.web.jsf.editor.el.JsfElExpression;
import org.netbeans.modules.web.jsf.editor.hints.HintsProvider;
import org.netbeans.spi.lexer.MutableTextInput;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public abstract class ElContextChecker {
    static final String DISABLE_ERROR_CHECKS_KEY = "disable_el_error_checking";

    public boolean check(JsfElExpression jsfElExpression, Document document, FileObject fileObject, List<Hint> list) {
        if (ElContextChecker.isErrorCheckingEnabled(fileObject)) {
            return this.checkImpl(jsfElExpression, document, fileObject, list);
        }
        EnableErrorChecksFix enableErrorChecksFix = new EnableErrorChecksFix(fileObject, document);
        EnableELChecksHint enableELChecksHint = new EnableELChecksHint((Rule)HintsProvider.DEFAULT_WARNING_RULE, NbBundle.getMessage(ElContextChecker.class, (String)"MSG_HINT_ENABLE_ERROR_CHECKS_FILE_DESCR"), fileObject, new OffsetRange(0, 0), Collections.singletonList(enableErrorChecksFix), 50);
        if (!list.contains((Object)enableELChecksHint)) {
            list.add(enableELChecksHint);
        }
        return true;
    }

    public abstract boolean checkImpl(JsfElExpression var1, Document var2, FileObject var3, List<Hint> var4);

    public static boolean isErrorCheckingEnabled(FileObject fileObject) {
        return fileObject.getAttribute(DISABLE_ERROR_CHECKS_KEY) == null;
    }

    private static void forceReparse(final Document document) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NbEditorDocument nbEditorDocument = (NbEditorDocument)document;
                nbEditorDocument.runAtomic(new Runnable(){

                    @Override
                    public void run() {
                        MutableTextInput mutableTextInput = (MutableTextInput)document.getProperty(MutableTextInput.class);
                        if (mutableTextInput != null) {
                            mutableTextInput.tokenHierarchyControl().rebuild();
                        }
                    }
                });
            }
        });
    }

    private static class EnableELChecksHint
    extends Hint {
        public EnableELChecksHint(Rule rule, String string, FileObject fileObject, OffsetRange offsetRange, List<HintFix> list, int n) {
            super(rule, string, fileObject, offsetRange, list, n);
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            return ((Object)((Object)this)).getClass() == object.getClass();
        }

        public int hashCode() {
            return super.hashCode();
        }
    }

    private static final class EnableErrorChecksFix
    implements HintFix {
        private FileObject fo;
        private Document doc;

        public EnableErrorChecksFix(FileObject fileObject, Document document) {
            this.fo = fileObject;
            this.doc = document;
        }

        public String getDescription() {
            return NbBundle.getMessage(ElContextChecker.class, (String)"MSG_HINT_ENABLE_ERROR_CHECKS_FILE");
        }

        public void implement() throws Exception {
            this.fo.setAttribute(ElContextChecker.DISABLE_ERROR_CHECKS_KEY, null);
            ElContextChecker.forceReparse(this.doc);
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }
    }

    private static final class DisableErrorChecksFix
    implements HintFix {
        private static String VALUE = "true";
        private FileObject fo;
        private Document doc;

        public DisableErrorChecksFix(FileObject fileObject, Document document) {
            this.fo = fileObject;
            this.doc = document;
        }

        public String getDescription() {
            return NbBundle.getMessage(ElContextChecker.class, (String)"MSG_HINT_DISABLE_ERROR_CHECKS_FILE");
        }

        public void implement() throws Exception {
            this.fo.setAttribute(ElContextChecker.DISABLE_ERROR_CHECKS_KEY, (Object)VALUE);
            ElContextChecker.forceReparse(this.doc);
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }
    }

    public static class ElExpressionPropertyHint
    extends Hint {
        private String property;

        public ElExpressionPropertyHint(Rule rule, String string, FileObject fileObject, OffsetRange offsetRange, List<HintFix> list, int n, String string2) {
            super(rule, string, fileObject, offsetRange, list, n);
            this.property = string2;
        }

        public String getProperty() {
            return this.property;
        }
    }

    public static class JsfElResourceBundleContextChecker
    extends ElContextChecker {
        @Override
        public boolean checkImpl(JsfElExpression jsfElExpression, Document document, FileObject fileObject, List<Hint> list) {
            String string3;
            String string2 = jsfElExpression.getPropertyBeingTypedName();
            if (string2.length() > 0 && string2.charAt(string2.length() - 1) == ']') {
                string2 = string2.substring(0, string2.length() - 1);
            }
            string2 = jsfElExpression.removeQuotes(string2);
            List<String> list2 = jsfElExpression.getPropertyKeys(jsfElExpression.getBundleName(), string2, null);
            for (String string3 : list2) {
                if (string3 == null || !string3.equals(string2)) continue;
                return true;
            }
            int n = jsfElExpression.getExpression().lastIndexOf(string2);
            string3 = new Hint((Rule)HintsProvider.DEFAULT_ERROR_RULE, NbBundle.getMessage(HintsProvider.class, (String)"MSG_UNKNOWN_RESOURCE_BUNDLE_CONTEXT", (Object)string2), fileObject, new OffsetRange(jsfElExpression.getStartOffset() + n, jsfElExpression.getStartOffset() + n + string2.length()), Collections.singletonList(new DisableErrorChecksFix(fileObject, document)), 50);
            list.add((Hint)string3);
            return true;
        }
    }

    public static class JsfElBeanContextChecker
    extends ElContextChecker {
        @Override
        public boolean checkImpl(final JsfElExpression jsfElExpression, Document document, FileObject fileObject, List<Hint> list) {
            JsfElExpression jsfElExpression2 = jsfElExpression;
            ((Object)((Object)jsfElExpression2)).getClass();
            ELExpression.InspectPropertiesTask inspectPropertiesTask = new ELExpression.InspectPropertiesTask(jsfElExpression2, jsfElExpression.getBaseObjectClass()){
                {
                    JsfElExpression jsfElExpression3 = jsfElExpression4;
                    ((Object)((Object)jsfElExpression3)).getClass();
                    super((ELExpression)jsfElExpression3, string);
                }

                public void run(CompilationController compilationController) throws Exception {
                    this.getTypePreceedingCaret(compilationController, true, true);
                }

                protected boolean checkMethodParameters(ExecutableElement executableElement, CompilationController compilationController) {
                    return true;
                }

                protected boolean checkMethod(ExecutableElement executableElement, CompilationController compilationController) {
                    return jsfElExpression.checkMethod(executableElement, compilationController);
                }
            };
            inspectPropertiesTask.execute();
            int n = inspectPropertiesTask.getOffset();
            String string = inspectPropertiesTask.getProperty();
            String string2 = jsfElExpression.getExpression();
            String string3 = jsfElExpression.getResolvedExpression();
            int n2 = string3.length() - string2.length();
            if ((n -= n2) == 0 && string != null) {
                Hint hint = new Hint((Rule)HintsProvider.DEFAULT_ERROR_RULE, NbBundle.getMessage(HintsProvider.class, (String)"MSG_UNKNOWN_BEAN_CONTEXT", (Object)string), fileObject, new OffsetRange(jsfElExpression.getStartOffset() + n, jsfElExpression.getStartOffset() + n + string.length()), Collections.singletonList(new DisableErrorChecksFix(fileObject, document)), 50);
                list.add(hint);
            } else if (n > 0 && string != null) {
                String string4 = inspectPropertiesTask.lastProperty() ? "MSG_UNKNOWN_PROPERTY_METHOD_CONTEXT" : "MSG_UNKNOWN_PROPERTY_CONTEXT";
                ElExpressionPropertyHint elExpressionPropertyHint = new ElExpressionPropertyHint((Rule)HintsProvider.DEFAULT_ERROR_RULE, NbBundle.getMessage(HintsProvider.class, (String)string4, (Object)string), fileObject, new OffsetRange(jsfElExpression.getStartOffset() + n, jsfElExpression.getStartOffset() + n + string.length()), Collections.singletonList(new DisableErrorChecksFix(fileObject, document)), 50, string);
                list.add(elExpressionPropertyHint);
            }
            return true;
        }
    }

    public static class JsfElStartContextChecker
    extends ElContextChecker {
        @Override
        public boolean checkImpl(JsfElExpression jsfElExpression, Document document, FileObject fileObject, List<Hint> list) {
            String string;
            Object object2;
            List list2 = JSFBeanCache.getBeans((WebModule)WebModule.getWebModule((FileObject)fileObject));
            for (Object object2 : list2) {
                string = object2.getManagedBeanName();
                if (!jsfElExpression.getExpression().equals(string)) continue;
                return true;
            }
            List<ResourceBundle> list3 = jsfElExpression.getJSFResourceBundles(WebModule.getWebModule((FileObject)fileObject));
            object2 = list3.iterator();
            while (object2.hasNext()) {
                string = (ResourceBundle)object2.next();
                String string2 = string.getVar();
                if (!jsfElExpression.getExpression().equals(string2)) continue;
                return true;
            }
            return false;
        }
    }

    public static class JsfElUnknownContextChecker
    extends ElContextChecker {
        @Override
        public boolean checkImpl(JsfElExpression jsfElExpression, Document document, FileObject fileObject, List<Hint> list) {
            String string = jsfElExpression.getBeanName();
            Hint hint = new Hint((Rule)HintsProvider.DEFAULT_ERROR_RULE, NbBundle.getMessage(ElContextChecker.class, (String)"MSG_UNKNOWN_BEAN_CONTEXT", (Object)string), fileObject, new OffsetRange(jsfElExpression.getStartOffset(), jsfElExpression.getStartOffset() + string.length()), Collections.singletonList(new DisableErrorChecksFix(fileObject, document)), 50);
            list.add(hint);
            return false;
        }
    }
}

