/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.model.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.NamespaceIndexFilter;
import org.netbeans.modules.php.editor.api.PhpModifiers;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.api.QualifiedNameKind;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.netbeans.modules.php.editor.model.ClassScope;
import org.netbeans.modules.php.editor.model.FieldElement;
import org.netbeans.modules.php.editor.model.FileScope;
import org.netbeans.modules.php.editor.model.FunctionScope;
import org.netbeans.modules.php.editor.model.InterfaceScope;
import org.netbeans.modules.php.editor.model.MethodScope;
import org.netbeans.modules.php.editor.model.ModelElement;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.NamespaceScope;
import org.netbeans.modules.php.editor.model.Scope;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.model.VariableName;
import org.netbeans.modules.php.editor.model.VariableScope;
import org.netbeans.modules.php.editor.model.impl.AssignmentImpl;
import org.netbeans.modules.php.editor.model.impl.CachingSupport;
import org.netbeans.modules.php.editor.model.impl.FieldElementImpl;
import org.netbeans.modules.php.editor.parser.api.Utils;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.ArrayCreation;
import org.netbeans.modules.php.editor.parser.astnodes.Assignment;
import org.netbeans.modules.php.editor.parser.astnodes.ClassInstanceCreation;
import org.netbeans.modules.php.editor.parser.astnodes.ClassName;
import org.netbeans.modules.php.editor.parser.astnodes.Comment;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.FieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.Include;
import org.netbeans.modules.php.editor.parser.astnodes.InfixExpression;
import org.netbeans.modules.php.editor.parser.astnodes.MethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.NamespaceName;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocBlock;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocTag;
import org.netbeans.modules.php.editor.parser.astnodes.ParenthesisExpression;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.netbeans.modules.php.editor.parser.astnodes.Reference;
import org.netbeans.modules.php.editor.parser.astnodes.Scalar;
import org.netbeans.modules.php.editor.parser.astnodes.SingleFieldDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.StaticFieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.StaticMethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.netbeans.modules.php.editor.parser.astnodes.VariableBase;
import org.netbeans.modules.php.project.api.PhpSourcePath;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Parameters;

public class VariousUtils {
    public static final String CONSTRUCTOR_TYPE_PREFIX = "constuct:";
    public static final String FUNCTION_TYPE_PREFIX = "fn:";
    public static final String METHOD_TYPE_PREFIX = "mtd:";
    public static final String STATIC_METHOD_TYPE_PREFIX = "static.mtd:";
    public static final String FIELD_TYPE_PREFIX = "fld:";
    public static final String STATIC_FIELD__TYPE_PREFIX = "static.fld:";
    public static final String VAR_TYPE_PREFIX = "var:";
    public static final String ARRAY_TYPE_PREFIX = "array:";
    private static Set<String> recursionDetection = new HashSet<String>();
    private static final Collection<PHPTokenId> CTX_DELIMITERS = Arrays.asList(PHPTokenId.PHP_OPENTAG, PHPTokenId.PHP_SEMICOLON, PHPTokenId.PHP_CURLY_OPEN, PHPTokenId.PHP_CURLY_CLOSE, PHPTokenId.PHP_RETURN, PHPTokenId.PHP_OPERATOR, PHPTokenId.PHP_ECHO, PHPTokenId.PHP_EVAL, PHPTokenId.PHP_NEW, PHPTokenId.PHP_NOT, PHPTokenId.PHP_CASE, PHPTokenId.PHP_IF, PHPTokenId.PHP_ELSE, PHPTokenId.PHP_ELSEIF, PHPTokenId.PHP_PRINT, PHPTokenId.PHP_FOR, PHPTokenId.PHP_FOREACH, PHPTokenId.PHP_WHILE, PHPTokenId.PHPDOC_COMMENT_END, PHPTokenId.PHP_COMMENT_END, PHPTokenId.PHP_LINE_COMMENT, PHPTokenId.PHP_CONSTANT_ENCAPSED_STRING, PHPTokenId.PHP_ENCAPSED_AND_WHITESPACE);

    public static String extractTypeFroVariableBase(VariableBase varBase) {
        return VariousUtils.extractTypeFroVariableBase(varBase, Collections.<String, AssignmentImpl>emptyMap());
    }

    static String extractTypeFroVariableBase(VariableBase varBase, Map<String, AssignmentImpl> allAssignments) {
        Stack<VariableBase> stack = new Stack<VariableBase>();
        String typeName = null;
        VariousUtils.createVariableBaseChain(varBase, stack);
        while (!stack.isEmpty() && stack.peek() != null) {
            varBase = stack.pop();
            String tmpType = VariousUtils.extractVariableTypeFromVariableBase(varBase, allAssignments);
            if (tmpType == null) {
                typeName = tmpType;
                break;
            }
            if (typeName == null) {
                typeName = tmpType;
                continue;
            }
            typeName = typeName + tmpType;
        }
        return typeName;
    }

    private VariousUtils() {
    }

    public static String getReturnTypeFromPHPDoc(Program root, FunctionDeclaration functionDeclaration) {
        return VariousUtils.getTypeFromPHPDoc(root, functionDeclaration, PHPDocTag.Type.RETURN);
    }

    public static String getFieldTypeFromPHPDoc(Program root, SingleFieldDeclaration field) {
        return VariousUtils.getTypeFromPHPDoc(root, field, PHPDocTag.Type.VAR);
    }

    public static Map<String, List<QualifiedName>> getParamTypesFromPHPDoc(Program root, ASTNode node) {
        HashMap<String, List<QualifiedName>> retval = new HashMap<String, List<QualifiedName>>();
        Comment comment = Utils.getCommentForNode(root, node);
        if (comment instanceof PHPDocBlock) {
            PHPDocBlock phpDoc = (PHPDocBlock)comment;
            for (PHPDocTag tag : phpDoc.getTags()) {
                String[] parts;
                if (tag.getKind() != PHPDocTag.Type.PARAM || (parts = tag.getValue().split("\\s+", 3)).length <= 1) continue;
                String[] typeNames = parts[0].split("\\|", 2);
                ArrayList<QualifiedName> types = new ArrayList<QualifiedName>();
                for (String tName : typeNames) {
                    types.add(QualifiedName.create(tName));
                }
                String name = parts[1].split("\\s+", 2)[0];
                retval.put(name, types);
            }
        }
        return retval;
    }

    public static String getTypeFromPHPDoc(Program root, ASTNode node, PHPDocTag.Type tagType) {
        Comment comment = Utils.getCommentForNode(root, node);
        if (comment instanceof PHPDocBlock) {
            PHPDocBlock phpDoc = (PHPDocBlock)comment;
            for (PHPDocTag tag : phpDoc.getTags()) {
                if (tag.getKind() != tagType) continue;
                String[] parts = tag.getValue().split("\\s+", 2);
                if (parts.length <= 0) break;
                String type = parts[0].split("\\;", 2)[0];
                return type;
            }
        }
        return null;
    }

    @CheckForNull
    static String extractVariableTypeFromAssignment(Assignment assignment, Map<String, AssignmentImpl> allAssignments) {
        Expression expression = assignment.getRightHandSide();
        return VariousUtils.extractVariableTypeFromExpression(expression, allAssignments);
    }

    static String extractVariableTypeFromExpression(Expression expression, Map<String, AssignmentImpl> allAssignments) {
        InfixExpression infixExpression;
        InfixExpression.OperatorType operator;
        if (expression instanceof Assignment) {
            return VariousUtils.extractVariableTypeFromAssignment((Assignment)expression, allAssignments);
        }
        if (expression instanceof Reference) {
            Reference ref = (Reference)expression;
            expression = ref.getExpression();
        }
        if (expression instanceof ClassInstanceCreation) {
            ClassInstanceCreation classInstanceCreation = (ClassInstanceCreation)expression;
            ClassName className = classInstanceCreation.getClassName();
            Expression name = className.getName();
            if (name instanceof NamespaceName) {
                QualifiedName qn = QualifiedName.create(name);
                return qn.toString();
            }
            return CodeUtils.extractClassName(className);
        }
        if (expression instanceof ArrayCreation) {
            return "array";
        }
        if (expression instanceof VariableBase) {
            return VariousUtils.extractTypeFroVariableBase((VariableBase)expression, allAssignments);
        }
        if (expression instanceof Scalar) {
            String stringValue;
            Scalar scalar = (Scalar)expression;
            Scalar.Type scalarType = scalar.getScalarType();
            if (scalarType.equals((Object)Scalar.Type.STRING) && ((stringValue = scalar.getStringValue().toLowerCase()).equals("false") || stringValue.equals("true"))) {
                return "boolean";
            }
            return scalarType.toString().toLowerCase();
        }
        if (expression instanceof InfixExpression && (operator = (infixExpression = (InfixExpression)expression).getOperator()).equals((Object)InfixExpression.OperatorType.CONCAT)) {
            return Scalar.Type.STRING.toString().toLowerCase();
        }
        return null;
    }

    public static String replaceVarNames(String semiTypeName, Map<String, String> var2Type) {
        StringBuilder retval = new StringBuilder();
        String[] fragments = semiTypeName.split("[@:]");
        for (int i = 0; i < fragments.length; ++i) {
            String frag = fragments[i];
            if (frag.trim().length() == 0) continue;
            if (VAR_TYPE_PREFIX.startsWith(frag)) {
                String varName;
                String type;
                if (i + 1 < fragments.length && (type = var2Type.get(varName = fragments[++i])) != null) {
                    retval.append(type);
                    continue;
                }
                return null;
            }
            Kind[] values = Kind.values();
            boolean isPrefix = false;
            for (Kind kind : values) {
                if (!kind.toString().startsWith(frag)) continue;
                isPrefix = true;
                break;
            }
            if (isPrefix) {
                retval.append("@");
                retval.append(frag);
                retval.append(":");
                isPrefix = true;
                continue;
            }
            retval.append(frag);
        }
        return retval.toString();
    }

    public static Collection<? extends VariableName> getAllVariables(VariableScope varScope, String semiTypeName) {
        ArrayList<VariableName> retval = new ArrayList<VariableName>();
        String[] fragments = semiTypeName.split("[@:]");
        for (int i = 0; i < fragments.length; ++i) {
            String varName;
            VariableName var;
            String frag = fragments[i];
            if (frag.trim().length() == 0 || !VAR_TYPE_PREFIX.startsWith(frag) || i + 1 >= fragments.length) continue;
            VariableName variableName = var = (varName = fragments[++i]) != null ? ModelUtils.getFirst(varScope.getDeclaredVariables(), varName) : null;
            if (var != null) {
                retval.add(var);
                continue;
            }
            return Collections.emptyList();
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static Collection<? extends TypeScope> getType(VariableScope varScope, String semiTypeName, int offset, boolean justDispatcher) throws IllegalStateException {
        Collection<Object> recentTypes = Collections.emptyList();
        List<TypeScope> oldRecentTypes = Collections.emptyList();
        Stack<VariableName> fldVarStack = new Stack<VariableName>();
        if (semiTypeName != null && semiTypeName.contains("@")) {
            String operation = null;
            String[] fragments = semiTypeName.split("[@:]");
            int len = justDispatcher ? fragments.length - 1 : fragments.length;
            for (int i = 0; i < len; ++i) {
                ArrayList<Object> newRecentTypes;
                String operationPrefix;
                oldRecentTypes = recentTypes;
                String frag = fragments[i].trim();
                if (frag.length() == 0) continue;
                String string = operationPrefix = frag.endsWith(":") ? frag : String.format("%s:", frag);
                if (METHOD_TYPE_PREFIX.equalsIgnoreCase(operationPrefix)) {
                    operation = METHOD_TYPE_PREFIX;
                    continue;
                }
                if (FUNCTION_TYPE_PREFIX.equalsIgnoreCase(operationPrefix)) {
                    operation = FUNCTION_TYPE_PREFIX;
                    continue;
                }
                if (STATIC_METHOD_TYPE_PREFIX.equalsIgnoreCase(operationPrefix)) {
                    operation = STATIC_METHOD_TYPE_PREFIX;
                    continue;
                }
                if (STATIC_FIELD__TYPE_PREFIX.equalsIgnoreCase(operationPrefix)) {
                    operation = FIELD_TYPE_PREFIX;
                    continue;
                }
                if (VAR_TYPE_PREFIX.equalsIgnoreCase(operationPrefix)) {
                    operation = VAR_TYPE_PREFIX;
                    continue;
                }
                if (ARRAY_TYPE_PREFIX.equalsIgnoreCase(operationPrefix)) {
                    operation = ARRAY_TYPE_PREFIX;
                    continue;
                }
                if (FIELD_TYPE_PREFIX.equalsIgnoreCase(operationPrefix)) {
                    operation = FIELD_TYPE_PREFIX;
                    continue;
                }
                if (CONSTRUCTOR_TYPE_PREFIX.equalsIgnoreCase(operationPrefix)) {
                    operation = CONSTRUCTOR_TYPE_PREFIX;
                    continue;
                }
                if (operation == null) {
                    assert (i == 0) : frag;
                    NamespaceIndexFilter filter = new NamespaceIndexFilter(frag);
                    QualifiedNameKind kind = filter.getKind();
                    String query = kind.isUnqualified() ? frag : filter.getName();
                    recentTypes = CachingSupport.getClasses(query, varScope);
                    if (recentTypes.isEmpty()) {
                        recentTypes = CachingSupport.getInterfaces(query, varScope);
                    }
                    if (kind.isUnqualified()) continue;
                    recentTypes = filter.filterModelElements(recentTypes, true);
                    continue;
                }
                if (operation.startsWith(CONSTRUCTOR_TYPE_PREFIX)) {
                    return Collections.emptyList();
                }
                if (operation.startsWith(METHOD_TYPE_PREFIX)) {
                    newRecentTypes = new ArrayList();
                    for (TypeScope tScope : oldRecentTypes) {
                        Collection<? extends MethodScope> inheritedMethods = CachingSupport.getMethods(tScope, frag, varScope, PhpModifiers.ALL_FLAGS);
                        for (MethodScope methodScope : inheritedMethods) {
                            newRecentTypes.addAll(methodScope.getReturnTypes(true));
                        }
                    }
                    recentTypes = newRecentTypes;
                    operation = null;
                    continue;
                }
                if (operation.startsWith(FUNCTION_TYPE_PREFIX)) {
                    newRecentTypes = new ArrayList();
                    FunctionScope fnc = ModelUtils.getFirst(CachingSupport.getFunctions(frag, varScope));
                    if (fnc != null) {
                        newRecentTypes.addAll(fnc.getReturnTypes(true));
                    }
                    recentTypes = newRecentTypes;
                    operation = null;
                    continue;
                }
                if (operation.startsWith(STATIC_METHOD_TYPE_PREFIX)) {
                    newRecentTypes = new ArrayList();
                    String[] frgs = frag.split("\\.");
                    assert (frgs.length == 2);
                    String clsName = frgs[0];
                    if (clsName != null) {
                        NamespaceIndexFilter filter;
                        QualifiedNameKind qualifiedNameKind;
                        boolean parent = false;
                        if (varScope instanceof MethodScope) {
                            Scope inScope;
                            if ("self".equals(clsName)) {
                                inScope = varScope.getInScope();
                                clsName = inScope.getName();
                            } else if ("parent".equals(clsName)) {
                                inScope = varScope.getInScope();
                                clsName = inScope.getName();
                                parent = true;
                            }
                        }
                        String query = (qualifiedNameKind = (filter = new NamespaceIndexFilter(frag)).getKind()).isUnqualified() ? frag : filter.getName();
                        recentTypes = CachingSupport.getClasses(query, varScope);
                        Collection<ModelElement> classes = CachingSupport.getClasses(clsName, varScope);
                        if (!qualifiedNameKind.isUnqualified()) {
                            classes = filter.filterModelElements(classes, true);
                        }
                        for (ClassScope classScope : classes) {
                            void var22_42;
                            ClassScope classScope2;
                            if (parent && (classScope2 = ModelUtils.getFirst(classScope.getSuperClasses())) == null) continue;
                            Collection<? extends MethodScope> inheritedMethods = CachingSupport.getMethods((TypeScope)var22_42, frgs[1], varScope, PhpModifiers.ALL_FLAGS);
                            for (MethodScope methodScope : inheritedMethods) {
                                newRecentTypes.addAll(methodScope.getReturnTypes(true));
                            }
                        }
                    }
                    recentTypes = newRecentTypes;
                    operation = null;
                    continue;
                }
                if (operation.startsWith(VAR_TYPE_PREFIX) || operation.startsWith(ARRAY_TYPE_PREFIX)) {
                    newRecentTypes = new ArrayList();
                    String varName = frag;
                    VariableName var = ModelUtils.getFirst(varScope.getDeclaredVariables(), varName);
                    if (var != null) {
                        if (i + 2 < len && FIELD_TYPE_PREFIX.startsWith(fragments[i + 1])) {
                            fldVarStack.push(var);
                        }
                        String checkName = var.getName() + String.valueOf(offset);
                        boolean added = recursionDetection.add(checkName);
                        try {
                            if (added) {
                                boolean bl = operation.startsWith(ARRAY_TYPE_PREFIX);
                                if (bl) {
                                    newRecentTypes.addAll(var.getArrayAccessTypes(offset));
                                } else {
                                    newRecentTypes.addAll(var.getTypes(offset));
                                }
                            }
                        }
                        finally {
                            recursionDetection.remove(checkName);
                        }
                    }
                    if (newRecentTypes.isEmpty() && varScope instanceof MethodScope) {
                        Scope inScope;
                        MethodScope mScope = (MethodScope)varScope;
                        if ((frag.equals("this") || frag.equals("$this")) && (inScope = mScope.getInScope()) instanceof ClassScope) {
                            String string2 = ((ClassScope)inScope).getName();
                            newRecentTypes.addAll(CachingSupport.getClasses(string2, varScope));
                        }
                    }
                    recentTypes = newRecentTypes;
                    operation = null;
                    continue;
                }
                if (operation.startsWith(FIELD_TYPE_PREFIX)) {
                    VariableName var = fldVarStack.isEmpty() ? null : (VariableName)fldVarStack.pop();
                    ArrayList newRecentTypes2 = new ArrayList();
                    String fldName = frag;
                    if (!fldName.startsWith("$")) {
                        fldName = "$" + fldName;
                    }
                    for (TypeScope type : oldRecentTypes) {
                        if (!(type instanceof ClassScope)) continue;
                        ClassScope classScope = (ClassScope)type;
                        Collection<? extends FieldElement> inheritedFields = CachingSupport.getInheritedFields(classScope, fldName, varScope, PhpModifiers.ALL_FLAGS);
                        for (FieldElement fieldElement : inheritedFields) {
                            if (var != null) {
                                Collection collection = var.getFieldTypes(fieldElement, offset);
                                if (collection.isEmpty() && fieldElement instanceof FieldElementImpl) {
                                    newRecentTypes2.addAll(((FieldElementImpl)fieldElement).getDefaultTypes());
                                    continue;
                                }
                                newRecentTypes2.addAll(collection);
                                continue;
                            }
                            newRecentTypes2.addAll(fieldElement.getTypes(offset));
                        }
                    }
                    recentTypes = newRecentTypes2;
                    operation = null;
                    continue;
                }
                throw new UnsupportedOperationException(operation);
            }
        } else if (semiTypeName != null) {
            NamespaceIndexFilter filter = new NamespaceIndexFilter(semiTypeName);
            QualifiedName qn = QualifiedName.create(semiTypeName);
            QualifiedNameKind kind = qn.getKind();
            String query = kind.isUnqualified() ? semiTypeName : filter.getName();
            Collection<ModelElement> retval = new ArrayList<TypeScope>(CachingSupport.getTypes(query, varScope));
            if (retval.isEmpty() && varScope instanceof MethodScope) {
                query = VariousUtils.translateSpecialClassName(varScope, query);
                retval = new ArrayList<TypeScope>(CachingSupport.getTypes(query, varScope));
            }
            if (!kind.isUnqualified()) {
                retval = filter.filterModelElements(retval, true);
            }
            return retval;
        }
        return recentTypes;
    }

    public static Stack<? extends ModelElement> getElemenst(FileScope topScope, VariableScope varScope, String semiTypeName, int offset) throws IllegalStateException {
        Stack emptyStack = new Stack();
        Stack<ModelElement> retval = new Stack<ModelElement>();
        Stack<String> stack = new Stack<String>();
        TypeScope type = null;
        if (semiTypeName != null && semiTypeName.contains("@")) {
            String operation = null;
            String[] fragments = semiTypeName.split("[@:]");
            int len = fragments.length;
            for (int i = 0; i < len; ++i) {
                ClassScope cls;
                String clsName;
                String operationPrefix;
                String frag = fragments[i];
                if (frag.trim().length() == 0) continue;
                String string = operationPrefix = frag.endsWith(":") ? frag : String.format("%s:", frag);
                if (METHOD_TYPE_PREFIX.equalsIgnoreCase(operationPrefix)) {
                    operation = METHOD_TYPE_PREFIX;
                    continue;
                }
                if (FUNCTION_TYPE_PREFIX.equalsIgnoreCase(operationPrefix)) {
                    assert (operation == null);
                    operation = FUNCTION_TYPE_PREFIX;
                    continue;
                }
                if (STATIC_METHOD_TYPE_PREFIX.equalsIgnoreCase(operationPrefix)) {
                    assert (operation == null);
                    operation = STATIC_METHOD_TYPE_PREFIX;
                    continue;
                }
                if (VAR_TYPE_PREFIX.equalsIgnoreCase(operationPrefix)) {
                    assert (operation == null);
                    operation = VAR_TYPE_PREFIX;
                    continue;
                }
                if (FIELD_TYPE_PREFIX.equalsIgnoreCase(operationPrefix)) {
                    assert (operation == null);
                    operation = FIELD_TYPE_PREFIX;
                    continue;
                }
                if (CONSTRUCTOR_TYPE_PREFIX.equalsIgnoreCase(operationPrefix)) {
                    assert (operation == null);
                    operation = CONSTRUCTOR_TYPE_PREFIX;
                    continue;
                }
                if (operation == null) {
                    assert (i == 0);
                    stack.push(frag);
                    continue;
                }
                if (operation.startsWith(METHOD_TYPE_PREFIX)) {
                    String string2 = clsName = stack.isEmpty() ? null : (String)stack.pop();
                    if (clsName == null) {
                        return emptyStack;
                    }
                    cls = ModelUtils.getFirst(CachingSupport.getClasses(clsName, topScope));
                    if (cls == null) {
                        return emptyStack;
                    }
                    MethodScope meth = ModelUtils.getFirst(CachingSupport.getMethods(cls, frag, topScope, PhpModifiers.ALL_FLAGS));
                    if (meth == null) {
                        return emptyStack;
                    }
                    retval.push(meth);
                    type = ModelUtils.getFirst(meth.getReturnTypes(true));
                    if (type == null) {
                        semiTypeName = null;
                        break;
                    }
                    stack.push(type.getName());
                    operation = null;
                    continue;
                }
                if (operation.startsWith(FUNCTION_TYPE_PREFIX)) {
                    FunctionScope fnc = ModelUtils.getFirst(CachingSupport.getFunctions(frag, topScope));
                    if (fnc == null) {
                        semiTypeName = null;
                        break;
                    }
                    retval.push(fnc);
                    type = ModelUtils.getFirst(fnc.getReturnTypes(true));
                    if (type == null) {
                        semiTypeName = null;
                        break;
                    }
                    stack.push(type.getName());
                    operation = null;
                    continue;
                }
                if (operation.startsWith(CONSTRUCTOR_TYPE_PREFIX)) {
                    ClassScope cls2 = ModelUtils.getFirst(CachingSupport.getClasses(frag, topScope));
                    if (cls2 == null) {
                        semiTypeName = null;
                        break;
                    }
                    MethodScope meth = ModelUtils.getFirst(CachingSupport.getMethods(cls2, "__construct", topScope, PhpModifiers.ALL_FLAGS));
                    if (meth == null) {
                        return emptyStack;
                    }
                    retval.push(meth);
                    stack.push(cls2.getName());
                    operation = null;
                    continue;
                }
                if (operation.startsWith(STATIC_METHOD_TYPE_PREFIX)) {
                    String[] frgs = frag.split("\\.");
                    assert (frgs.length == 2);
                    String clsName2 = frgs[0];
                    if (clsName2 == null) {
                        return emptyStack;
                    }
                    ClassScope cls3 = ModelUtils.getFirst(CachingSupport.getClasses(clsName2, topScope));
                    if (cls3 == null) {
                        return emptyStack;
                    }
                    MethodScope meth = ModelUtils.getFirst(CachingSupport.getMethods(cls3, frgs[1], topScope, PhpModifiers.ALL_FLAGS));
                    if (meth == null) {
                        return emptyStack;
                    }
                    retval.push(meth);
                    type = ModelUtils.getFirst(meth.getReturnTypes(true));
                    if (type == null) {
                        semiTypeName = null;
                        break;
                    }
                    stack.push(type.getName());
                    operation = null;
                    continue;
                }
                if (operation.startsWith(VAR_TYPE_PREFIX)) {
                    List<? extends VariableName> variables;
                    NamespaceScope nScope;
                    VariableName varName;
                    type = null;
                    if (varScope instanceof MethodScope) {
                        MethodScope mScope = (MethodScope)varScope;
                        if (frag.equals("this") || frag.equals("$this")) {
                            type = (ClassScope)mScope.getInScope();
                        }
                        if (type != null) {
                            stack.push(type.getName());
                            operation = null;
                        }
                    } else if (varScope instanceof NamespaceScope && (varName = ModelUtils.getFirst((nScope = (NamespaceScope)varScope).getDeclaredVariables(), frag)) != null && (type = (TypeScope)ModelUtils.getFirst(varName.getTypes(offset))) != null) {
                        stack.push(type.getName());
                        operation = null;
                    }
                    if (type != null || (variables = ModelUtils.filter(varScope.getDeclaredVariables(), frag)).isEmpty()) continue;
                    varName = ModelUtils.getFirst(variables);
                    TypeScope typeScope = type = varName != null ? (TypeScope)ModelUtils.getFirst(varName.getTypes(offset)) : null;
                    if (varName != null) {
                        retval.push(varName);
                    }
                    if (type == null) {
                        semiTypeName = null;
                        break;
                    }
                    stack.push(type.getName());
                    operation = null;
                    continue;
                }
                if (operation.startsWith(FIELD_TYPE_PREFIX)) {
                    String string3 = clsName = stack.isEmpty() ? null : (String)stack.pop();
                    if (clsName == null) {
                        return emptyStack;
                    }
                    cls = ModelUtils.getFirst(CachingSupport.getClasses(clsName, topScope));
                    if (cls == null) {
                        return emptyStack;
                    }
                    FieldElement fieldElement = ModelUtils.getFirst(CachingSupport.getInheritedFields(cls, !frag.startsWith("$") ? String.format("%s%s", "$", frag) : frag, topScope, PhpModifiers.ALL_FLAGS));
                    if (fieldElement == null) {
                        return emptyStack;
                    }
                    retval.push(fieldElement);
                    type = (TypeScope)ModelUtils.getFirst(fieldElement.getTypes(offset));
                    if (type == null) {
                        semiTypeName = null;
                        break;
                    }
                    stack.push(type.getName());
                    operation = null;
                    continue;
                }
                throw new UnsupportedOperationException(operation);
            }
            if (stack.size() == 1) {
                semiTypeName = (String)stack.pop();
            }
        }
        return retval;
    }

    private static void createVariableBaseChain(VariableBase node, Stack<VariableBase> stack) {
        stack.push(node);
        if (node instanceof MethodInvocation) {
            VariousUtils.createVariableBaseChain(((MethodInvocation)node).getDispatcher(), stack);
        } else if (node instanceof FieldAccess) {
            VariousUtils.createVariableBaseChain(((FieldAccess)node).getDispatcher(), stack);
        }
    }

    private static String extractVariableTypeFromVariableBase(VariableBase varBase, Map<String, AssignmentImpl> allAssignments) {
        if (varBase instanceof Variable) {
            String semiTypeName;
            String varName = CodeUtils.extractVariableName((Variable)varBase);
            AssignmentImpl assignmentImpl = allAssignments.get(varName);
            if (assignmentImpl != null && (semiTypeName = assignmentImpl.typeNameFromUnion()) != null) {
                return semiTypeName;
            }
            return "@var:" + varName;
        }
        if (varBase instanceof FunctionInvocation) {
            FunctionInvocation functionInvocation = (FunctionInvocation)varBase;
            String fname = CodeUtils.extractFunctionName(functionInvocation);
            return "@fn:" + fname;
        }
        if (varBase instanceof StaticMethodInvocation) {
            StaticMethodInvocation staticMethodInvocation = (StaticMethodInvocation)varBase;
            String className = CodeUtils.extractUnqualifiedClassName(staticMethodInvocation);
            String methodName = CodeUtils.extractFunctionName(staticMethodInvocation.getMethod());
            if (className != null && methodName != null) {
                return "@static.mtd:" + className + '.' + methodName;
            }
        } else if (varBase instanceof MethodInvocation) {
            MethodInvocation methodInvocation = (MethodInvocation)varBase;
            String methodName = CodeUtils.extractFunctionName(methodInvocation.getMethod());
            if (methodName != null) {
                return "@mtd:" + methodName;
            }
        } else if (varBase instanceof FieldAccess) {
            FieldAccess fieldAccess = (FieldAccess)varBase;
            String filedName = CodeUtils.extractVariableName(fieldAccess.getField());
            if (filedName != null) {
                return "@fld:" + filedName;
            }
        } else if (varBase instanceof StaticFieldAccess) {
            StaticFieldAccess fieldAccess = (StaticFieldAccess)varBase;
            String clsName = CodeUtils.extractUnqualifiedName(fieldAccess.getClassName());
            String fldName = CodeUtils.extractVariableName(fieldAccess.getField());
            if (clsName != null && fldName != null) {
                return clsName + "@" + STATIC_FIELD__TYPE_PREFIX + fldName;
            }
        }
        return null;
    }

    public static String resolveFileName(Include include) {
        Scalar s;
        Expression e = include.getExpression();
        if (e instanceof ParenthesisExpression) {
            e = ((ParenthesisExpression)e).getExpression();
        }
        if (e instanceof Scalar && Scalar.Type.STRING == (s = (Scalar)e).getScalarType()) {
            String fileName = s.getStringValue();
            fileName = fileName.length() >= 2 ? fileName.substring(1, fileName.length() - 1) : fileName;
            return fileName;
        }
        return null;
    }

    public static FileObject resolveInclude(FileObject sourceFile, Include include) {
        Parameters.notNull((CharSequence)"sourceFile", (Object)sourceFile);
        if (sourceFile.isFolder()) {
            throw new IllegalArgumentException(FileUtil.getFileDisplayName((FileObject)sourceFile));
        }
        return VariousUtils.resolveInclude(sourceFile, VariousUtils.resolveFileName(include));
    }

    public static FileObject resolveInclude(FileObject sourceFile, String fileName) {
        FileObject retval = null;
        if (fileName != null) {
            File absoluteFile = new File(fileName);
            if (absoluteFile.exists()) {
                retval = FileUtil.toFileObject((File)absoluteFile);
            } else {
                FileObject parent = sourceFile.getParent();
                if (parent != null) {
                    retval = PhpSourcePath.resolveFile((FileObject)parent, (String)fileName);
                }
            }
        }
        return retval;
    }

    public static String getSemiType(TokenSequence<PHPTokenId> tokenSequence, State state, VariableScope varScope) throws IllegalStateException {
        String retval;
        int commasCount = 0;
        int anchor = -1;
        int leftBraces = 0;
        int rightBraces = State.PARAMS.equals((Object)state) ? 1 : 0;
        StringBuilder metaAll = new StringBuilder();
        while (!state.equals((Object)State.INVALID) && !state.equals((Object)State.STOP) && tokenSequence.movePrevious() && VariousUtils.skipWhitespaces(tokenSequence)) {
            Token token = tokenSequence.token();
            if (!CTX_DELIMITERS.contains(token.id())) {
                switch (state) {
                    case METHOD: 
                    case START: {
                        State state2 = state = state.equals((Object)State.METHOD) ? State.STOP : State.INVALID;
                        if (VariousUtils.isReference((Token<PHPTokenId>)token)) {
                            metaAll.insert(0, "@mtd:");
                            state = State.REFERENCE;
                            break;
                        }
                        if (VariousUtils.isStaticReference((Token<PHPTokenId>)token)) {
                            metaAll.insert(0, "@mtd:");
                            state = State.STATIC_REFERENCE;
                            break;
                        }
                        if (!state.equals((Object)State.STOP)) break;
                        metaAll.insert(0, "@fn:");
                        break;
                    }
                    case IDX: {
                        if (VariousUtils.isLeftArryBracket((Token<PHPTokenId>)token)) {
                            state = State.ARRAYREFERENCE;
                            break;
                        }
                        if (!CTX_DELIMITERS.contains(token.id())) break;
                        state = State.INVALID;
                        break;
                    }
                    case ARRAYREFERENCE: 
                    case REFERENCE: {
                        boolean isArray = state.equals((Object)State.ARRAYREFERENCE);
                        state = State.INVALID;
                        if (VariousUtils.isRightBracket((Token<PHPTokenId>)token)) {
                            ++rightBraces;
                            state = State.PARAMS;
                            break;
                        }
                        if (VariousUtils.isRightArryBracket((Token<PHPTokenId>)token)) {
                            state = State.IDX;
                            break;
                        }
                        if (VariousUtils.isString((Token<PHPTokenId>)token)) {
                            metaAll.insert(0, ((Object)token.text()).toString());
                            state = isArray ? State.ARRAY_FIELD : State.FIELD;
                            break;
                        }
                        if (!VariousUtils.isVariable((Token<PHPTokenId>)token)) break;
                        metaAll.insert(0, ((Object)token.text()).toString());
                        state = isArray ? State.ARRAY_VARIABLE : State.VARBASE;
                        break;
                    }
                    case STATIC_REFERENCE: {
                        state = State.INVALID;
                        if (VariousUtils.isString((Token<PHPTokenId>)token)) {
                            metaAll.insert(0, "@fld:");
                            metaAll.insert(0, ((Object)token.text()).toString());
                            state = State.CLASSNAME;
                            break;
                        }
                        if (!VariousUtils.isSelf((Token<PHPTokenId>)token) && !VariousUtils.isParent((Token<PHPTokenId>)token)) break;
                        metaAll.insert(0, "@fld:");
                        metaAll.insert(0, VariousUtils.translateSpecialClassName(varScope, ((Object)token.text()).toString()));
                        state = State.CLASSNAME;
                        break;
                    }
                    case PARAMS: {
                        if (VariousUtils.isWhiteSpace((Token<PHPTokenId>)token)) {
                            state = State.PARAMS;
                        } else if (VariousUtils.isComma((Token<PHPTokenId>)token)) {
                            if (metaAll.length() == 0) {
                                ++commasCount;
                            }
                        } else if (CTX_DELIMITERS.contains(token.id())) {
                            state = State.INVALID;
                        } else if (VariousUtils.isLeftBracket((Token<PHPTokenId>)token)) {
                            ++leftBraces;
                        } else if (VariousUtils.isRightBracket((Token<PHPTokenId>)token)) {
                            ++rightBraces;
                        }
                        if (leftBraces != rightBraces) break;
                        state = State.FUNCTION;
                        break;
                    }
                    case FUNCTION: {
                        state = State.INVALID;
                        if (!VariousUtils.isString((Token<PHPTokenId>)token)) break;
                        metaAll.insert(0, ((Object)token.text()).toString());
                        if (anchor == -1) {
                            anchor = tokenSequence.offset();
                        }
                        state = State.METHOD;
                        break;
                    }
                    case ARRAY_FIELD: 
                    case FIELD: {
                        state = State.INVALID;
                        if (!VariousUtils.isReference((Token<PHPTokenId>)token)) break;
                        metaAll.insert(0, "@fld:");
                        state = State.REFERENCE;
                        break;
                    }
                    case VARBASE: {
                        state = State.INVALID;
                        if (VariousUtils.isStaticReference((Token<PHPTokenId>)token)) {
                            state = State.STATIC_REFERENCE;
                            break;
                        }
                        state = State.VARIABLE;
                    }
                    case ARRAY_VARIABLE: 
                    case VARIABLE: {
                        if (state.equals((Object)State.ARRAY_VARIABLE)) {
                            metaAll.insert(0, "@array:");
                        } else {
                            metaAll.insert(0, "@var:");
                        }
                    }
                    case CLASSNAME: {
                        if (VariousUtils.isNamespaceSeparator((Token<PHPTokenId>)token) && tokenSequence.movePrevious()) {
                            metaAll.insert(0, ((Object)token.text()).toString());
                            token = tokenSequence.token();
                            if (VariousUtils.isString((Token<PHPTokenId>)token)) {
                                metaAll.insert(0, ((Object)token.text()).toString());
                                break;
                            }
                        }
                        state = State.STOP;
                    }
                }
                continue;
            }
            if (state.equals((Object)State.CLASSNAME)) {
                state = State.STOP;
                break;
            }
            if (!state.equals((Object)State.METHOD)) continue;
            state = State.STOP;
            PHPTokenId id = (PHPTokenId)token.id();
            if (id != null && PHPTokenId.PHP_NEW.equals((Object)id)) {
                metaAll.insert(0, "@constuct:");
                break;
            }
            metaAll.insert(0, "@fn:");
            break;
        }
        if (state.equals((Object)State.STOP) && (retval = metaAll.toString()) != null) {
            return retval;
        }
        return null;
    }

    public static String getVariableName(String semiType) {
        String prefix;
        if (semiType != null && semiType.startsWith(prefix = "@var:")) {
            return semiType.substring(prefix.length(), semiType.lastIndexOf("@"));
        }
        return null;
    }

    private static boolean skipWhitespaces(TokenSequence<PHPTokenId> tokenSequence) {
        Token token = tokenSequence.token();
        while (token != null && VariousUtils.isWhiteSpace((Token<PHPTokenId>)token)) {
            boolean retval = tokenSequence.movePrevious();
            token = tokenSequence.token();
            if (retval) continue;
            return false;
        }
        return true;
    }

    private static String translateSpecialClassName(Scope scp, String clsName) {
        ClassScope classScope = null;
        if (scp instanceof ClassScope) {
            classScope = (ClassScope)scp;
        } else if (scp instanceof MethodScope) {
            MethodScope msi = (MethodScope)scp;
            classScope = (ClassScope)msi.getInScope();
        }
        if (classScope != null) {
            ClassScope clzScope;
            if ("self".equals(clsName) || "this".equals(clsName)) {
                clsName = classScope.getName();
            } else if ("parent".equals(clsName) && (clzScope = ModelUtils.getFirst(classScope.getSuperClasses())) != null) {
                clsName = clzScope.getName();
            }
        }
        return clsName;
    }

    private static boolean moveToOffset(TokenSequence<PHPTokenId> tokenSequence, int offset) {
        return tokenSequence == null || tokenSequence.move(offset) < 0;
    }

    private static boolean isDolar(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_TOKEN) && "$".contentEquals(token.text());
    }

    private static boolean isLeftBracket(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_TOKEN) && "(".contentEquals(token.text());
    }

    private static boolean isRightBracket(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_TOKEN) && ")".contentEquals(token.text());
    }

    private static boolean isRightArryBracket(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_TOKEN) && "]".contentEquals(token.text());
    }

    private static boolean isLeftArryBracket(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_TOKEN) && "[".contentEquals(token.text());
    }

    private static boolean isComma(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_TOKEN) && ",".contentEquals(token.text());
    }

    private static boolean isReference(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_OBJECT_OPERATOR);
    }

    private static boolean isNamespaceSeparator(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_NS_SEPARATOR);
    }

    private static boolean isWhiteSpace(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.WHITESPACE);
    }

    private static boolean isStaticReference(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_PAAMAYIM_NEKUDOTAYIM);
    }

    private static boolean isVariable(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_VARIABLE);
    }

    private static boolean isSelf(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_SELF);
    }

    private static boolean isParent(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_PARENT);
    }

    private static boolean isString(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_STRING);
    }

    public static Collection<? extends TypeScope> getStaticTypeName(Scope inScope, String staticTypeName) {
        TypeScope csi = null;
        if (inScope instanceof MethodScope) {
            MethodScope msi = (MethodScope)inScope;
            csi = (ClassScope)msi.getInScope();
        }
        if (inScope instanceof ClassScope || inScope instanceof InterfaceScope) {
            csi = (TypeScope)inScope;
        }
        if (csi != null) {
            if ("self".equals(staticTypeName)) {
                return Collections.singletonList(csi);
            }
            if ("parent".equals(staticTypeName) && csi instanceof ClassScope) {
                return ((ClassScope)csi).getSuperClasses();
            }
        }
        return CachingSupport.getTypes(staticTypeName, inScope);
    }

    public static enum State {
        START,
        METHOD,
        INVALID,
        VARBASE,
        DOLAR,
        PARAMS,
        ARRAYREFERENCE,
        REFERENCE,
        STATIC_REFERENCE,
        FUNCTION,
        FIELD,
        VARIABLE,
        ARRAY_FIELD,
        ARRAY_VARIABLE,
        CLASSNAME,
        STOP,
        IDX;

    }

    public static enum Kind {
        CONSTRUCTOR,
        FUNCTION,
        METHOD,
        STATIC_METHOD,
        FIELD,
        STATIC_FIELD,
        VAR;


        public String toString() {
            switch (this) {
                case CONSTRUCTOR: {
                    return VariousUtils.CONSTRUCTOR_TYPE_PREFIX;
                }
                case FUNCTION: {
                    return VariousUtils.FUNCTION_TYPE_PREFIX;
                }
                case METHOD: {
                    return VariousUtils.METHOD_TYPE_PREFIX;
                }
                case STATIC_METHOD: {
                    return VariousUtils.STATIC_METHOD_TYPE_PREFIX;
                }
                case FIELD: {
                    return VariousUtils.FIELD_TYPE_PREFIX;
                }
                case STATIC_FIELD: {
                    return VariousUtils.STATIC_FIELD__TYPE_PREFIX;
                }
                case VAR: {
                    return VariousUtils.VAR_TYPE_PREFIX;
                }
            }
            return super.toString();
        }
    }
}

