/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.ReportPlugin;

public class Reporting
implements Serializable {
    private boolean excludeDefaults = false;
    private String outputDirectory;
    private List plugins;
    Map reportPluginMap;
    private String modelEncoding = "UTF-8";

    public void addPlugin(ReportPlugin reportPlugin) {
        if (!(reportPlugin instanceof ReportPlugin)) {
            throw new ClassCastException("Reporting.addPlugins(reportPlugin) parameter must be instanceof " + ReportPlugin.class.getName());
        }
        this.getPlugins().add(reportPlugin);
    }

    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    public List getPlugins() {
        if (this.plugins == null) {
            this.plugins = new ArrayList();
        }
        return this.plugins;
    }

    public boolean isExcludeDefaults() {
        return this.excludeDefaults;
    }

    public void removePlugin(ReportPlugin reportPlugin) {
        if (!(reportPlugin instanceof ReportPlugin)) {
            throw new ClassCastException("Reporting.removePlugins(reportPlugin) parameter must be instanceof " + ReportPlugin.class.getName());
        }
        this.getPlugins().remove(reportPlugin);
    }

    public void setExcludeDefaults(boolean excludeDefaults) {
        this.excludeDefaults = excludeDefaults;
    }

    public void setOutputDirectory(String outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public void setPlugins(List plugins) {
        this.plugins = plugins;
    }

    public synchronized void flushReportPluginMap() {
        this.reportPluginMap = null;
    }

    public synchronized Map getReportPluginsAsMap() {
        if (this.reportPluginMap == null) {
            this.reportPluginMap = new HashMap();
            if (this.getPlugins() != null) {
                for (ReportPlugin reportPlugin : this.getPlugins()) {
                    this.reportPluginMap.put(reportPlugin.getKey(), reportPlugin);
                }
            }
        }
        return this.reportPluginMap;
    }

    public void setModelEncoding(String modelEncoding) {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding() {
        return this.modelEncoding;
    }
}

