/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.resolver;

import hidden.org.codehaus.plexus.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.Snapshot;
import org.apache.maven.artifact.repository.metadata.SnapshotArtifactRepositoryMetadata;
import org.apache.maven.artifact.repository.metadata.Versioning;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.DebugResolutionListener;
import org.apache.maven.artifact.resolver.MultipleArtifactsNotFoundException;
import org.apache.maven.artifact.resolver.ResolutionListener;
import org.apache.maven.artifact.resolver.ResolutionNode;
import org.apache.maven.artifact.resolver.WarningResolutionListener;
import org.apache.maven.artifact.resolver.conflict.ConflictResolver;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.transform.ArtifactTransformationManager;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.codehaus.plexus.logging.AbstractLogEnabled;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultArtifactResolver
extends AbstractLogEnabled
implements ArtifactResolver {
    private WagonManager wagonManager;
    private ArtifactTransformationManager transformationManager;
    protected ArtifactFactory artifactFactory;
    private ArtifactCollector artifactCollector;

    @Override
    public void resolve(Artifact artifact, List<ArtifactRepository> remoteRepositories, ArtifactRepository localRepository) throws ArtifactResolutionException, ArtifactNotFoundException {
        this.resolve(artifact, remoteRepositories, localRepository, false);
    }

    @Override
    public void resolveAlways(Artifact artifact, List<ArtifactRepository> remoteRepositories, ArtifactRepository localRepository) throws ArtifactResolutionException, ArtifactNotFoundException {
        this.resolve(artifact, remoteRepositories, localRepository, true);
    }

    private void resolve(Artifact artifact, List<ArtifactRepository> remoteRepositories, ArtifactRepository localRepository, boolean force) throws ArtifactResolutionException, ArtifactNotFoundException {
        if (artifact == null) {
            return;
        }
        if (Artifact.SCOPE_SYSTEM.equals(artifact.getScope())) {
            File systemFile = artifact.getFile();
            if (systemFile == null) {
                throw new ArtifactNotFoundException("System artifact: " + artifact + " has no file attached", artifact);
            }
            if (!systemFile.exists()) {
                throw new ArtifactNotFoundException("System artifact: " + artifact + " not found in path: " + systemFile, artifact);
            }
            if (!systemFile.isFile()) {
                throw new ArtifactNotFoundException("System artifact: " + artifact + " is not a file: " + systemFile, artifact);
            }
            artifact.setResolved(true);
        } else if (!artifact.isResolved()) {
            String localPath = localRepository.pathOf(artifact);
            artifact.setFile(new File(localRepository.getBasedir(), localPath));
            this.transformationManager.transformForResolve(artifact, remoteRepositories, localRepository);
            boolean localCopy = this.isLocalCopy(artifact);
            File destination = artifact.getFile();
            boolean resolved = false;
            if (!this.wagonManager.isOnline()) {
                if (!destination.exists()) {
                    throw new ArtifactNotFoundException("System is offline.", artifact);
                }
            } else if (force || !destination.exists() || artifact.isSnapshot() && !localCopy) {
                try {
                    if (artifact.getRepository() != null) {
                        this.wagonManager.getArtifact(artifact, artifact.getRepository(), force);
                    } else {
                        this.wagonManager.getArtifact(artifact, remoteRepositories, force);
                    }
                    if (!artifact.isResolved() && !destination.exists()) {
                        throw new ArtifactResolutionException("Failed to resolve artifact, possibly due to a repository list that is not appropriately equipped for this artifact's metadata.", artifact, this.getMirroredRepositories(remoteRepositories));
                    }
                }
                catch (ResourceDoesNotExistException e) {
                    throw new ArtifactNotFoundException(e.getMessage(), artifact, this.getMirroredRepositories(remoteRepositories), e);
                }
                catch (TransferFailedException e) {
                    throw new ArtifactResolutionException(e.getMessage(), artifact, this.getMirroredRepositories(remoteRepositories), e);
                }
                resolved = true;
            }
            if (destination.exists()) {
                artifact.setResolved(true);
            }
            if (artifact.isSnapshot() && !artifact.getBaseVersion().equals(artifact.getVersion())) {
                String version = artifact.getVersion();
                artifact.selectVersion(artifact.getBaseVersion());
                File copy = new File(localRepository.getBasedir(), localRepository.pathOf(artifact));
                if (resolved || !copy.exists()) {
                    try {
                        FileUtils.copyFile(destination, copy);
                        copy.setLastModified(destination.lastModified());
                    }
                    catch (IOException e) {
                        throw new ArtifactResolutionException("Unable to copy resolved artifact for local use: " + e.getMessage(), artifact, this.getMirroredRepositories(remoteRepositories), e);
                    }
                }
                artifact.setFile(copy);
                artifact.selectVersion(version);
            }
        }
    }

    private boolean isLocalCopy(Artifact artifact) {
        boolean localCopy = false;
        for (ArtifactMetadata m : artifact.getMetadataList()) {
            Snapshot snapshot;
            Versioning versioning;
            SnapshotArtifactRepositoryMetadata snapshotMetadata;
            Metadata metadata;
            if (!(m instanceof SnapshotArtifactRepositoryMetadata) || (metadata = (snapshotMetadata = (SnapshotArtifactRepositoryMetadata)m).getMetadata()) == null || (versioning = metadata.getVersioning()) == null || (snapshot = versioning.getSnapshot()) == null) continue;
            localCopy = snapshot.isLocalCopy();
        }
        return localCopy;
    }

    @Override
    public ArtifactResolutionResult resolveTransitively(Set<Artifact> artifacts, Artifact originatingArtifact, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories, ArtifactMetadataSource source, ArtifactFilter filter) throws ArtifactResolutionException, ArtifactNotFoundException {
        return this.resolveTransitively(artifacts, originatingArtifact, Collections.EMPTY_MAP, localRepository, remoteRepositories, source, filter);
    }

    @Override
    public ArtifactResolutionResult resolveTransitively(Set<Artifact> artifacts, Artifact originatingArtifact, Map managedVersions, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories, ArtifactMetadataSource source) throws ArtifactResolutionException, ArtifactNotFoundException {
        return this.resolveTransitively(artifacts, originatingArtifact, managedVersions, localRepository, remoteRepositories, source, null);
    }

    @Override
    public ArtifactResolutionResult resolveTransitively(Set<Artifact> artifacts, Artifact originatingArtifact, Map managedVersions, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories, ArtifactMetadataSource source, ArtifactFilter filter) throws ArtifactResolutionException, ArtifactNotFoundException {
        return this.resolveTransitively(artifacts, originatingArtifact, managedVersions, localRepository, remoteRepositories, source, filter, null);
    }

    @Override
    public ArtifactResolutionResult resolveTransitively(Set<Artifact> artifacts, Artifact originatingArtifact, List<ArtifactRepository> remoteRepositories, ArtifactRepository localRepository, ArtifactMetadataSource source) throws ArtifactResolutionException, ArtifactNotFoundException {
        return this.resolveTransitively(artifacts, originatingArtifact, localRepository, remoteRepositories, source, null);
    }

    @Override
    public ArtifactResolutionResult resolveTransitively(Set<Artifact> artifacts, Artifact originatingArtifact, List<ArtifactRepository> remoteRepositories, ArtifactRepository localRepository, ArtifactMetadataSource source, List<ResolutionListener> listeners) throws ArtifactResolutionException, ArtifactNotFoundException {
        return this.resolveTransitively(artifacts, originatingArtifact, Collections.EMPTY_MAP, localRepository, remoteRepositories, source, null, listeners);
    }

    @Override
    public ArtifactResolutionResult resolveTransitively(Set<Artifact> artifacts, Artifact originatingArtifact, Map managedVersions, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories, ArtifactMetadataSource source, ArtifactFilter filter, List<ResolutionListener> listeners) throws ArtifactResolutionException, ArtifactNotFoundException {
        return this.resolveTransitively(artifacts, originatingArtifact, managedVersions, localRepository, remoteRepositories, source, filter, listeners, null);
    }

    @Override
    public ArtifactResolutionResult resolveTransitively(Set<Artifact> artifacts, Artifact originatingArtifact, Map managedVersions, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories, ArtifactMetadataSource source, ArtifactFilter filter, List<ResolutionListener> listeners, List<ConflictResolver> conflictResolvers) throws ArtifactResolutionException, ArtifactNotFoundException {
        ArtifactResolutionResult result;
        if (listeners == null) {
            listeners = new ArrayList<ResolutionListener>();
            if (this.getLogger().isDebugEnabled()) {
                listeners.add(new DebugResolutionListener(this.getLogger()));
            }
            listeners.add(new WarningResolutionListener(this.getLogger()));
        }
        if ((result = this.artifactCollector.collect(artifacts, originatingArtifact, managedVersions, localRepository, remoteRepositories, source, filter, listeners, conflictResolvers)).hasMetadataResolutionExceptions()) {
            throw result.getMetadataResolutionException(0);
        }
        if (result.hasCircularDependencyExceptions()) {
            throw result.getCircularDependencyException(0);
        }
        if (result.hasVersionRangeViolations()) {
            throw result.getVersionRangeViolation(0);
        }
        ArrayList<Artifact> resolvedArtifacts = new ArrayList<Artifact>();
        ArrayList<Artifact> missingArtifacts = new ArrayList<Artifact>();
        for (ResolutionNode node : result.getArtifactResolutionNodes()) {
            try {
                this.resolve(node.getArtifact(), node.getRemoteRepositories(), localRepository);
                resolvedArtifacts.add(node.getArtifact());
            }
            catch (ArtifactNotFoundException anfe) {
                this.getLogger().debug(anfe.getMessage(), anfe);
                missingArtifacts.add(node.getArtifact());
            }
        }
        if (missingArtifacts.size() > 0) {
            throw new MultipleArtifactsNotFoundException(originatingArtifact, resolvedArtifacts, missingArtifacts, this.getMirroredRepositories(remoteRepositories));
        }
        return result;
    }

    private List<ArtifactRepository> getMirroredRepositories(List<ArtifactRepository> remoteRepositories) {
        HashMap<String, ArtifactRepository> repos = new HashMap<String, ArtifactRepository>();
        for (ArtifactRepository repository : remoteRepositories) {
            ArtifactRepository repo = this.wagonManager.getMirrorRepository(repository);
            repos.put(repo.getId(), repo);
        }
        return new ArrayList<ArtifactRepository>(repos.values());
    }

    @Override
    public ArtifactResolutionResult resolve(ArtifactResolutionRequest request) {
        Artifact originatingArtifact = request.getArtifact();
        Set<Artifact> artifacts = request.getArtifactDependencies();
        Map managedVersions = request.getManagedVersionMap();
        ArtifactRepository localRepository = request.getLocalRepository();
        List<ArtifactRepository> remoteRepositories = request.getRemoteRepostories();
        ArtifactMetadataSource source = request.getMetadataSource();
        List<ResolutionListener> listeners = request.getListeners();
        ArtifactFilter filter = request.getFilter();
        ArtifactResolutionResult result = this.artifactCollector.collect(artifacts, originatingArtifact, managedVersions, localRepository, remoteRepositories, source, filter, listeners);
        result.setRepositories(remoteRepositories);
        if (result.hasMetadataResolutionExceptions() || result.hasVersionRangeViolations()) {
            return result;
        }
        for (ResolutionNode node : result.getArtifactResolutionNodes()) {
            try {
                this.resolve(node.getArtifact(), node.getRemoteRepositories(), localRepository);
            }
            catch (ArtifactNotFoundException anfe) {
                result.addMissingArtifact(node.getArtifact());
            }
            catch (ArtifactResolutionException e) {
                result.addErrorArtifactException(e);
            }
        }
        return result;
    }
}

