/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.indexing;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.css.gsf.api.CssParserResult;
import org.netbeans.modules.css.indexing.CssFileModel;
import org.netbeans.modules.css.refactoring.api.Entry;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.indexing.Context;
import org.netbeans.modules.parsing.spi.indexing.EmbeddingIndexer;
import org.netbeans.modules.parsing.spi.indexing.EmbeddingIndexerFactory;
import org.netbeans.modules.parsing.spi.indexing.Indexable;
import org.netbeans.modules.parsing.spi.indexing.support.IndexDocument;
import org.netbeans.modules.parsing.spi.indexing.support.IndexingSupport;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class CssIndexer
extends EmbeddingIndexer {
    private static final Logger LOGGER = Logger.getLogger(CssIndexer.class.getSimpleName());
    private static final boolean LOG = LOGGER.isLoggable(Level.FINE);
    public static final String CSS_CONTENT_KEY = "cssContent";
    public static final String IMPORTS_KEY = "imports";
    public static final String IDS_KEY = "ids";
    public static final String CLASSES_KEY = "classes";
    public static final String HTML_ELEMENTS_KEY = "htmlElements";
    public static final String COLORS_KEY = "colors";

    protected void index(Indexable indexable, Parser.Result parserResult, Context context) {
        try {
            if (LOG) {
                FileObject fo = parserResult.getSnapshot().getSource().getFileObject();
                LOGGER.log(Level.FINE, "indexing " + fo.getPath());
            }
            CssFileModel model = CssFileModel.create((CssParserResult)parserResult);
            IndexingSupport support = IndexingSupport.getInstance((Context)context);
            IndexDocument document = support.createDocument(indexable);
            this.storeEntries(model.getIds(), document, IDS_KEY);
            this.storeEntries(model.getClasses(), document, CLASSES_KEY);
            this.storeEntries(model.getHtmlElements(), document, HTML_ELEMENTS_KEY);
            this.storeEntries(model.getImports(), document, IMPORTS_KEY);
            this.storeEntries(model.getColors(), document, COLORS_KEY);
            document.addPair(CSS_CONTENT_KEY, Boolean.TRUE.toString(), true, true);
            support.addDocument(document);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void storeEntries(Collection<Entry> entries, IndexDocument doc, String key) {
        if (!entries.isEmpty()) {
            StringBuffer sb = new StringBuffer();
            Iterator<Entry> i = entries.iterator();
            while (i.hasNext()) {
                sb.append(i.next().getName());
                if (!i.hasNext()) continue;
                sb.append(',');
            }
            sb.append(';');
            doc.addPair(key, sb.toString(), true, true);
        }
    }

    public static class Factory
    extends EmbeddingIndexerFactory {
        static final String NAME = "css";
        static final int VERSION = 1;

        public EmbeddingIndexer createIndexer(Indexable indexable, Snapshot snapshot) {
            if (this.isIndexable(snapshot)) {
                return new CssIndexer();
            }
            return null;
        }

        public void filesDeleted(Iterable<? extends Indexable> deleted, Context context) {
            try {
                IndexingSupport is = IndexingSupport.getInstance((Context)context);
                for (Indexable indexable : deleted) {
                    is.removeDocuments(indexable);
                }
            }
            catch (IOException ioe) {
                LOGGER.log(Level.WARNING, null, ioe);
            }
        }

        public void filesDirty(Iterable<? extends Indexable> dirty, Context context) {
            try {
                IndexingSupport is = IndexingSupport.getInstance((Context)context);
                for (Indexable indexable : dirty) {
                    is.markDirtyDocuments(indexable);
                }
            }
            catch (IOException ioe) {
                LOGGER.log(Level.WARNING, null, ioe);
            }
        }

        public String getIndexerName() {
            return NAME;
        }

        public int getIndexVersion() {
            return 1;
        }

        private boolean isIndexable(Snapshot snapshot) {
            return "text/x-css".equals(snapshot.getMimeType());
        }
    }
}

