/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makefile.wizard;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileFilter;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.StringTokenizer;
import java.util.regex.PatternSyntaxException;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.cnd.makefile.utils.IpeFileSystemView;
import org.netbeans.modules.cnd.makefile.utils.UnixRE;
import org.netbeans.modules.cnd.makefile.wizard.MakefileWizard;
import org.netbeans.modules.cnd.makefile.wizard.MakefileWizardPanel;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.cnd.utils.ui.CndUIUtilities;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EnterItemsPanel
extends MakefileWizardPanel {
    static final long serialVersionUID = 5260017369797781413L;
    private JLabel entryLabel;
    private JTextField entryText;
    private JButton entryChooser;
    private JButton addBtn;
    private JButton changeBtn;
    private JButton removeBtn;
    private JButton upArrow;
    private JButton downArrow;
    private JList list;
    protected JFileChooser fc;
    private boolean expandDirs;
    private boolean dirChooser;
    private boolean dirAndFileChooser;
    private boolean mspFilter;
    private boolean dynamicNext;
    private boolean dynamicLast;
    private boolean itemsRequired;
    private boolean addBeginning;
    private HashSet<UnixRE> filters;
    private File lastChooserDir = null;
    protected static final int EXPAND_DIRS = 1;
    protected static final int DIR_CHOOSER = 2;
    protected static final int MSP_FILTER = 4;
    protected static final int DYNAMIC_DEFAULT_BUTTONS = 8;
    protected static final int DYNAMIC_LAST_BUTTON = 16;
    protected static final int ITEMS_REQUIRED = 32;
    protected static final int ADD_BEGINNING = 64;
    protected static final int DIR_AND_FILE_CHOOSER = 128;
    private JButton nextButton = null;
    private static boolean lastEnabled;

    public EnterItemsPanel(MakefileWizard wd) {
        super(wd);
        lastEnabled = false;
    }

    protected void create(String label, char mnemonic, int flags) {
        boolean gridy = false;
        this.expandDirs = (flags & 1) == 1;
        this.dirChooser = (flags & 2) == 2;
        this.dirAndFileChooser = (flags & 0x80) == 128;
        this.mspFilter = (flags & 4) == 4;
        this.dynamicNext = (flags & 8) == 8;
        this.dynamicLast = (flags & 0x10) == 16;
        this.itemsRequired = (flags & 0x20) == 32;
        this.addBeginning = (flags & 0x40) == 64;
        JPanel mainPanel = new JPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        if (this.dynamicNext) {
            this.nextButton = MakefileWizard.getMakefileWizard().getNextButton();
        }
        this.setLayout(new GridBagLayout());
        mainPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        mainPanel.add((Component)this.createTextPanel(label, mnemonic), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        gridBagConstraints.anchor = 18;
        mainPanel.add((Component)this.createButtonRow1(), gridBagConstraints);
        JLabel listLabel = new JLabel(this.getListLabel());
        listLabel.setDisplayedMnemonic(this.getListMnemonic());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(11, 0, 0, 0);
        gridBagConstraints.anchor = 18;
        mainPanel.add((Component)listLabel, gridBagConstraints);
        this.list = new JList(new DefaultListModel());
        listLabel.setLabelFor(this.list);
        JScrollPane sp = new JScrollPane(this.list);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        mainPanel.add((Component)sp, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        gridBagConstraints.anchor = 18;
        mainPanel.add((Component)this.createButtonRow2(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)mainPanel, gridBagConstraints);
        this.setupListeners();
    }

    void addComponent(JComponent component, GridBagConstraints gridx) {
        this.add((Component)component, gridx);
    }

    protected String getListLabel() {
        return this.getString("LBL_ListLabel");
    }

    protected char getListMnemonic() {
        return this.getString("MNEM_ListLabel").charAt(0);
    }

    private JPanel createTextPanel(String wholeLabel, char mnemonic) {
        int gridy = 0;
        GridBagConstraints grid = new GridBagConstraints();
        JPanel panel = new JPanel(new GridBagLayout());
        StringTokenizer tok = new StringTokenizer(wholeLabel, "\n");
        String label = tok.nextToken();
        this.entryLabel = new JLabel(label);
        this.entryLabel.setDisplayedMnemonic(mnemonic);
        grid.anchor = 17;
        grid.gridx = 0;
        grid.gridy = gridy++;
        grid.gridwidth = 0;
        panel.add((Component)this.entryLabel, grid);
        while (tok.hasMoreTokens()) {
            label = tok.nextToken();
            grid.gridy = gridy++;
            panel.add((Component)new JLabel(label), grid);
        }
        this.entryText = new JTextField();
        this.entryLabel.setLabelFor(this.entryText);
        grid.fill = 2;
        grid.gridy = gridy++;
        grid.gridwidth = -1;
        grid.weightx = 1.0;
        panel.add((Component)this.entryText, grid);
        this.entryChooser = new JButton(this.getString("BTN_Chooser"));
        this.entryChooser.setMnemonic(this.getString("MNEM_Chooser").charAt(0));
        grid.fill = 0;
        grid.gridx = -1;
        grid.gridwidth = 0;
        grid.insets = new Insets(0, 5, 0, 0);
        grid.weightx = 0.0;
        panel.add((Component)this.entryChooser, grid);
        this.createChooser(this.entryChooser);
        return panel;
    }

    private JPanel createButtonRow1() {
        JPanel row = new JPanel(new GridLayout(1, 2, 6, 0));
        this.addBtn = new JButton(this.getString("BTN_Add"));
        this.addBtn.setMnemonic(this.getString("MNEM_Add").charAt(0));
        this.addBtn.setEnabled(false);
        row.add(this.addBtn);
        this.changeBtn = new JButton(this.getString("BTN_Change"));
        this.changeBtn.setMnemonic(this.getString("MNEM_Change").charAt(0));
        this.changeBtn.setEnabled(false);
        row.add(this.changeBtn);
        return row;
    }

    private JPanel createButtonRow2() {
        JPanel row = new JPanel(new GridLayout(1, 3, 6, 0));
        this.removeBtn = new JButton(this.getString("BTN_Remove"));
        this.removeBtn.setMnemonic(this.getString("MNEM_Remove").charAt(0));
        this.removeBtn.setEnabled(false);
        row.add(this.removeBtn);
        this.upArrow = new JButton(this.getString("BTN_Up"));
        this.upArrow.setMnemonic(this.getString("MNEM_Up").charAt(0));
        this.upArrow.setEnabled(false);
        row.add(this.upArrow);
        this.downArrow = new JButton(this.getString("BTN_Down"));
        this.downArrow.setMnemonic(this.getString("MNEM_Down").charAt(0));
        this.downArrow.setEnabled(false);
        row.add(this.downArrow);
        return row;
    }

    public JList getList() {
        return this.list;
    }

    public String[] getListItems() {
        Object[] o = ((DefaultListModel)this.list.getModel()).toArray();
        String[] s = new String[o.length];
        for (int i = 0; i < o.length; ++i) {
            s[i] = o[i].toString().trim();
        }
        return s;
    }

    private Object[] expandFileList(String text) {
        StringTokenizer st = new StringTokenizer(text);
        LinkedList<ListItem> aList = new LinkedList<ListItem>();
        TokType type = new TokType();
        boolean neFileAdded = false;
        int tcount = 0;
        while (st.hasMoreTokens()) {
            String tok = this.validateInput(st.nextToken());
            if (tok == null) continue;
            if (tok.startsWith("$(")) {
                int plevel = 1;
                int pos = 2;
                while (plevel > 0) {
                    for (int i = pos; i < tok.length(); ++i) {
                        if (tok.charAt(i) == '(') {
                            ++plevel;
                        }
                        if (tok.charAt(i) == ')') {
                            --plevel;
                        }
                        if (plevel <= 0) break;
                    }
                    if (plevel <= 0) continue;
                    if (!st.hasMoreTokens()) break;
                    pos = tok.length() + 1;
                    tok = tok + " " + st.nextToken();
                }
            }
            LinkedList<ListItem> tmp = this.expandToken(tok, type);
            ++tcount;
            if (tmp.size() == 0) {
                if (type.isRE()) continue;
                aList.add(new ListItem(tok, false));
                neFileAdded = true;
                continue;
            }
            ListIterator iter = tmp.listIterator();
            while (iter.hasNext()) {
                ListItem item = (ListItem)iter.next();
                File file = new File(item.getName());
                if (this.expandDirs && file.isDirectory()) {
                    LinkedList<ListItem> l = this.processDirectory(tok, file);
                    if (l != null) {
                        aList.addAll(l);
                        continue;
                    }
                    --tcount;
                    continue;
                }
                aList.add(new ListItem(file.getAbsolutePath(), file.exists()));
            }
        }
        if (this.checkErrorConditions(tcount, aList, neFileAdded)) {
            ErrorInfo einfo = this.getErrorInfo();
            NotifyDescriptor nd = new NotifyDescriptor((Object)einfo.getMsg(), einfo.getTitle(), -1, 2, new Object[]{NotifyDescriptor.OK_OPTION}, NotifyDescriptor.OK_OPTION);
            DialogDisplayer.getDefault().notify(nd);
        }
        return aList.toArray(new ListItem[aList.size()]);
    }

    protected boolean checkErrorConditions(int tcount, LinkedList<ListItem> list, boolean nefiles) {
        return tcount == 1 && (list.size() == 0 || nefiles);
    }

    protected abstract ErrorInfo getErrorInfo();

    private LinkedList<ListItem> expandToken(String token, TokType type) {
        LinkedList<ListItem> files = new LinkedList<ListItem>();
        REParser rep = new REParser(token);
        String comp = rep.getFirstComponent();
        String re = rep.getRegularExpression();
        String rem = rep.getRemainder();
        if (re == null) {
            File f = new File(comp);
            type.setRE(false);
            if (f.exists()) {
                files.add(new ListItem(f.getAbsolutePath(), f.exists()));
            }
        } else {
            type.setRE(true);
            LinkedList<ListItem> alist = this.processDir(comp, re);
            TokType dontcare = new TokType();
            if (alist != null) {
                if (rem == null) {
                    files.addAll(alist);
                } else {
                    ListIterator iter = alist.listIterator();
                    while (iter.hasNext()) {
                        ListItem item = (ListItem)iter.next();
                        StringBuilder buf = new StringBuilder(256);
                        buf.append(item.getName());
                        buf.append(File.separator);
                        buf.append(rem);
                        files.addAll(this.expandToken(buf.toString(), dontcare));
                    }
                }
            }
        }
        return files;
    }

    private LinkedList<ListItem> processDir(String dir, String pattern) {
        UnixRE re;
        LinkedList<ListItem> aList = new LinkedList<ListItem>();
        File[] files = this.getFileArray(new File(dir));
        if (files == null) {
            return null;
        }
        try {
            re = new UnixRE(pattern);
        }
        catch (PatternSyntaxException e) {
            if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                e.printStackTrace();
            }
            return null;
        }
        for (int i = 0; i < files.length; ++i) {
            String name = files[i].toString();
            if (!re.match(name)) continue;
            File file = new File(name);
            aList.add(new ListItem(file.getAbsolutePath(), file.exists()));
        }
        return aList;
    }

    private File[] getFileArray(File dir) {
        File[] files = dir.listFiles();
        if (files == null) {
            return null;
        }
        File[] augmented = new File[files.length + 2];
        augmented[0] = new File(".");
        augmented[1] = new File("..");
        for (int i = 0; i < files.length; ++i) {
            augmented[i + 2] = files[i];
        }
        return augmented;
    }

    private LinkedList<ListItem> processDirectory(String name, File file) {
        String msg = MessageFormat.format(this.getString("MSG_CREATE_SOURCE_DIRECTORY"), name);
        JButton subdirs = new JButton(this.getString("BTN_Subdirs"));
        subdirs.setMnemonic(this.getString("MNEM_Subdirs").charAt(0));
        JButton dirs = new JButton(this.getString("BTN_Dirs"));
        dirs.setMnemonic(this.getString("MNEM_Dirs").charAt(0));
        JButton cancel = new JButton(this.getString("BTN_Cancel"));
        String TITLE = this.getString("LBL_QUESTION_WINDOW");
        NotifyDescriptor nd = new NotifyDescriptor((Object)msg, TITLE, -1, 3, (Object[])new JButton[]{subdirs, dirs, cancel}, (Object)subdirs);
        Object ret = DialogDisplayer.getDefault().notify(nd);
        if (ret instanceof JButton) {
            if (ret.equals(subdirs)) {
                return this.addDirectoryFiles(name, file, true);
            }
            if (ret.equals(dirs)) {
                return this.addDirectoryFiles(name, file, false);
            }
        }
        return null;
    }

    private LinkedList<ListItem> addDirectoryFiles(String parent, File dir, boolean recurse) {
        LinkedList<ListItem> aList = new LinkedList<ListItem>();
        File[] files = dir.listFiles(new SrcsFileFilter());
        for (int i = 0; i < files.length; ++i) {
            aList.add(new ListItem(parent + File.separator + files[i].getName(), true));
        }
        if (recurse) {
            File[] dirs = dir.listFiles(new DirFilter());
            for (int i = 0; i < dirs.length; ++i) {
                aList.addAll(this.addDirectoryFiles(parent + File.separator + dirs[i].getName(), dirs[i], true));
            }
        }
        return aList;
    }

    protected void addMultipleFiles(Object[] objects) {
        if (objects != null) {
            DefaultListModel model = (DefaultListModel)this.list.getModel();
            String cwd = this.getMakefileData().getBaseDirectory(true);
            for (int i = 0; i < objects.length; ++i) {
                String path = CndPathUtilitities.getRelativePath((String)cwd, (String)((ListItem)objects[i]).getName());
                if (model.contains(path)) continue;
                if (this.addBeginning) {
                    model.add(0, path);
                    continue;
                }
                model.addElement(path);
            }
        }
    }

    protected void addMultipleFiles(File[] files) {
        if (files != null) {
            DefaultListModel model = (DefaultListModel)this.list.getModel();
            String cwd = this.getMakefileData().getBaseDirectory(true);
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    LinkedList<ListItem> aList = this.processDirectory(files[i].getPath(), files[i]);
                    if (aList == null) continue;
                    for (ListItem item : aList) {
                        String path = CndPathUtilitities.getRelativePath((String)cwd, (String)item.getName());
                        if (model.contains(path)) continue;
                        if (this.addBeginning) {
                            model.add(0, path);
                            continue;
                        }
                        model.addElement(path);
                    }
                    continue;
                }
                String path = CndPathUtilitities.getRelativePath((String)cwd, (String)files[i].getPath());
                if (model.contains(path)) continue;
                if (this.addBeginning) {
                    model.add(0, path);
                    continue;
                }
                model.addElement(path);
            }
        }
    }

    protected String validateInput(String token) {
        return token;
    }

    protected void createChooser(JButton chooser) {
        chooser.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (EnterItemsPanel.this.fc == null) {
                    EnterItemsPanel.this.fc = new JFileChooser();
                    EnterItemsPanel.this.fc.setApproveButtonText(EnterItemsPanel.this.getString("BTN_Approve"));
                    EnterItemsPanel.this.fc.setMultiSelectionEnabled(true);
                    EnterItemsPanel.this.fc.setFileSystemView(new IpeFileSystemView(EnterItemsPanel.this.fc.getFileSystemView()));
                    if (EnterItemsPanel.this.dirChooser) {
                        EnterItemsPanel.this.fc.setFileSelectionMode(1);
                        EnterItemsPanel.this.fc.setDialogTitle(EnterItemsPanel.this.getString("TITLE_DirChooser"));
                    } else if (EnterItemsPanel.this.dirAndFileChooser) {
                        EnterItemsPanel.this.fc.setFileSelectionMode(2);
                        EnterItemsPanel.this.fc.setDialogTitle(EnterItemsPanel.this.getString("DLG_FILE_CHOOSER_TITLE"));
                    } else {
                        EnterItemsPanel.this.fc.setDialogTitle(EnterItemsPanel.this.getString("DLG_FILE_CHOOSER_TITLE"));
                    }
                    if (EnterItemsPanel.this.mspFilter) {
                        EnterItemsPanel.this.fc.setFileFilter(new MspFileFilter());
                    }
                }
                File f = null;
                String cur = CndPathUtilitities.expandPath((String)EnterItemsPanel.this.getText());
                if (cur.length() > 0) {
                    f = new File(cur);
                }
                if (f != null && f.isDirectory()) {
                    EnterItemsPanel.this.fc.setCurrentDirectory(f);
                } else if (EnterItemsPanel.this.lastChooserDir != null) {
                    EnterItemsPanel.this.fc.setCurrentDirectory(EnterItemsPanel.this.lastChooserDir);
                } else {
                    EnterItemsPanel.this.fc.setCurrentDirectory(new File(EnterItemsPanel.this.getMakefileData().getBaseDirectory(true)));
                }
                int returnVal = EnterItemsPanel.this.fc.showDialog(EnterItemsPanel.this, null);
                if (returnVal == 0) {
                    EnterItemsPanel.this.addMultipleFiles(EnterItemsPanel.this.fc.getSelectedFiles());
                    EnterItemsPanel.this.lastChooserDir = EnterItemsPanel.this.fc.getCurrentDirectory();
                    EnterItemsPanel.this.entryText.setText(null);
                    EnterItemsPanel.this.addBtn.setEnabled(false);
                }
            }
        });
    }

    public JTextField getEntryText() {
        return this.entryText;
    }

    private String getText() {
        return CndPathUtilitities.expandPath((String)this.entryText.getText());
    }

    @Override
    public boolean isPanelValid() {
        return !this.itemsRequired || this.list.getModel().getSize() != 0;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.removeBtn.setEnabled(false);
        this.upArrow.setEnabled(false);
        this.downArrow.setEnabled(false);
        this.changeBtn.setEnabled(this.list != null && this.list.getSelectedIndex() >= 0);
        if (this.itemsRequired && this.list.getModel().getSize() == 0) {
            this.nextButton.setEnabled(false);
        }
        if (this.dynamicNext && this.entryText.getDocument().getLength() > 0) {
            this.addBtn.setEnabled(true);
            CndUIUtilities.setDefaultButton((JRootPane)this.getRootPane(), (JButton)this.addBtn);
        }
        this.entryText.selectAll();
        CndUIUtilities.requestFocus((Component)this.entryText);
    }

    @Override
    public void removeNotify() {
        Container o;
        super.removeNotify();
        if (this.dynamicNext || this.itemsRequired) {
            this.nextButton.setEnabled(true);
            this.getRootPane().setDefaultButton(this.nextButton);
        }
        if (this.fc != null && this.fc.isShowing() && (o = this.fc.getTopLevelAncestor()) != null && o instanceof JDialog) {
            ((JDialog)o).dispose();
        }
    }

    private void setupListeners() {
        final DefaultListModel model = (DefaultListModel)this.list.getModel();
        this.entryText.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                if (e.getDocument().getLength() >= 1) {
                    EnterItemsPanel.this.addBtn.setEnabled(true);
                    if (EnterItemsPanel.this.dynamicNext) {
                        EnterItemsPanel.this.getRootPane().setDefaultButton(EnterItemsPanel.this.addBtn);
                    }
                }
            }

            public void insertUpdate(DocumentEvent e) {
                if (e.getDocument().getLength() >= 1) {
                    EnterItemsPanel.this.addBtn.setEnabled(true);
                    if (EnterItemsPanel.this.dynamicNext && EnterItemsPanel.this.list.getModel().getSize() == 0) {
                        EnterItemsPanel.this.getRootPane().setDefaultButton(EnterItemsPanel.this.addBtn);
                    }
                    int min = EnterItemsPanel.this.list.getMinSelectionIndex();
                    int max = EnterItemsPanel.this.list.getMaxSelectionIndex();
                    if (min >= 0 && max >= 0 && min == max) {
                        EnterItemsPanel.this.changeBtn.setEnabled(true);
                    }
                }
            }

            public void removeUpdate(DocumentEvent e) {
                if (e.getDocument().getLength() == 0) {
                    EnterItemsPanel.this.addBtn.setEnabled(false);
                    EnterItemsPanel.this.changeBtn.setEnabled(false);
                    if (EnterItemsPanel.this.dynamicNext) {
                        EnterItemsPanel.this.getRootPane().setDefaultButton(EnterItemsPanel.this.nextButton);
                    }
                }
            }
        });
        this.addBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EnterItemsPanel.this.addMultipleFiles(EnterItemsPanel.this.expandFileList(EnterItemsPanel.this.getText()));
                EnterItemsPanel.this.list.clearSelection();
                EnterItemsPanel.this.entryText.setText(null);
                EnterItemsPanel.this.addBtn.setEnabled(false);
                EnterItemsPanel.this.changeBtn.setEnabled(false);
                if (EnterItemsPanel.this.dynamicNext && !EnterItemsPanel.this.itemsRequired || EnterItemsPanel.this.itemsRequired && model.getSize() > 0) {
                    EnterItemsPanel.this.nextButton.setEnabled(true);
                    EnterItemsPanel.this.getRootPane().setDefaultButton(EnterItemsPanel.this.nextButton);
                }
            }
        });
        this.changeBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String path = EnterItemsPanel.this.getText();
                if (!model.contains(path)) {
                    model.set(EnterItemsPanel.this.list.getMinSelectionIndex(), path);
                }
            }
        });
        this.removeBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int selectedIndex;
                int min = EnterItemsPanel.this.list.getMinSelectionIndex();
                int[] removeList = EnterItemsPanel.this.list.getSelectedIndices();
                for (int i = removeList.length; i > 0; --i) {
                    model.remove(removeList[i - 1]);
                }
                int n = selectedIndex = min >= EnterItemsPanel.this.list.getModel().getSize() ? min - 1 : min;
                if (selectedIndex >= 0) {
                    EnterItemsPanel.this.list.ensureIndexIsVisible(selectedIndex);
                    EnterItemsPanel.this.list.setSelectedIndex(selectedIndex);
                    EnterItemsPanel.this.removeBtn.setEnabled(true);
                    EnterItemsPanel.this.changeBtn.setEnabled(true);
                    EnterItemsPanel.this.upArrow.setEnabled(selectedIndex > 0);
                    EnterItemsPanel.this.downArrow.setEnabled(selectedIndex < EnterItemsPanel.this.list.getModel().getSize() - 1);
                } else {
                    EnterItemsPanel.this.removeBtn.setEnabled(false);
                    EnterItemsPanel.this.changeBtn.setEnabled(false);
                    EnterItemsPanel.this.upArrow.setEnabled(false);
                    EnterItemsPanel.this.downArrow.setEnabled(false);
                }
            }
        });
        this.list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    int min = EnterItemsPanel.this.list.getMinSelectionIndex();
                    int max = EnterItemsPanel.this.list.getMaxSelectionIndex();
                    if (min >= 0 && max >= 0) {
                        if (min == max) {
                            EnterItemsPanel.this.entryText.setText(model.get(min).toString());
                            EnterItemsPanel.this.addBtn.setEnabled(true);
                            EnterItemsPanel.this.changeBtn.setEnabled(true);
                            EnterItemsPanel.this.upArrow.setEnabled(min != 0);
                            EnterItemsPanel.this.downArrow.setEnabled(min != model.getSize() - 1);
                        } else {
                            EnterItemsPanel.this.entryText.setText(null);
                            EnterItemsPanel.this.changeBtn.setEnabled(false);
                            EnterItemsPanel.this.upArrow.setEnabled(false);
                            EnterItemsPanel.this.downArrow.setEnabled(false);
                        }
                    }
                    EnterItemsPanel.this.removeBtn.setEnabled(true);
                }
            }
        });
        model.addListDataListener(new ListDataListener(){

            public void contentsChanged(ListDataEvent e) {
                if (model.getSize() > 0) {
                    if (EnterItemsPanel.this.dynamicLast && !lastEnabled && EnterItemsPanel.this.getMakefileData().isComplete(true)) {
                        lastEnabled = true;
                    }
                } else if (EnterItemsPanel.this.dynamicLast && lastEnabled) {
                    lastEnabled = false;
                }
            }

            public void intervalRemoved(ListDataEvent e) {
                if (model.getSize() == 0) {
                    if (EnterItemsPanel.this.dynamicNext && EnterItemsPanel.this.itemsRequired && EnterItemsPanel.this.list.getModel().getSize() == 0) {
                        EnterItemsPanel.this.getRootPane().setDefaultButton(EnterItemsPanel.this.addBtn);
                        EnterItemsPanel.this.nextButton.setEnabled(false);
                    }
                    if (EnterItemsPanel.this.dynamicLast && lastEnabled) {
                        lastEnabled = false;
                    }
                }
            }

            public void intervalAdded(ListDataEvent e) {
                if (EnterItemsPanel.this.dynamicNext && EnterItemsPanel.this.itemsRequired) {
                    EnterItemsPanel.this.nextButton.setEnabled(true);
                    EnterItemsPanel.this.getRootPane().setDefaultButton(EnterItemsPanel.this.nextButton);
                }
                if (EnterItemsPanel.this.dynamicLast && !lastEnabled && EnterItemsPanel.this.getMakefileData().isComplete(true)) {
                    lastEnabled = true;
                }
            }
        });
        this.upArrow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int idx = EnterItemsPanel.this.list.getSelectedIndex();
                Object o = model.remove(idx);
                model.add(idx - 1, o);
                EnterItemsPanel.this.list.setSelectedIndex(idx - 1);
                if (idx == 1) {
                    EnterItemsPanel.this.upArrow.setEnabled(false);
                }
            }
        });
        this.downArrow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int idx = EnterItemsPanel.this.list.getSelectedIndex();
                Object o = model.remove(idx);
                model.add(idx + 1, o);
                EnterItemsPanel.this.list.setSelectedIndex(idx + 1);
                if (idx == model.getSize() - 1) {
                    EnterItemsPanel.this.downArrow.setEnabled(false);
                }
            }
        });
    }

    protected static final class ErrorInfo {
        private String title;
        private String msg;

        protected ErrorInfo() {
            this(null, null);
        }

        protected ErrorInfo(String title, String msg) {
            this.title = title;
            this.msg = msg;
        }

        String getTitle() {
            return this.title;
        }

        void setTitle(String title) {
            this.title = title;
        }

        String getMsg() {
            return this.msg;
        }

        void setMsg(String msg) {
            this.msg = msg;
        }
    }

    private static final class TokType {
        private boolean re;

        private TokType() {
        }

        void setRE(boolean re) {
            this.re = re;
        }

        boolean isRE() {
            return this.re;
        }
    }

    protected static class ListItem {
        private String name;
        private boolean exists;

        public ListItem(String name, boolean exists) {
            this.name = name;
            this.exists = exists;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean isExists() {
            return this.exists;
        }
    }

    private static class DirFilter
    implements FileFilter {
        private DirFilter() {
        }

        public boolean accept(File file) {
            return file.isDirectory();
        }
    }

    private class SrcsFileFilter
    implements FileFilter {
        private String filterString;

        public SrcsFileFilter() {
            this.filterString = EnterItemsPanel.this.getString("DFLT_SourceFilter");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return false;
            }
            if (EnterItemsPanel.this.filters == null) {
                StringTokenizer st = new StringTokenizer(this.filterString);
                EnterItemsPanel.this.filters = new HashSet(15);
                HashSet hashSet = EnterItemsPanel.this.filters;
                synchronized (hashSet) {
                    try {
                        while (st.hasMoreTokens()) {
                            EnterItemsPanel.this.filters.add(new UnixRE(st.nextToken()));
                        }
                    }
                    catch (PatternSyntaxException ex) {
                        ex.printStackTrace();
                        return false;
                    }
                }
            }
            HashSet hashSet = EnterItemsPanel.this.filters;
            synchronized (hashSet) {
                for (UnixRE re : EnterItemsPanel.this.filters) {
                    if (!re.match(file.getName())) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private class MspFileFilter
    extends javax.swing.filechooser.FileFilter {
        private String filterString;

        public MspFileFilter() {
            this.filterString = EnterItemsPanel.this.getString("DFLT_SourceFilter");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            if (EnterItemsPanel.this.filters == null) {
                StringTokenizer st = new StringTokenizer(this.filterString);
                EnterItemsPanel.this.filters = new HashSet(15);
                HashSet hashSet = EnterItemsPanel.this.filters;
                synchronized (hashSet) {
                    try {
                        while (st.hasMoreTokens()) {
                            EnterItemsPanel.this.filters.add(new UnixRE(st.nextToken()));
                        }
                    }
                    catch (PatternSyntaxException ex) {
                        ex.printStackTrace();
                        return false;
                    }
                }
            }
            HashSet hashSet = EnterItemsPanel.this.filters;
            synchronized (hashSet) {
                for (UnixRE re : EnterItemsPanel.this.filters) {
                    if (!re.match(file.getName())) continue;
                    return true;
                }
            }
            return false;
        }

        public String getDescription() {
            return this.filterString;
        }
    }

    private class REParser {
        private String firstComponent;
        private String regularExpression;
        private String remainder;

        public REParser(String text) {
            int pos1 = 0;
            if (text.charAt(0) != File.separatorChar) {
                text = EnterItemsPanel.this.getMakefileData().getBaseDirectory(true) + '/' + text;
            }
            for (int i = 0; i < text.length(); ++i) {
                char c = text.charAt(i);
                if (c == '/') {
                    pos1 = i;
                }
                if (c != '*' && c != '?' && c != '[') continue;
                this.firstComponent = new String(text.substring(0, pos1));
                int pos2 = text.indexOf(47, i);
                if (pos2 == -1) {
                    this.regularExpression = new String(text.substring(pos1 + 1));
                    this.remainder = null;
                } else {
                    this.regularExpression = new String(text.substring(pos1 + 1, pos2));
                    this.remainder = new String(text.substring(pos2 + 1));
                }
                return;
            }
            this.firstComponent = new String(text);
            this.regularExpression = null;
            this.remainder = null;
        }

        public String getFirstComponent() {
            return this.firstComponent;
        }

        public String getRegularExpression() {
            return this.regularExpression;
        }

        public String getRemainder() {
            return this.remainder;
        }
    }
}

