/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.asm.core.assistance;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.netbeans.modules.cnd.asm.core.assistance.RegisterUsageAccesor;
import org.netbeans.modules.cnd.asm.model.AsmState;
import org.netbeans.modules.cnd.asm.model.lang.AsmElement;
import org.netbeans.modules.cnd.asm.model.lang.InstructionElement;
import org.netbeans.modules.cnd.asm.model.lang.Register;
import org.netbeans.modules.cnd.asm.model.lang.syntax.FunctionBoundsResolver;
import org.netbeans.modules.cnd.asm.model.util.AsmModelUtilities;

public class RegisterUsageAction {
    private final RegisterUsageAccesor accessor;

    public RegisterUsageAction(RegisterUsageAccesor accessor) {
        this.accessor = accessor;
    }

    public void computeUsage(AsmState state, int pos) {
        AsmElement comp = state.getElements();
        FunctionBoundsResolver resolver = (FunctionBoundsResolver)state.getServices().lookup(FunctionBoundsResolver.class);
        if (resolver == null) {
            return;
        }
        int count = 0;
        int inInstruction = -1;
        for (AsmElement el : comp.getCompounds()) {
            if (el.getStartOffset() <= pos && el.getEndOffset() > pos && el instanceof InstructionElement) {
                inInstruction = count;
            }
            if (el.getStartOffset() >= pos) {
                FunctionBoundsResolver.Entry function = resolver.getFunctions().getElementAtPosition(count);
                if (function == null) break;
                this.computeUsage(comp, count, function.getStartOffset(), function.getEndOffset(), inInstruction);
                return;
            }
            ++count;
        }
        this.accessor.clearStatuses();
    }

    private void computeUsage(AsmElement root, int pos, int start, int end, int inInstruction) {
        List<AsmElement> comp = root.getCompounds();
        HashSet<Register> wasWrite = new HashSet<Register>();
        HashSet<Register> wasRead = new HashSet<Register>();
        HashSet<Register> args = new HashSet<Register>();
        for (int cur = start; cur < pos; ++cur) {
            AsmElement c = comp.get(cur);
            if (!(c instanceof InstructionElement)) continue;
            InstructionElement instr = (InstructionElement)c;
            Collection<Register> readed = AsmModelUtilities.getRegistersClosure(instr.getReadRegs());
            Collection<Register> writed = AsmModelUtilities.getRegistersClosure(instr.getWriteRegs());
            wasRead.addAll(readed);
            wasWrite.addAll(writed);
            for (Register reg : writed) {
                if (!wasRead.contains(reg)) continue;
                wasRead.remove(reg);
            }
        }
        for (Register reg : wasRead) {
            if (wasWrite.contains(reg)) continue;
            args.add(reg);
        }
        wasRead.clear();
        HashSet<Register> writeAfter = new HashSet<Register>(wasWrite);
        for (int cur = pos; cur < end; ++cur) {
            AsmElement c = comp.get(cur);
            if (!(c instanceof InstructionElement)) continue;
            InstructionElement instr = (InstructionElement)c;
            Collection<Register> readed = AsmModelUtilities.getRegistersClosure(instr.getReadRegs());
            Collection<Register> writed = AsmModelUtilities.getRegistersClosure(instr.getWriteRegs());
            wasRead.addAll(readed);
            writeAfter.addAll(writed);
            for (Register reg : writed) {
                if (wasRead.contains(reg)) continue;
                wasWrite.remove(reg);
            }
            for (Register reg : readed) {
                if (writeAfter.contains(reg)) continue;
                args.add(reg);
            }
        }
        this.accessor.clearStatuses();
        this.accessor.setRegisterStatus(wasWrite, (RegisterUsageAccesor.RegisterStatus)RegisterUsageAccesor.PredefinedStatuses.STATUS_USED);
        this.accessor.setRegisterStatus(args, (RegisterUsageAccesor.RegisterStatus)RegisterUsageAccesor.PredefinedStatuses.STATUS_ARG);
        if (inInstruction >= 0) {
            InstructionElement instr = (InstructionElement)comp.get(inInstruction);
            Collection<Register> locReaded = AsmModelUtilities.getRegistersClosure(instr.getReadRegs());
            Collection<Register> locWrited = AsmModelUtilities.getRegistersClosure(instr.getWriteRegs());
            this.accessor.setRegisterStatus(locReaded, (RegisterUsageAccesor.RegisterStatus)RegisterUsageAccesor.PredefinedStatuses.STATUS_READ);
            this.accessor.setRegisterStatus(locWrited, (RegisterUsageAccesor.RegisterStatus)RegisterUsageAccesor.PredefinedStatuses.STATUS_WRITE);
        }
    }

    private static <T> void getIntersection(Collection<T> res, Collection<T> in, Collection<T> from) {
        for (T el : from) {
            if (!in.contains(el)) continue;
            res.add(el);
        }
    }
}

