/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.spi.commands;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExternalProcessBuilder;
import org.netbeans.api.extexecution.input.InputProcessor;
import org.netbeans.api.extexecution.input.InputProcessors;
import org.netbeans.modules.php.api.phpmodule.PhpInterpreter;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.phpmodule.PhpProgram;
import org.netbeans.modules.php.api.ui.commands.FrameworkCommandChooser;
import org.netbeans.modules.php.api.ui.commands.RefreshPhpModuleRunnable;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.api.util.UiUtils;
import org.netbeans.modules.php.spi.commands.FrameworkCommand;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public abstract class FrameworkCommandSupport {
    private static final Map<PhpModule, Map<String, List<FrameworkCommand>>> COMMANDS_CACHE = new WeakHashMap<PhpModule, Map<String, List<FrameworkCommand>>>();
    private static final RequestProcessor RP = new RequestProcessor(FrameworkCommandSupport.class);
    protected final PhpModule phpModule;
    private PluginListener pluginListener;

    protected FrameworkCommandSupport(PhpModule phpModule) {
        assert (phpModule != null);
        this.phpModule = phpModule;
    }

    public abstract String getFrameworkName();

    public abstract void runCommand(CommandDescriptor var1);

    protected abstract String getOptionsPath();

    protected abstract File getPluginsDirectory();

    protected ExternalProcessBuilder getProcessBuilder(boolean warnUser) {
        PhpInterpreter phpInterpreter;
        try {
            phpInterpreter = PhpInterpreter.getDefault();
        }
        catch (PhpProgram.InvalidPhpProgramException ex) {
            if (warnUser) {
                UiUtils.invalidScriptProvided(ex.getLocalizedMessage());
            }
            return null;
        }
        assert (phpInterpreter.isValid()) : "php interpreter must be valid";
        return phpInterpreter.getProcessBuilder();
    }

    protected abstract List<FrameworkCommand> getFrameworkCommandsInternal();

    public PhpModule getPhpModule() {
        return this.phpModule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FrameworkCommand> getFrameworkCommands() {
        List<FrameworkCommand> frameworkCommands = null;
        Map<PhpModule, Map<String, List<FrameworkCommand>>> map = COMMANDS_CACHE;
        synchronized (map) {
            Map<String, List<FrameworkCommand>> moduleCommands = COMMANDS_CACHE.get(this.phpModule);
            if (moduleCommands != null) {
                frameworkCommands = moduleCommands.get(this.getFrameworkName());
            }
        }
        return frameworkCommands;
    }

    public ExecutionDescriptor getDescriptor() {
        return this.getDescriptor(null);
    }

    public ExecutionDescriptor getDescriptor(ExecutionDescriptor.InputProcessorFactory outFactory) {
        ExecutionDescriptor descriptor = PhpProgram.getExecutionDescriptor().postExecution((Runnable)new RefreshPhpModuleRunnable(this.phpModule)).errProcessorFactory(PhpProgram.ANSI_STRIPPING_FACTORY);
        String optionsPath = this.getOptionsPath();
        if (optionsPath != null) {
            descriptor = descriptor.optionsPath(optionsPath);
        }
        descriptor = outFactory != null ? descriptor.outProcessorFactory((ExecutionDescriptor.InputProcessorFactory)new ProxyInputProcessorFactory(PhpProgram.ANSI_STRIPPING_FACTORY, outFactory)) : descriptor.outProcessorFactory(PhpProgram.ANSI_STRIPPING_FACTORY);
        return descriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void refreshFrameworkCommands() {
        Object object;
        List<FrameworkCommand> freshCommands = this.getFrameworkCommandsInternal();
        File plugins = this.getPluginsDirectory();
        if (plugins != null) {
            assert (!plugins.isFile()) : "Plugins is expected to be a directory: " + plugins;
            object = this;
            synchronized (object) {
                if (this.pluginListener == null) {
                    this.pluginListener = new PluginListener();
                    FileUtil.addFileChangeListener((FileChangeListener)this.pluginListener, (File)plugins);
                }
            }
        }
        object = COMMANDS_CACHE;
        synchronized (object) {
            Map<String, List<FrameworkCommand>> moduleCommands = COMMANDS_CACHE.get(this.phpModule);
            if (moduleCommands == null) {
                moduleCommands = new HashMap<String, List<FrameworkCommand>>();
            }
            moduleCommands.put(this.getFrameworkName(), freshCommands);
            COMMANDS_CACHE.put(this.phpModule, moduleCommands);
        }
    }

    public final void refreshFrameworkCommandsLater(final Runnable post) {
        RP.execute(new Runnable(){

            @Override
            public void run() {
                FrameworkCommandSupport.this.refreshFrameworkCommands();
                if (post != null) {
                    post.run();
                }
            }
        });
    }

    public ExternalProcessBuilder createCommand(String command, String ... arguments) {
        return this.createCommand(new String[]{command}, arguments);
    }

    public ExternalProcessBuilder createCommand(String[] commands, String ... arguments) {
        return this.createCommandInternal(commands, arguments, true);
    }

    public ExternalProcessBuilder createSilentCommand(String command, String ... arguments) {
        return this.createSilentCommand(new String[]{command}, arguments);
    }

    public ExternalProcessBuilder createSilentCommand(String[] commands, String ... arguments) {
        return this.createCommandInternal(commands, arguments, false);
    }

    public String getOutputTitle(CommandDescriptor commandDescriptor) {
        String command = StringUtils.implode(Arrays.asList(commandDescriptor.getFrameworkCommand().getCommands()), " ");
        return this.getOutputTitle(command, commandDescriptor.getCommandParams());
    }

    public String getOutputTitle(String command, String ... params) {
        StringBuilder title = new StringBuilder(200);
        title.append(this.phpModule.getDisplayName());
        title.append(" (");
        title.append(command);
        for (String param : params) {
            title.append(" ");
            title.append(param);
        }
        title.append(")");
        return title.toString();
    }

    public void runCommand() {
        FrameworkCommandChooser.open(this);
    }

    private ExternalProcessBuilder createCommandInternal(String[] commands, String[] arguments, boolean warnUser) {
        ExternalProcessBuilder processBuilder = this.getProcessBuilder(warnUser);
        if (processBuilder == null) {
            return null;
        }
        for (String command : commands) {
            processBuilder = processBuilder.addArgument(command);
        }
        for (String arg : arguments) {
            processBuilder = processBuilder.addArgument(arg);
        }
        return processBuilder;
    }

    public static interface RunCommand {
        public void runCommand(CommandDescriptor var1);
    }

    public static final class CommandDescriptor {
        private final FrameworkCommand task;
        private final String[] params;
        private final boolean debug;

        public CommandDescriptor(FrameworkCommand task, String params, boolean debug) {
            Parameters.notNull((CharSequence)"task", (Object)task);
            Parameters.notNull((CharSequence)"params", (Object)params);
            this.task = task;
            this.params = Utilities.parseParameters((String)params.trim());
            this.debug = debug;
        }

        public FrameworkCommand getFrameworkCommand() {
            return this.task;
        }

        public String[] getCommandParams() {
            return this.params;
        }

        public boolean isDebug() {
            return this.debug;
        }
    }

    private class PluginListener
    implements FileChangeListener {
        private PluginListener() {
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }

        public void fileChanged(FileEvent fe) {
            this.changed();
        }

        public void fileDataCreated(FileEvent fe) {
            this.changed();
        }

        public void fileDeleted(FileEvent fe) {
            this.changed();
        }

        public void fileFolderCreated(FileEvent fe) {
            this.changed();
        }

        public void fileRenamed(FileRenameEvent fe) {
            this.changed();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void changed() {
            Map map = COMMANDS_CACHE;
            synchronized (map) {
                COMMANDS_CACHE.remove(FrameworkCommandSupport.this.getPhpModule());
            }
        }
    }

    public static final class ProxyInputProcessorFactory
    implements ExecutionDescriptor.InputProcessorFactory {
        private final List<ExecutionDescriptor.InputProcessorFactory> factories;

        public ProxyInputProcessorFactory(ExecutionDescriptor.InputProcessorFactory ... proxied) {
            Parameters.notNull((CharSequence)"proxied", (Object)proxied);
            this.factories = new ArrayList<ExecutionDescriptor.InputProcessorFactory>(proxied.length);
            for (ExecutionDescriptor.InputProcessorFactory factory : proxied) {
                if (factory == null) continue;
                this.factories.add(factory);
            }
        }

        public InputProcessor newInputProcessor(InputProcessor defaultProcessor) {
            InputProcessor[] processors = new InputProcessor[this.factories.size()];
            for (int i = 0; i < processors.length; ++i) {
                processors[i] = this.factories.get(i).newInputProcessor(defaultProcessor);
            }
            return InputProcessors.proxy((InputProcessor[])processors);
        }
    }
}

