/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.ui.issue;

import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.bugtracking.spi.Issue;
import org.netbeans.modules.bugtracking.spi.Repository;
import org.netbeans.modules.bugtracking.ui.issue.IssueTopComponent;
import org.netbeans.modules.bugtracking.ui.issue.cache.IssueCacheUtils;
import org.netbeans.modules.bugtracking.util.BugtrackingOwnerSupport;
import org.netbeans.modules.bugtracking.util.UIUtils;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;
import org.openide.windows.WindowManager;

public class IssueAction
extends SystemAction {
    private static final RequestProcessor rp = new RequestProcessor("Bugtracking IssueAction");

    public IssueAction() {
        this.setIcon(null);
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public String getName() {
        return NbBundle.getMessage(IssueAction.class, (String)"CTL_IssueAction");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(IssueAction.class);
    }

    public void actionPerformed(ActionEvent ev) {
        IssueAction.createIssue();
    }

    public static void openIssue(final Issue issue, final boolean refresh) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                UIUtils.setWaitCursor(true);
                IssueTopComponent tc = IssueTopComponent.find(issue);
                tc.open();
                tc.requestActive();
                rp.post(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        ProgressHandle handle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(IssueAction.class, (String)"LBL_REFRESING_ISSUE", (Object[])new Object[]{issue.getID()}));
                        try {
                            handle.start();
                            if (refresh && !issue.refresh()) {
                                return;
                            }
                            IssueCacheUtils.setSeen(issue, true);
                        }
                        finally {
                            UIUtils.setWaitCursor(false);
                            if (handle != null) {
                                handle.finish();
                            }
                        }
                    }
                });
            }
        });
    }

    private static void createIssue() {
        IssueAction.createIssue(null, WindowManager.getDefault().getRegistry().getActivatedNodes());
    }

    public static void createIssue(Repository repository) {
        IssueAction.createIssue(repository, WindowManager.getDefault().getRegistry().getActivatedNodes());
    }

    private static void createIssue(final Repository repository, final Node[] context) {
        final boolean repositoryGiven = repository != null;
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                UIUtils.setWaitCursor(true);
                try {
                    IssueTopComponent tc = new IssueTopComponent();
                    tc.initNewIssue(repository, !repositoryGiven, context);
                    tc.open();
                    tc.requestActive();
                }
                finally {
                    UIUtils.setWaitCursor(false);
                }
            }
        });
    }

    public static void openIssue(File file, String issueId) {
        IssueAction.openIssueIntern(null, file, issueId);
    }

    public static void openIssue(Repository repository, String issueId) {
        IssueAction.openIssueIntern(repository, null, issueId);
    }

    public static void openIssueIntern(final Repository repositoryParam, final File file, final String issueId) {
        assert (issueId != null);
        assert (repositoryParam != null && file == null || repositoryParam == null && file != null);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                UIUtils.setWaitCursor(true);
                final IssueTopComponent tc = IssueTopComponent.find(issueId);
                final boolean tcOpened = tc.isOpened();
                final Issue[] issue = new Issue[]{tc.getIssue()};
                if (issue[0] == null) {
                    tc.initNoIssue(issueId);
                }
                if (!tcOpened) {
                    tc.open();
                }
                tc.requestActive();
                rp.post(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        ProgressHandle handle = null;
                        try {
                            if (issue[0] != null) {
                                handle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(IssueAction.class, (String)"LBL_REFRESING_ISSUE", (Object[])new Object[]{issueId}));
                                handle.start();
                                issue[0].refresh();
                            } else {
                                Repository repository;
                                handle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(IssueAction.class, (String)"LBL_OPENING_ISSUE", (Object[])new Object[]{issueId}));
                                handle.start();
                                if (repositoryParam == null) {
                                    repository = BugtrackingOwnerSupport.getInstance().getRepository(file, issueId, true);
                                    if (repository == null) {
                                        this.handleTC();
                                        return;
                                    }
                                    BugtrackingOwnerSupport.getInstance().setFirmAssociation(file, repository);
                                } else {
                                    repository = repositoryParam;
                                }
                                issue[0] = repository.getIssue(issueId);
                                if (issue[0] == null) {
                                    this.handleTC();
                                    return;
                                }
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        tc.setIssue(issue[0]);
                                    }
                                });
                                IssueCacheUtils.setSeen(issue[0], true);
                            }
                        }
                        finally {
                            if (handle != null) {
                                handle.finish();
                            }
                            UIUtils.setWaitCursor(false);
                        }
                    }

                    public void handleTC() {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (!tcOpened) {
                                    tc.close();
                                }
                            }
                        });
                    }
                });
            }
        });
    }

    public static void closeIssue(final Issue issue) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                IssueTopComponent tc = IssueTopComponent.find(issue);
                if (tc != null) {
                    tc.close();
                }
            }
        });
    }
}

