/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.extrahints;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import org.jrubyparser.ast.HashNode;
import org.jrubyparser.ast.INameNode;
import org.jrubyparser.ast.ListNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.jrubyparser.ast.StrNode;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintSeverity;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.ruby.AstPath;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.hints.infrastructure.RubyAstRule;
import org.netbeans.modules.ruby.hints.infrastructure.RubyRuleContext;
import org.netbeans.modules.ruby.lexer.LexUtilities;
import org.openide.util.NbBundle;

public class DuplicateHashKeys
extends RubyAstRule {
    public boolean appliesTo(RuleContext context) {
        return true;
    }

    public Set<NodeType> getKinds() {
        return Collections.singleton(NodeType.HASHNODE);
    }

    public void run(RubyRuleContext context, List<Hint> result) {
        HashKey key;
        Node keyNode;
        int i;
        Node node = context.node;
        AstPath path = context.path;
        ParserResult info = context.parserResult;
        HashSet<HashKey> keys = new HashSet<HashKey>();
        HashSet<HashKey> duplicateKeys = null;
        HashNode hash = (HashNode)node;
        ListNode list = hash.getListNode();
        List children = list.childNodes();
        int n = children.size();
        for (i = 0; i < n; i += 2) {
            keyNode = (Node)children.get(i);
            key = this.getHashKey(keyNode);
            if (key == null) continue;
            if (keys.contains(key)) {
                if (duplicateKeys == null) {
                    duplicateKeys = new HashSet<HashKey>(5);
                }
                duplicateKeys.add(key);
                continue;
            }
            keys.add(key);
        }
        if (duplicateKeys != null) {
            n = children.size();
            for (i = 0; i < n; i += 2) {
                OffsetRange astRange;
                OffsetRange lexRange;
                keyNode = (Node)children.get(i);
                key = this.getHashKey(keyNode);
                if (key == null || !duplicateKeys.contains(key) || (lexRange = LexUtilities.getLexerOffsets((Parser.Result)info, (OffsetRange)(astRange = AstUtilities.getNameRange((Node)keyNode)))) == null) continue;
                List fixList = Collections.emptyList();
                String displayName = NbBundle.getMessage(DuplicateHashKeys.class, (String)"DuplicateHashName", (Object)key.getValue());
                Hint desc = new Hint((Rule)this, displayName, RubyUtils.getFileObject((Parser.Result)info), lexRange, fixList, 1000);
                result.add(desc);
            }
        }
    }

    private HashKey getHashKey(Node keyNode) {
        NodeType type = keyNode.getNodeType();
        if (type == NodeType.SYMBOLNODE) {
            return new HashKey(((INameNode)keyNode).getName(), type);
        }
        if (type == NodeType.STRNODE) {
            return new HashKey(((StrNode)keyNode).getValue(), type);
        }
        return null;
    }

    public String getId() {
        return "DuplicateHashKeys";
    }

    public String getDisplayName() {
        return NbBundle.getMessage(DuplicateHashKeys.class, (String)"DuplicateHashKeys");
    }

    public String getDescription() {
        return NbBundle.getMessage(DuplicateHashKeys.class, (String)"DuplicateHashKeysDesc");
    }

    public boolean getDefaultEnabled() {
        return true;
    }

    public HintSeverity getDefaultSeverity() {
        return HintSeverity.WARNING;
    }

    public boolean showInTasklist() {
        return true;
    }

    public JComponent getCustomizer(Preferences node) {
        return null;
    }

    private static final class HashKey {
        private final String value;
        private final NodeType type;

        public HashKey(String value, NodeType type) {
            this.value = value;
            this.type = type;
        }

        public NodeType getType() {
            return this.type;
        }

        public String getValue() {
            return this.value;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            HashKey other = (HashKey)obj;
            if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
                return false;
            }
            return this.type == other.type;
        }

        public int hashCode() {
            int hash = 3;
            hash = 53 * hash + (this.value != null ? this.value.hashCode() : 0);
            hash = 53 * hash + (this.type != null ? this.type.hashCode() : 0);
            return hash;
        }
    }
}

