/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.project;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.java.project.classpath.ProjectClassPathModifier;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.ant.AntArtifactQuery;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public final class ClassSource {
    private final String className;
    private final String typeParameters;
    private final Collection<? extends Entry> entries;
    private static final String TYPE_JAR = "jar";
    private static final String TYPE_LIBRARY = "library";
    private static final String TYPE_PROJECT = "project";

    public ClassSource(String className, Entry ... entries) {
        this(className, Arrays.asList(entries));
    }

    public ClassSource(String className, Collection<? extends Entry> entries) {
        this(className, entries, null);
    }

    public ClassSource(String className, Collection<? extends Entry> entries, String typeParameters) {
        this.className = className;
        this.entries = entries;
        this.typeParameters = typeParameters;
    }

    public String getClassName() {
        return this.className;
    }

    public String getTypeParameters() {
        return this.typeParameters;
    }

    public Collection<? extends Entry> getEntries() {
        return this.entries;
    }

    public boolean hasEntries() {
        return !this.entries.isEmpty();
    }

    public List<URL> getClasspath() {
        ArrayList<URL> cp = new ArrayList<URL>();
        for (Entry entry : this.entries) {
            cp.addAll(entry.getClasspath());
        }
        for (URL uRL : cp) {
            assert (uRL.toExternalForm().endsWith("/")) : uRL;
        }
        return cp;
    }

    public boolean addToProjectClassPath(FileObject projectArtifact, String classPathType) throws IOException, UnsupportedOperationException {
        for (Entry entry : this.entries) {
            if (entry.addToProjectClassPath(projectArtifact, classPathType).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public static Entry unpickle(String type, String name) {
        if (type.equals(TYPE_JAR)) {
            return new JarEntry(new File(name));
        }
        if (type.equals(TYPE_LIBRARY)) {
            Library lib;
            int hash = name.indexOf(35);
            if (hash != -1) {
                try {
                    lib = LibraryManager.forLocation((URL)new URL(name.substring(0, hash))).getLibrary(name.substring(hash + 1));
                }
                catch (IllegalArgumentException x) {
                    Exceptions.printStackTrace((Throwable)x);
                    return null;
                }
                catch (MalformedURLException x) {
                    Exceptions.printStackTrace((Throwable)x);
                    return null;
                }
            } else {
                lib = LibraryManager.getDefault().getLibrary(name);
            }
            return lib != null ? new LibraryEntry(lib) : null;
        }
        if (type.equals(TYPE_PROJECT)) {
            File file = new File(name);
            AntArtifact aa = AntArtifactQuery.findArtifactFromFile((File)(file = FileUtil.normalizeFile((File)file)));
            return aa != null ? new ProjectEntry(aa) : null;
        }
        return null;
    }

    private static URL translateURL(URL u) {
        if (FileUtil.isArchiveFile((URL)u)) {
            return FileUtil.getArchiveRoot((URL)u);
        }
        return u;
    }

    public static final class ProjectEntry
    extends Entry {
        private final AntArtifact artifact;

        public ProjectEntry(AntArtifact artifact) {
            assert (artifact != null);
            this.artifact = artifact;
        }

        public AntArtifact getArtifact() {
            return this.artifact;
        }

        @Override
        public List<URL> getClasspath() {
            ArrayList<URL> cp = new ArrayList<URL>();
            for (URI loc : this.artifact.getArtifactLocations()) {
                try {
                    cp.add(ClassSource.translateURL(this.artifact.getScriptLocation().toURI().resolve(loc).normalize().toURL()));
                }
                catch (MalformedURLException x) {
                    assert (false) : x;
                }
            }
            return cp;
        }

        @Override
        public Boolean addToProjectClassPath(FileObject projectArtifact, String classPathType) throws IOException, UnsupportedOperationException {
            if (this.artifact.getProject() != FileOwnerQuery.getOwner((FileObject)projectArtifact)) {
                return ProjectClassPathModifier.addAntArtifacts((AntArtifact[])new AntArtifact[]{this.artifact}, (URI[])this.artifact.getArtifactLocations(), (FileObject)projectArtifact, (String)classPathType);
            }
            return Boolean.FALSE;
        }

        @Override
        public String getDisplayName() {
            Project p = this.artifact.getProject();
            return NbBundle.getMessage(ClassSource.class, (String)"FMT_ProjectSource", (Object)(p != null ? FileUtil.getFileDisplayName((FileObject)p.getProjectDirectory()) : this.artifact.getScriptLocation().getAbsolutePath()));
        }

        @Override
        public String getPicklingType() {
            return ClassSource.TYPE_PROJECT;
        }

        @Override
        public String getPicklingName() {
            if (this.artifact.getArtifactLocations().length > 0) {
                return new File(this.artifact.getScriptLocation().toURI().resolve(this.artifact.getArtifactLocations()[0]).normalize()).getAbsolutePath();
            }
            return "";
        }
    }

    public static final class LibraryEntry
    extends Entry {
        private final Library lib;

        public LibraryEntry(Library lib) {
            assert (lib != null);
            this.lib = lib;
        }

        public Library getLibrary() {
            return this.lib;
        }

        @Override
        public List<URL> getClasspath() {
            return this.lib.getContent("classpath");
        }

        @Override
        public Boolean addToProjectClassPath(FileObject projectArtifact, String classPathType) throws IOException, UnsupportedOperationException {
            return ProjectClassPathModifier.addLibraries((Library[])new Library[]{this.lib}, (FileObject)projectArtifact, (String)classPathType);
        }

        @Override
        public String getDisplayName() {
            return NbBundle.getMessage(ClassSource.class, (String)"FMT_LibrarySource", (Object)this.lib.getDisplayName());
        }

        @Override
        public String getPicklingType() {
            return ClassSource.TYPE_LIBRARY;
        }

        @Override
        public String getPicklingName() {
            LibraryManager mgr = this.lib.getManager();
            if (mgr == LibraryManager.getDefault()) {
                return this.lib.getName();
            }
            return mgr.getLocation() + "#" + this.lib.getName();
        }
    }

    public static final class JarEntry
    extends Entry {
        private final File jar;

        public JarEntry(File jar) {
            assert (jar != null);
            this.jar = jar;
        }

        public File getJar() {
            return this.jar;
        }

        @Override
        public List<URL> getClasspath() {
            try {
                return Collections.singletonList(ClassSource.translateURL(this.jar.toURI().toURL()));
            }
            catch (MalformedURLException x) {
                assert (false) : x;
                return Collections.emptyList();
            }
        }

        @Override
        public Boolean addToProjectClassPath(FileObject projectArtifact, String classPathType) throws IOException, UnsupportedOperationException {
            URL u = this.jar.toURI().toURL();
            FileObject jarFile = FileUtil.toFileObject((File)this.jar);
            if (jarFile == null) {
                return Boolean.FALSE;
            }
            if (FileUtil.isArchiveFile((FileObject)jarFile)) {
                u = FileUtil.getArchiveRoot((URL)u);
            }
            return ProjectClassPathModifier.addRoots((URL[])new URL[]{u}, (FileObject)projectArtifact, (String)classPathType);
        }

        @Override
        public String getDisplayName() {
            return NbBundle.getMessage(ClassSource.class, (String)"FMT_JarSource", (Object)this.jar.getAbsolutePath());
        }

        @Override
        public String getPicklingType() {
            return ClassSource.TYPE_JAR;
        }

        @Override
        public String getPicklingName() {
            return this.jar.getAbsolutePath();
        }
    }

    public static abstract class Entry {
        private Entry() {
        }

        public abstract List<URL> getClasspath();

        public abstract Boolean addToProjectClassPath(FileObject var1, String var2) throws IOException, UnsupportedOperationException;

        public abstract String getDisplayName();

        public abstract String getPicklingType();

        public abstract String getPicklingName();

        public final int hashCode() {
            return ((Object)this.getClasspath()).hashCode();
        }

        public final boolean equals(Object obj) {
            return obj instanceof Entry && ((Object)this.getClasspath()).equals(((Entry)obj).getClasspath());
        }

        public final String toString() {
            return super.toString() + this.getClasspath();
        }
    }
}

