/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.fakepeer;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.SystemColor;
import org.netbeans.modules.form.fakepeer.FakePeer;
import org.netbeans.modules.form.fakepeer.FakePeerSupport;

public class FakePeerContainer
extends Container {
    public FakePeerContainer() {
        this.setFont(FakePeerSupport.getDefaultAWTFont());
    }

    @Override
    public void addNotify() {
        FakePeerSupport.attachFakePeerRecursively(this);
        super.addNotify();
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        FakePeerSupport.attachFakePeer(comp);
        super.addImpl(comp, constraints, index);
    }

    @Override
    public void update(Graphics g) {
    }

    @Override
    public void paint(Graphics g) {
        Dimension sz = this.getSize();
        SystemColor c = SystemColor.control;
        g.setColor(c);
        g.fillRect(0, 0, sz.width, sz.height);
        super.paint(g);
        FakePeerContainer.paintFakePeersRecursively(g, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void paintFakePeersRecursively(Graphics g, Container container) {
        if (!container.isVisible()) {
            return;
        }
        Component[] components = FakePeerSupport.getComponents(container);
        int ncomponents = components.length;
        Rectangle clip = g.getClipBounds();
        for (int i = 0; i < ncomponents; ++i) {
            Graphics cg;
            Rectangle cr;
            Component comp = components[i];
            if (comp != null && comp.getPeer() instanceof FakePeer && comp.isVisible()) {
                cr = comp.getBounds();
                if (clip == null || cr.intersects(clip)) {
                    cg = g.create(cr.x, cr.y, cr.width, cr.height);
                    cg.setFont(comp.getFont());
                    try {
                        comp.getPeer().paint(cg);
                    }
                    finally {
                        cg.dispose();
                    }
                }
            }
            if (!(comp instanceof Container)) continue;
            cr = comp.getBounds();
            if (clip != null && !cr.intersects(clip)) continue;
            cg = g.create(cr.x, cr.y, cr.width, cr.height);
            FakePeerContainer.paintFakePeersRecursively(cg, (Container)comp);
            cg.dispose();
        }
    }
}

