/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.form.FormDataObject;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.GandalfPersistenceManager;
import org.netbeans.modules.form.PersistenceException;
import org.openide.ErrorManager;
import org.openide.util.Lookup;

public abstract class PersistenceManager {
    private static List<PersistenceManager> managers;
    private static List<String> managersByName;

    public abstract boolean canLoadForm(FormDataObject var1) throws PersistenceException;

    public abstract void loadForm(FormDataObject var1, FormModel var2, List<Throwable> var3) throws PersistenceException;

    public abstract void saveForm(FormDataObject var1, FormModel var2, List<Throwable> var3) throws PersistenceException;

    public static void registerManager(PersistenceManager persistenceManager) {
        PersistenceManager.getManagersList().add(persistenceManager);
    }

    public static void unregisterManager(PersistenceManager persistenceManager) {
        PersistenceManager.getManagersList().remove(persistenceManager);
    }

    static void registerManager(String string) {
        PersistenceManager.getManagersNamesList().add(string);
    }

    public static Iterator<PersistenceManager> getManagers() {
        ClassLoader classLoader = null;
        Iterator<String> iterator = PersistenceManager.getManagersNamesList().iterator();
        while (iterator.hasNext()) {
            if (classLoader == null) {
                classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
            }
            String string = iterator.next();
            try {
                PersistenceManager persistenceManager = (PersistenceManager)classLoader.loadClass(string).newInstance();
                PersistenceManager.getManagersList().add(persistenceManager);
            }
            catch (Exception exception) {
                PersistenceManager.notifyError(exception, string);
            }
            catch (LinkageError linkageError) {
                PersistenceManager.notifyError(linkageError, string);
            }
        }
        PersistenceManager.getManagersNamesList().clear();
        return PersistenceManager.getManagersList().iterator();
    }

    private static List<PersistenceManager> getManagersList() {
        if (managers == null) {
            managers = new ArrayList<PersistenceManager>();
            managers.add(new GandalfPersistenceManager());
        }
        return managers;
    }

    private static List<String> getManagersNamesList() {
        if (managersByName == null) {
            managersByName = new ArrayList<String>();
        }
        return managersByName;
    }

    private static void notifyError(Throwable throwable, String string) {
        String string2 = FormUtils.getFormattedBundleString("FMT_ERR_PersistenceManagerInstantiation", new Object[]{string});
        ErrorManager errorManager = ErrorManager.getDefault();
        errorManager.annotate(throwable, string2);
        errorManager.notify(4096, throwable);
    }
}

