/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.localhistory.ui.actions;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Set;
import java.util.logging.Level;
import org.netbeans.modules.localhistory.LocalHistory;
import org.netbeans.modules.localhistory.store.StoreEntry;
import org.netbeans.modules.localhistory.ui.view.ShowLocalHistoryAction;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.spi.VersioningSupport;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class RevertDeletedAction
extends NodeAction {
    public RevertDeletedAction() {
        this.setIcon(null);
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    protected void performAction(final Node[] activatedNodes) {
        LocalHistory.getInstance().getParallelRequestProcessor().post(new Runnable(){

            @Override
            public void run() {
                VCSContext ctx = VCSContext.forNodes((Node[])activatedNodes);
                Set rootSet = ctx.getRootFiles();
                if (rootSet == null || rootSet.size() < 1) {
                    return;
                }
                for (File file : rootSet) {
                    if (VersioningSupport.isFlat((File)file)) {
                        RevertDeletedAction.this.revert(file);
                        continue;
                    }
                    RevertDeletedAction.this.revertRecursively(file);
                }
            }
        });
    }

    private void revertRecursively(File file) {
        File[] files;
        this.revert(file);
        for (File f : files = file.listFiles()) {
            if (!f.isDirectory()) continue;
            this.revertRecursively(f);
        }
    }

    private void revert(File file) {
        StoreEntry[] entries;
        for (StoreEntry se : entries = LocalHistory.getInstance().getLocalHistoryStore().getDeletedFiles(file)) {
            RevertDeletedAction.revert(se);
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        VCSContext ctx = VCSContext.forNodes((Node[])activatedNodes);
        Set rootSet = ctx.getRootFiles();
        if (rootSet == null || rootSet.size() < 1) {
            return false;
        }
        for (File file : rootSet) {
            if (file == null || file.isDirectory()) continue;
            return false;
        }
        return true;
    }

    public String getName() {
        return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"CTL_ShowRevertDeleted");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(ShowLocalHistoryAction.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void revert(StoreEntry se) {
        File file = se.getFile();
        if (file.exists()) {
            if (file.isFile()) {
                LocalHistory.LOG.warning("Skipping revert for file " + file.getAbsolutePath() + " which already exists.");
            }
            LocalHistory.getInstance().getLocalHistoryStore().fileCreate(file, file.lastModified());
        }
        File storeFile = se.getStoreFile();
        InputStream is = null;
        OutputStream os = null;
        try {
            if (!storeFile.isFile()) {
                FileUtil.createFolder((File)file);
            } else {
                FileObject fo = FileUtil.createData((File)file);
                os = RevertDeletedAction.getOutputStream(fo);
                is = se.getStoreFileInputStream();
                FileUtil.copy((InputStream)is, (OutputStream)os);
            }
        }
        catch (Exception e) {
            LocalHistory.LOG.log(Level.SEVERE, null, e);
            return;
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {}
        }
    }

    private static OutputStream getOutputStream(FileObject fo) throws FileAlreadyLockedException, IOException, InterruptedException {
        int retry = 0;
        while (true) {
            try {
                return fo.getOutputStream();
            }
            catch (IOException ioe) {
                if (++retry > 7) {
                    throw ioe;
                }
                Thread.sleep(retry * 30);
                continue;
            }
            break;
        }
    }
}

