/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.composer.actions;

import java.awt.event.ActionEvent;
import javax.swing.Action;
import org.netbeans.modules.mobility.svgcore.composer.AbstractComposerActionFactory;
import org.netbeans.modules.mobility.svgcore.composer.SVGObject;
import org.netbeans.modules.mobility.svgcore.composer.SceneManager;
import org.netbeans.modules.mobility.svgcore.view.svg.AbstractSVGAction;

public final class DeleteActionFactory
extends AbstractComposerActionFactory
implements SceneManager.SelectionListener {
    private final AbstractSVGAction m_deleteAction = new AbstractSVGAction("svg_delete"){

        @Override
        public void actionPerformed(ActionEvent e) {
            SVGObject[] selected = DeleteActionFactory.this.m_sceneMgr.getSelected();
            assert (selected != null) : "No selection, button should be disabled";
            if (selected != null) {
                assert (selected.length > 0);
                assert (selected[0] != null);
                SVGObject deleted = selected[0];
                deleted.repaint();
                DeleteActionFactory.this.m_sceneMgr.deleteObject(deleted);
            }
        }
    };

    public DeleteActionFactory(SceneManager sceneMgr) {
        super(sceneMgr);
        this.m_deleteAction.setEnabled(false);
        sceneMgr.addSelectionListener(this);
    }

    @Override
    public Action[] getMenuActions() {
        return new Action[]{this.m_deleteAction};
    }

    @Override
    public void selectionChanged(SVGObject[] newSelection, SVGObject[] oldSelection, boolean isReadOnly) {
        this.m_deleteAction.setEnabled(newSelection != null && !isReadOnly);
    }

    @Override
    public void updateActionState() {
        this.m_deleteAction.setEnabled(!this.m_sceneMgr.isReadOnly() && this.m_sceneMgr.getSelected() != null);
    }
}

