/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.debug;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.cnd.api.model.CsmFile;

public class DiagnosticUnresolved {
    private Map<String, UnresolvedInfoBase> map = new HashMap<String, UnresolvedInfoBase>();
    private int level;

    public DiagnosticUnresolved(int n) {
        this.level = n;
    }

    private static String glueName(CharSequence[] charSequenceArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < charSequenceArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append("::");
            }
            stringBuilder.append(charSequenceArray[i]);
        }
        return stringBuilder.toString();
    }

    public void onUnresolved(CharSequence[] charSequenceArray, CsmFile csmFile, int n) {
        if (this.level < 1) {
            return;
        }
        String string = DiagnosticUnresolved.glueName(charSequenceArray);
        UnresolvedInfoBase unresolvedInfoBase = this.map.get(string);
        if (unresolvedInfoBase == null) {
            unresolvedInfoBase = this.level == 1 ? new UnresolvedInfoBase(string) : new UnresolvedInfoEx(string);
            this.map.put(string, unresolvedInfoBase);
        }
        unresolvedInfoBase.registerOccurence(csmFile, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpStatictics(String string, boolean bl) throws FileNotFoundException {
        PrintStream printStream = new PrintStream(new FileOutputStream(string, bl), true);
        try {
            this.dumpStatictics(printStream);
        }
        finally {
            printStream.close();
        }
    }

    protected void dumpStatictics(PrintStream printStream) {
        printStream.println("\n**** Unresolved names statistics\n");
        Comparator<UnresolvedInfoBase> comparator = new Comparator<UnresolvedInfoBase>(){

            @Override
            public int compare(UnresolvedInfoBase unresolvedInfoBase, UnresolvedInfoBase unresolvedInfoBase2) {
                if (unresolvedInfoBase == unresolvedInfoBase2) {
                    return 0;
                }
                return unresolvedInfoBase.getCount() > unresolvedInfoBase2.getCount() ? -1 : 1;
            }
        };
        ArrayList<UnresolvedInfoBase> arrayList = new ArrayList<UnresolvedInfoBase>(this.map.values());
        int n = 0;
        Collections.sort(arrayList, comparator);
        for (UnresolvedInfoBase unresolvedInfoBase : arrayList) {
            unresolvedInfoBase.dumpStatistics(printStream);
            n += unresolvedInfoBase.getCount();
        }
        printStream.println("Totally " + n + " unresolved");
    }

    private static class UnresolvedInfoEx
    extends UnresolvedInfoBase {
        private Map<CsmFile, IntArray> files = new HashMap<CsmFile, IntArray>();

        public UnresolvedInfoEx(String string) {
            super(string);
        }

        @Override
        public void registerOccurence(CsmFile csmFile, int n) {
            super.registerOccurence(csmFile, n);
            IntArray intArray = this.files.get(csmFile);
            if (intArray == null) {
                intArray = new IntArray();
                this.files.put(csmFile, intArray);
            }
            intArray.add(n);
        }

        @Override
        public void dumpStatistics(PrintStream printStream) {
            printStream.println(this.getName() + ' ' + this.getCount());
            printStream.println(" By files:");
            Comparator<CsmFile> comparator = new Comparator<CsmFile>(){

                @Override
                public int compare(CsmFile csmFile, CsmFile csmFile2) {
                    if (csmFile == csmFile2) {
                        return 0;
                    }
                    IntArray intArray = (IntArray)UnresolvedInfoEx.this.files.get(csmFile);
                    IntArray intArray2 = (IntArray)UnresolvedInfoEx.this.files.get(csmFile2);
                    return intArray.size() > intArray2.size() ? -1 : 1;
                }
            };
            ArrayList<CsmFile> arrayList = new ArrayList<CsmFile>(this.files.keySet());
            Collections.sort(arrayList, comparator);
            for (CsmFile csmFile : arrayList) {
                IntArray intArray = this.files.get(csmFile);
                int n = intArray == null ? -1 : intArray.size();
                printStream.println("    " + csmFile.getAbsolutePath() + ' ' + n);
            }
        }
    }

    private static class UnresolvedInfoBase {
        private String name;
        private int count;

        public UnresolvedInfoBase(String string) {
            this.name = string;
        }

        public void registerOccurence(CsmFile csmFile, int n) {
            ++this.count;
        }

        public int getCount() {
            return this.count;
        }

        public String getName() {
            return this.name;
        }

        public void dumpStatistics(PrintStream printStream) {
            printStream.println(this.getName() + ' ' + this.getCount());
        }
    }

    private static class IntArray {
        private int[] data;
        private int size;

        public IntArray(int n) {
            this.data = new int[n];
            this.size = 0;
        }

        public IntArray() {
            this(64);
        }

        public int get(int n) {
            return this.data[n];
        }

        public int size() {
            return this.size;
        }

        public void add(int n) {
            if (!this.contains(n)) {
                if (this.size >= this.data.length) {
                    int[] nArray = this.data;
                    this.data = new int[nArray.length + 128];
                }
                this.data[this.size++] = n;
            }
        }

        protected boolean contains(int n) {
            for (int i = 0; i < this.size; ++i) {
                if (this.data[i] != n) continue;
                return true;
            }
            return false;
        }
    }
}

