/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.io.File;
import java.nio.BufferUnderflowException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.cnd.api.model.CsmChangeEvent;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmListeners;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmModelListener;
import org.netbeans.modules.cnd.api.model.CsmModelState;
import org.netbeans.modules.cnd.api.model.CsmProgressAdapter;
import org.netbeans.modules.cnd.api.model.CsmProgressListener;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.services.CsmStandaloneFileProvider;
import org.netbeans.modules.cnd.api.project.DefaultSystemSettings;
import org.netbeans.modules.cnd.api.project.NativeExitStatus;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.project.NativeFileItemSet;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.api.project.NativeProjectItemsListener;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ModelImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.trace.NativeProjectProvider;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.utils.NamedRunnable;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;

public class CsmStandaloneFileProviderImpl
extends CsmStandaloneFileProvider {
    private static final boolean TRACE = Boolean.getBoolean("cnd.standalone.trace");
    private static final Lock lock = new Lock();
    private static final Set<String> toBeRmoved = new HashSet<String>();
    private final CsmModelListener listener = new CsmModelListener(){

        public void projectOpened(CsmProject csmProject) {
        }

        public void projectClosed(CsmProject csmProject) {
        }

        public void modelChanged(CsmChangeEvent csmChangeEvent) {
            for (CsmFile csmFile : csmChangeEvent.getNewFiles()) {
                CsmStandaloneFileProviderImpl.this.clean(csmFile);
            }
            for (CsmFile csmFile : csmChangeEvent.getRemovedFiles()) {
                CsmStandaloneFileProviderImpl.this.onFileRemove(csmFile);
            }
        }
    };
    private final CsmProgressListener progressListener = new CsmProgressAdapter(){

        public void projectLoaded(CsmProject csmProject) {
            CsmStandaloneFileProviderImpl.this.clean((ProjectBase)csmProject);
        }

        public void projectParsingFinished(CsmProject csmProject) {
        }
    };

    public CsmStandaloneFileProviderImpl() {
        CsmListeners.getDefault().addModelListener(this.listener);
        CsmListeners.getDefault().addProgressListener(this.progressListener);
    }

    static CsmStandaloneFileProviderImpl getDefaultImpl() {
        return (CsmStandaloneFileProviderImpl)CsmStandaloneFileProvider.getDefault();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CsmFile getCsmFile(FileObject fileObject) {
        CsmModelState csmModelState = CsmModelAccessor.getModelState();
        if (csmModelState != CsmModelState.ON) {
            if (TRACE) {
                CsmStandaloneFileProviderImpl.trace("model is %s, no extra work for %s", csmModelState, fileObject.getPath());
            }
            return null;
        }
        File file = FileUtil.toFile((FileObject)fileObject);
        if (file == null) {
            return null;
        }
        String string = file.getAbsolutePath();
        ProjectBase projectBase = null;
        Object object = this;
        synchronized (object) {
            CsmFile csmFile = ModelImpl.instance().findFile(string, false);
            if (csmFile != null) {
                if (TRACE) {
                    CsmStandaloneFileProviderImpl.trace("returns file %s", csmFile);
                }
                return csmFile;
            }
            Lock lock = CsmStandaloneFileProviderImpl.lock;
            synchronized (lock) {
                if (toBeRmoved.contains(string)) {
                    return null;
                }
                NativeProject nativeProject = NativeProjectImpl.getNativeProjectImpl(FileUtil.toFile((FileObject)fileObject));
                if (nativeProject != null) {
                    projectBase = ModelImpl.instance().addProject(nativeProject, string, true);
                    if (TRACE) {
                        CsmStandaloneFileProviderImpl.trace("added project %s", projectBase.toString());
                    }
                    projectBase.ensureFilesCreated();
                }
            }
        }
        if (projectBase != null && projectBase.isValid()) {
            try {
                object = projectBase.getFile(file, false);
                if (TRACE) {
                    CsmStandaloneFileProviderImpl.trace("RETURNS STANALONE FILE %s", object);
                }
                return object;
            }
            catch (BufferUnderflowException bufferUnderflowException) {
                DiagnosticExceptoins.register(bufferUnderflowException);
            }
            catch (IllegalStateException illegalStateException) {
                DiagnosticExceptoins.register(illegalStateException);
            }
        }
        return null;
    }

    private void clean(ProjectBase projectBase) {
        if (projectBase.getPlatformProject() instanceof NativeProjectImpl) {
            return;
        }
        if (TRACE) {
            CsmStandaloneFileProviderImpl.trace("checking project %s", projectBase.toString());
        }
        for (CsmProject csmProject : ModelImpl.instance().projects()) {
            if (!(csmProject.getPlatformProject() instanceof NativeProjectImpl)) continue;
            for (CsmFile csmFile : csmProject.getAllFiles()) {
                if (TRACE) {
                    CsmStandaloneFileProviderImpl.trace("\nchecking file %s", csmFile.getAbsolutePath());
                }
                if (projectBase.getFile(((FileImpl)csmFile).getFile(), false) == null) continue;
                this.scheduleProjectRemoval(csmProject);
            }
        }
    }

    private void clean(CsmFile csmFile) {
        if (!(csmFile.getProject().getPlatformProject() instanceof NativeProjectImpl)) {
            this.notifyClosed(csmFile);
        }
    }

    void onFileRemove(CsmFile csmFile) {
        FileObject fileObject = CsmUtilities.getFileObject((CsmFile)csmFile);
        if (fileObject != null && this.isOpen(fileObject)) {
            this.getCsmFile(fileObject);
        }
    }

    private boolean isOpen(FileObject fileObject) {
        try {
            EditorCookie editorCookie;
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            if (dataObject != null && (editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class)) != null) {
                return CsmUtilities.findRecentEditorPaneInEQ((EditorCookie)editorCookie) != null;
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            // empty catch block
        }
        return false;
    }

    public synchronized void notifyClosed(CsmFile csmFile) {
        String string = ((Object)csmFile.getAbsolutePath()).toString();
        for (CsmProject csmProject : ModelImpl.instance().projects()) {
            NativeProjectImpl nativeProjectImpl;
            Object object = csmProject.getPlatformProject();
            if (!(object instanceof NativeProjectImpl) || !(nativeProjectImpl = (NativeProjectImpl)object).getProjectRoot().equals(string)) continue;
            for (CsmFile csmFile2 : csmProject.getAllFiles()) {
                NativeFileItemSet nativeFileItemSet;
                File file = ((FileImpl)csmFile2).getFile();
                DataObject dataObject = NativeProjectProvider.getDataObject(file);
                if (dataObject == null || (nativeFileItemSet = (NativeFileItemSet)dataObject.getLookup().lookup(NativeFileItemSet.class)) == null) continue;
                nativeFileItemSet.remove(nativeProjectImpl.findFileItem(file));
            }
            this.scheduleProjectRemoval(csmProject);
        }
    }

    public boolean isStandalone(CsmFile csmFile) {
        NativeFileItem nativeFileItem;
        return csmFile instanceof FileImpl && (nativeFileItem = ((FileImpl)csmFile).getNativeFileItem()) instanceof NativeFileItemImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleProjectRemoval(final CsmProject csmProject) {
        final String string = ((NativeProject)csmProject.getPlatformProject()).getProjectRoot();
        if (TRACE) {
            CsmStandaloneFileProviderImpl.trace("schedulling removal %s", csmProject.toString());
        }
        Lock lock = CsmStandaloneFileProviderImpl.lock;
        synchronized (lock) {
            toBeRmoved.add(string);
        }
        ModelImpl.instance().enqueueModelTask(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (csmProject.isValid()) {
                    if (TRACE) {
                        CsmStandaloneFileProviderImpl.trace("removing %s", new Object[]{csmProject.toString()});
                    }
                    ProjectBase projectBase = (ProjectBase)csmProject;
                    ModelImpl.instance().closeProjectBase(projectBase, false);
                    Lock lock = lock;
                    synchronized (lock) {
                        toBeRmoved.remove(string);
                    }
                    if (TRACE) {
                        CsmStandaloneFileProviderImpl.trace("removed %s", new Object[]{csmProject.toString()});
                    }
                }
            }
        }, "Standalone project removal.");
    }

    private static void trace(String string, Object ... objectArray) {
        assert (TRACE) : "Should not be called if TRACE is off!";
        System.err.printf("### Standalone provider:  %s\n", String.format(string, objectArray));
    }

    private static final class NativeFileItemImpl
    implements NativeFileItem {
        private final File file;
        private final NativeProjectImpl project;
        private final NativeFileItem.Language lang;

        public NativeFileItemImpl(File file, NativeProjectImpl nativeProjectImpl, NativeFileItem.Language language) {
            this.project = nativeProjectImpl;
            this.file = file;
            this.lang = language;
        }

        public NativeProject getNativeProject() {
            return this.project;
        }

        public File getFile() {
            return this.file;
        }

        public List<String> getSystemIncludePaths() {
            List<String> list = this.project.getSystemIncludePaths();
            return this.project.pathsRelCurFile ? this.toAbsolute(list) : list;
        }

        public List<String> getUserIncludePaths() {
            List<String> list = this.project.getUserIncludePaths();
            return this.project.pathsRelCurFile ? this.toAbsolute(list) : list;
        }

        private List<String> toAbsolute(List<String> list) {
            File file = this.file.getParentFile();
            ArrayList<String> arrayList = new ArrayList<String>(list.size());
            for (String string : list) {
                File file2 = new File(string);
                if (file2.isAbsolute()) {
                    arrayList.add(string);
                    continue;
                }
                file2 = new File(file, string);
                arrayList.add(file2.getAbsolutePath());
            }
            return arrayList;
        }

        public List<String> getSystemMacroDefinitions() {
            return this.project.getSystemMacroDefinitions();
        }

        public List<String> getUserMacroDefinitions() {
            return this.project.getUserMacroDefinitions();
        }

        public NativeFileItem.Language getLanguage() {
            return this.lang;
        }

        public NativeFileItem.LanguageFlavor getLanguageFlavor() {
            return NativeFileItem.LanguageFlavor.GENERIC;
        }

        public boolean isExcluded() {
            return false;
        }

        public String toString() {
            return "SA " + this.file + " " + System.identityHashCode(this) + " " + this.lang + " from project:" + this.project;
        }
    }

    private static final class NativeProjectImpl
    implements NativeProject {
        private final List<String> sysIncludes;
        private final List<String> usrIncludes;
        private final List<String> sysMacros;
        private final List<String> usrMacros;
        private final List<NativeFileItem> files = new ArrayList<NativeFileItem>();
        private final String projectRoot;
        private boolean pathsRelCurFile;
        private List<NativeProjectItemsListener> listeners = new ArrayList<NativeProjectItemsListener>();
        private final Object listenersLock = new Lock();

        static NativeProject getNativeProjectImpl(File file) {
            DataObject dataObject = NativeProjectProvider.getDataObject(file);
            if (dataObject == null) {
                return null;
            }
            NativeFileItemSet nativeFileItemSet = (NativeFileItemSet)dataObject.getLookup().lookup(NativeFileItemSet.class);
            if (nativeFileItemSet == null || !nativeFileItemSet.isEmpty()) {
                return null;
            }
            ModelImpl modelImpl = ModelImpl.instance();
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            ArrayList<String> arrayList3 = new ArrayList<String>();
            ArrayList<String> arrayList4 = new ArrayList<String>();
            NativeFileItem.Language language = NativeProjectProvider.getLanguage(file, dataObject);
            NativeProject nativeProject = null;
            for (CsmProject csmProject : modelImpl.projects()) {
                Object object = csmProject.getPlatformProject();
                if (!(object instanceof NativeProject)) continue;
                NativeProject nativeProject2 = (NativeProject)object;
                if (file.getAbsolutePath().startsWith(nativeProject2.getProjectRoot())) {
                    nativeProject = nativeProject2;
                    break;
                }
                for (String string : nativeProject2.getSourceRoots()) {
                    if (!file.getAbsolutePath().startsWith(string)) continue;
                    nativeProject = nativeProject2;
                    break;
                }
                if (nativeProject == null) continue;
                break;
            }
            if (nativeProject == null) {
                arrayList.addAll(DefaultSystemSettings.getDefault().getSystemIncludes(language));
                arrayList3.addAll(DefaultSystemSettings.getDefault().getSystemMacros(language));
            } else {
                if (ModelImpl.instance().isProjectDiabled(nativeProject)) {
                    return null;
                }
                arrayList.addAll(nativeProject.getSystemIncludePaths());
                arrayList3.addAll(nativeProject.getSystemMacroDefinitions());
                arrayList2.addAll(nativeProject.getUserIncludePaths());
                arrayList4.addAll(nativeProject.getUserMacroDefinitions());
            }
            NativeProjectImpl nativeProjectImpl = new NativeProjectImpl(file, arrayList, arrayList2, arrayList3, arrayList4);
            super.addFile(file);
            nativeFileItemSet.add(nativeProjectImpl.findFileItem(file));
            return nativeProjectImpl;
        }

        private NativeProjectImpl(File file, List<String> list, List<String> list2, List<String> list3, List<String> list4) {
            this(file.getAbsolutePath(), list, list2, list3, list4, false);
        }

        private NativeProjectImpl(String string, List<String> list, List<String> list2, List<String> list3, List<String> list4, boolean bl) {
            this.projectRoot = string;
            this.pathsRelCurFile = bl;
            this.sysIncludes = this.createIncludes(list);
            this.usrIncludes = this.createIncludes(list2);
            this.sysMacros = new ArrayList<String>(list3);
            this.usrMacros = new ArrayList<String>(list4);
        }

        private List<String> createIncludes(List<String> list) {
            if (this.pathsRelCurFile) {
                return new ArrayList<String>(list);
            }
            ArrayList<String> arrayList = new ArrayList<String>(list.size());
            for (String string : list) {
                File file = new File(string);
                arrayList.add(file.getAbsolutePath());
            }
            return arrayList;
        }

        private void addFile(File file) {
            DataObject dataObject = NativeProjectProvider.getDataObject(file);
            NativeFileItem.Language language = NativeProjectProvider.getLanguage(file, dataObject);
            NativeFileItemImpl nativeFileItemImpl = new NativeFileItemImpl(file, this, language);
            this.files.add(nativeFileItemImpl);
        }

        public Object getProject() {
            return null;
        }

        public List<String> getSourceRoots() {
            return Collections.emptyList();
        }

        public String getProjectRoot() {
            return this.projectRoot;
        }

        public String getProjectDisplayName() {
            return this.getProjectRoot();
        }

        public List<NativeFileItem> getAllFiles() {
            return Collections.unmodifiableList(this.files);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addProjectItemsListener(NativeProjectItemsListener nativeProjectItemsListener) {
            Object object = this.listenersLock;
            synchronized (object) {
                this.listeners.add(nativeProjectItemsListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeProjectItemsListener(NativeProjectItemsListener nativeProjectItemsListener) {
            Object object = this.listenersLock;
            synchronized (object) {
                this.listeners.remove(nativeProjectItemsListener);
            }
        }

        public NativeFileItem findFileItem(File file) {
            for (NativeFileItem nativeFileItem : this.files) {
                if (!nativeFileItem.getFile().equals(file)) continue;
                return nativeFileItem;
            }
            return null;
        }

        public List<String> getSystemIncludePaths() {
            return this.sysIncludes;
        }

        public List<String> getUserIncludePaths() {
            return this.usrIncludes;
        }

        public List<String> getSystemMacroDefinitions() {
            return this.sysMacros;
        }

        public List<String> getUserMacroDefinitions() {
            return this.usrMacros;
        }

        public List<NativeProject> getDependences() {
            return Collections.emptyList();
        }

        public void runOnProjectReadiness(NamedRunnable namedRunnable) {
            namedRunnable.run();
        }

        public NativeExitStatus execute(String string, String[] stringArray, String ... stringArray2) {
            return null;
        }

        public String getPlatformName() {
            return null;
        }

        public final String toString() {
            return "SA " + this.projectRoot + ' ' + this.getClass().getName() + " @" + this.hashCode() + ":" + System.identityHashCode(this);
        }

        private static final class Lock {
            private Lock() {
            }
        }
    }

    private static final class Lock {
        private Lock() {
        }
    }
}

