/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projectimport.eclipse.core;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.projectimport.eclipse.core.EclipseProject;
import org.netbeans.modules.projectimport.eclipse.core.ImportProblemsPanel;
import org.netbeans.modules.projectimport.eclipse.core.ImportProjectAction;
import org.netbeans.modules.projectimport.eclipse.core.RequiredProjectsPanel;
import org.netbeans.modules.projectimport.eclipse.core.UpdateProjectAction;
import org.netbeans.modules.projectimport.eclipse.core.UpgradableProject;
import org.netbeans.modules.projectimport.eclipse.core.WorkspaceFactory;
import org.netbeans.modules.projectimport.eclipse.core.wizard.ProjectSelectionPanel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class UpdateAllProjects {
    private static final Logger LOG = Logger.getLogger(UpdateAllProjects.class.getName());

    private List<UpgradableProject> getListOfUpdatableProjects() {
        ArrayList<UpgradableProject> projs = new ArrayList<UpgradableProject>();
        for (Project p : OpenProjects.getDefault().getOpenProjects()) {
            UpgradableProject up = (UpgradableProject)p.getLookup().lookup(UpgradableProject.class);
            if (up == null || !up.isCreatedFromEclipse()) continue;
            projs.add(up);
        }
        return projs;
    }

    private boolean ensureProjectsReachable(List<UpgradableProject> ups, boolean silent) {
        HashMap<String, String> resolvedEntries = new HashMap<String, String>();
        for (UpgradableProject up : ups) {
            if (up.isEclipseProjectReachable()) continue;
            if (silent) {
                LOG.info("eclipse link is broken for project: " + up.getProject().getProjectDirectory());
                return false;
            }
            if (up.updateBrokenEclipseReference(resolvedEntries)) continue;
            return false;
        }
        return true;
    }

    private Boolean resolveNewRequiredProjects(List<UpgradableProject> ups, boolean silent, List<String> importProblems, List<Project> createdProjects) throws IOException {
        HashMap<File, ProjectsAndDestination> workspaceProjectsMap = new HashMap<File, ProjectsAndDestination>();
        HashSet<File> workspaces = new HashSet<File>();
        for (UpgradableProject upgradableProject : ups) {
            if (upgradableProject.getWorkspace() == null) continue;
            workspaces.add(upgradableProject.getWorkspace().getDirectory());
        }
        for (File file : workspaces) {
            ProjectsAndDestination projAndDest = new ProjectsAndDestination();
            for (UpgradableProject up : ups) {
                if (up.getWorkspace() == null || !up.getWorkspace().getDirectory().equals(file)) continue;
                EclipseProject ep = up.getEclipseProject();
                File nbProjectFolder = FileUtil.toFile((FileObject)up.getProject().getProjectDirectory());
                File baseDestination = null;
                if (!nbProjectFolder.equals(ep.getDirectory())) {
                    baseDestination = nbProjectFolder.getParentFile();
                }
                projAndDest.dest = baseDestination;
                Set<EclipseProject> requiredProjs = ProjectSelectionPanel.getFlattenedRequiredProjects(Collections.singleton(ep));
                for (EclipseProject requiredEP : requiredProjs) {
                    File destination;
                    File file2 = destination = baseDestination == null ? requiredEP.getDirectory() : new File(baseDestination, requiredEP.getDirectory().getName());
                    if (projAndDest.eps.contains(requiredEP) || this.findNetBeansProject(destination, requiredEP)) continue;
                    projAndDest.eps.add(requiredEP);
                }
            }
            if (projAndDest.eps.size() <= 0) continue;
            workspaceProjectsMap.put(file, projAndDest);
        }
        if (workspaceProjectsMap.values().size() == 0) {
            return Boolean.FALSE;
        }
        if (workspaceProjectsMap.values().size() > 0 && silent) {
            return null;
        }
        if (!RequiredProjectsPanel.showConfirmation(workspaceProjectsMap.values())) {
            return null;
        }
        for (Map.Entry entry : workspaceProjectsMap.entrySet()) {
            ImportProjectAction.performImport(ProjectSelectionPanel.getFlattenedProjects(((ProjectsAndDestination)entry.getValue()).eps), ((ProjectsAndDestination)entry.getValue()).dest == null ? null : ((ProjectsAndDestination)entry.getValue()).dest.getPath(), null, ((ProjectsAndDestination)entry.getValue()).eps.size(), false, false, true, importProblems, createdProjects);
        }
        return Boolean.TRUE;
    }

    private boolean findNetBeansProject(File destination, EclipseProject requiredProject) throws IOException {
        for (Project p : OpenProjects.getDefault().getOpenProjects()) {
            if (!requiredProject.getName().equals(((ProjectInformation)p.getLookup().lookup(ProjectInformation.class)).getDisplayName())) continue;
            return true;
        }
        if (!destination.exists()) {
            return false;
        }
        return ProjectManager.getDefault().findProject(FileUtil.toFileObject((File)destination)) != null;
    }

    private boolean updateExistingProjects(List<UpgradableProject> ups, List<String> importProblems, boolean silent) throws IOException {
        boolean changed = false;
        boolean deepTest = !silent;
        for (UpgradableProject up : ups) {
            if (up.isUpToDate(deepTest)) continue;
            ArrayList<String> issues = new ArrayList<String>();
            changed = true;
            up.update(issues);
            if (issues.size() <= 0) continue;
            importProblems.add(NbBundle.getMessage(UpdateAllProjects.class, (String)"MSG_ProjectUpdateIssues", (Object)up.getEclipseProject().getName()));
            for (String s : issues) {
                importProblems.add(" " + s);
            }
        }
        return changed;
    }

    public void update(boolean silent) {
        LOG.fine("Eclipse resynchronize started (" + silent + ")");
        WorkspaceFactory.getInstance().resetCache();
        ArrayList<String> importProblems = new ArrayList<String>();
        List<UpgradableProject> projs = this.getListOfUpdatableProjects();
        if (projs.size() == 0 && !silent) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(UpdateProjectAction.class, (String)"UpdateProjectAction.nothing-to-synch")));
            return;
        }
        if (!this.ensureProjectsReachable(projs, silent)) {
            return;
        }
        try {
            Boolean res = this.resolveNewRequiredProjects(projs, silent, importProblems, null);
            if (res == null) {
                return;
            }
            boolean change = this.updateExistingProjects(projs, importProblems, silent);
            if (!change && res.equals(Boolean.FALSE) && !silent) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(UpdateProjectAction.class, (String)"UpdateProjectAction.already-in-synch")));
            }
        }
        catch (IOException ex) {
            LOG.log(Level.SEVERE, "synchronization with Eclipse failed", ex);
            importProblems.add(NbBundle.getMessage(UpdateAllProjects.class, (String)"MSG_UpdateFailed", (Object)ex.getMessage()));
        }
        if (importProblems.size() > 0) {
            importProblems.add(0, NbBundle.getMessage(UpdateProjectAction.class, (String)"UpdateProjectAction.problems-occurred-2"));
        }
        ImportProblemsPanel.showReport(NbBundle.getMessage(UpdateProjectAction.class, (String)"UpdateProjectAction.update-issues"), importProblems);
    }

    static class ProjectsAndDestination {
        private Set<EclipseProject> eps = new HashSet<EclipseProject>();
        private File dest;

        public File getDestination() {
            return this.dest;
        }

        public Set<EclipseProject> getEclipseProjects() {
            return this.eps;
        }
    }
}

