/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.codegen;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.rest.codegen.ClientStubsGenerator;
import org.netbeans.modules.websvc.rest.codegen.model.ClientStubModel;
import org.netbeans.modules.websvc.rest.support.ZipUtil;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class JMakiRestWidgetGenerator
extends ClientStubsGenerator {
    public static final String RESOURCES = "resources";
    public static final String TEMPLATES = "templates";
    public static final String DOJO = "dojo";
    public static final String RDJ = "rdj";
    public static final String DATA = "data";
    public static final String WIDGET = "widget";
    public static final String TABLE = "table";
    public static final String STORE = "Store";
    public static final String JSP = "jsp";
    public static final String PHP = "php";
    public static final String RHTML = "rhtml";
    public static final String EJS = "ejs";
    public static final String LIBS = "libs";
    public static final String DJD43 = "djd43";
    public static final String JMAKI_DOJO = "jmaki-dojo";
    public static final String JMAKI_COMP_LIB = "jmakicomplib";
    public static final String DOJO_RESTSTORE = "RestStore";
    public static final String DOJO_COLLECTIONSTORE = "CollectionStore";
    public static final String DOJO_RESOURCESTABLE = "ResourcesTable";
    public static final String DOJO_TESTRESOURCESTABLE = "TestResourcesTable";
    public static final String DOJO_SUPPORT = "Support";
    public static final String DOJO_RESTSTORE_TEMPLATE = "Templates/WebServices/DojoRestStore.js";
    public static final String DOJO_COLLECTIONSTORE_TEMPLATE = "Templates/WebServices/DojoCollectionStore.js";
    public static final String DOJO_RESOURCESTABLE_TEMPLATE = "Templates/WebServices/DojoResourcesTable.js";
    public static final String DOJO_SUPPORT_TEMPLATE = "Templates/WebServices/DojoSupport.js";
    public static final String DOJO_TESTRESOURCESTABLE_TEMPLATE = "Templates/WebServices/DojoTestResourcesTable.html";
    public static final String JMAKI_README = "Readme";
    public static final String JMAKI_COMPONENT = "component";
    public static final String JMAKI_TESTRESOURCESTABLE = "TestResourcesTable";
    public static final String JMAKI_RESOURCESTABLE_SRC = "JmakiResourcesTable";
    public static final String JMAKI_RESOURCESTABLEUP_SRC = "JmakiResourcesTableUp";
    public static final String JMAKI_RESOURCESTABLEDOWN_SRC = "JmakiResourcesTableDown";
    public static final String JMAKI_RESOURCESTABLE_DEST = "rtable";
    public static final String JMAKI_RESOURCESTABLEUP_DEST = "rtableUp";
    public static final String JMAKI_RESOURCESTABLEDOWN_DEST = "rtableDown";
    public static final String JMAKI_README_TEMPLATE = "Templates/WebServices/JmakiReadme.html";
    public static final String JMAKI_COMPONENTCSS_TEMPLATE = "Templates/WebServices/JmakiComponent.css";
    public static final String JMAKI_COMPONENTHTM_TEMPLATE = "Templates/WebServices/JmakiComponent.htm";
    public static final String JMAKI_COMPONENTJS_TEMPLATE = "Templates/WebServices/JmakiComponent.js";
    public static final String JMAKI_RESTBUNDLE_TEMPLATE = "Templates/WebServices/JmakiRestBundle.properties";
    public static final String JMAKI_TEMPLATESBUNDLE_TEMPLATE = "Templates/WebServices/JmakiTemplatesBundle.properties";
    public static final String JMAKI_TEMPLATESEJS_TEMPLATE = "Templates/WebServices/JmakiTemplates.ejs";
    public static final String JMAKI_TEMPLATESJSP_TEMPLATE = "Templates/WebServices/JmakiTemplates.jsp";
    public static final String JMAKI_TEMPLATESPHP_TEMPLATE = "Templates/WebServices/JmakiTemplates.php";
    public static final String JMAKI_TEMPLATESRHTML_TEMPLATE = "Templates/WebServices/JmakiTemplates.rhtml";
    public static final String JMAKI_TESTRESOURCESTABLE_TEMPLATE = "Templates/WebServices/JmakiTestResourcesTable.jsp";
    public static final String JMAKI_WIDGETJSON_TEMPLATE = "Templates/WebServices/JmakiWidget.json";
    private FileObject resourcesDir = this.createFolder(this.getRootFolder(), "resources");
    private FileObject dojoDir = this.createFolder(this.resourcesDir, "dojo");
    private FileObject rdjDir;
    private FileObject rjsDir;
    private FileObject templatesDir;
    private String includeJs = "";
    private String libsJs = "";
    private String resourcesDojo = "";
    private String requireDojo = "";
    protected String dojoResSelList = "";
    protected String jmakiResSelList = "";
    protected String jmakiResTagList = "";
    private FileObject restDir = this.createFolder(this.dojoDir, "rest");

    public JMakiRestWidgetGenerator(FileObject fileObject, String string, Project project, boolean bl, boolean bl2) throws IOException {
        super(fileObject, string, project, bl2);
        this.rdjDir = this.createFolder(this.restDir, RDJ);
        this.templatesDir = this.createFolder(this.getRootFolder(), TEMPLATES);
        this.setStubFolder(this.createFolder(this.restDir, "rjs"));
    }

    @Override
    public Set<FileObject> generate(ProgressHandle progressHandle) throws IOException {
        FileObject fileObject;
        File file;
        if (this.getProject() == null) {
            throw new IOException("Project parameter cannot be null for jMaki REST widget generator.");
        }
        super.generate(progressHandle);
        List<ClientStubModel.Resource> list = this.getModel().getResources();
        this.includeJs = "    rdj.includeJS('../rjs/" + this.getProjectName().toLowerCase() + "/" + this.getProjectName() + "." + "js" + "');\n";
        this.libsJs = "                   '../rjs/" + this.getProjectName().toLowerCase() + "/" + this.getProjectName() + "." + "js" + "',\n";
        this.resourcesDojo = "";
        this.requireDojo = "";
        for (ClientStubModel.Resource object2 : list) {
            this.includeJs = this.includeJs + "    rdj.includeJS('../rjs/" + this.getProjectName().toLowerCase() + "/" + object2.getName() + "." + "js" + "');\n";
            this.libsJs = this.libsJs + "                   '../rjs/" + this.getProjectName().toLowerCase() + "/" + object2.getName() + "." + "js" + "',\n";
            if (!object2.isContainer()) continue;
            this.resourcesDojo = this.resourcesDojo + "                   '../rdj/data/" + object2.getName() + STORE + "." + "js" + "',\n";
            this.requireDojo = this.requireDojo + "djd43.require(\"rdj.data." + object2.getName() + STORE + "\");\n";
        }
        this.initDojo(this.getProject(), list);
        this.initJmaki(this.getProject(), list);
        for (ClientStubModel.Resource resource : list) {
            if (progressHandle != null) {
                this.reportProgress(NbBundle.getMessage(JMakiRestWidgetGenerator.class, (String)"MSG_GeneratingClass", (Object)resource.getName(), (Object)"js"));
            }
            new ResourceDojoComponents(resource, this.rdjDir).generate();
            new ResourceJmakiComponent(resource, this.restDir).generate();
            file = new File(FileUtil.toFile((FileObject)this.templatesDir), DOJO + File.separator + "rest");
            FileUtil.createFolder((File)file);
            new ResourceJmakiTemplate(resource, FileUtil.toFileObject((File)file)).generate();
        }
        HashSet hashSet = new HashSet();
        if (progressHandle != null) {
            this.reportProgress(NbBundle.getMessage(JMakiRestWidgetGenerator.class, (String)"MSG_CopyLibs", (Object)DJD43, (Object)"js"));
        }
        this.copyDojoLibs();
        if (progressHandle != null) {
            this.reportProgress(NbBundle.getMessage(JMakiRestWidgetGenerator.class, (String)"MSG_GeneratingZip", (Object)this.getProjectName(), (Object)"zip"));
        }
        File file2 = FileUtil.toFile((FileObject)this.resourcesDir.getParent().getParent());
        file = FileUtil.toFile((FileObject)this.dojoDir.getFileObject(RESOURCES));
        File file3 = new File(file2, this.getProjectName() + ".zip");
        String[] stringArray = new String[]{FileUtil.toFile((FileObject)this.restDir).getAbsolutePath(), FileUtil.toFile((FileObject)this.templatesDir).getAbsolutePath(), FileUtil.toFile((FileObject)this.resourcesDir.getParent()).getAbsolutePath() + File.separator + "Bundle" + "." + "properties", file.getAbsolutePath()};
        String[] stringArray2 = new String[]{File.separator + RESOURCES + File.separator + DOJO, "", "", File.separator + RESOURCES + File.separator + DOJO};
        ZipUtil zipUtil = new ZipUtil();
        zipUtil.zip(file3, stringArray, stringArray2);
        FileObject fileObject2 = this.restDir.getFileObject("TestResourcesTable", JSP);
        if (fileObject2 != null) {
            hashSet.add(fileObject2);
        }
        if ((fileObject = this.restDir.getFileObject(JMAKI_README, "txt")) != null) {
            hashSet.add(fileObject);
        }
        return hashSet;
    }

    private void copyDojoLibs() throws FileNotFoundException, IOException {
        String string = System.getProperty("netbeans.user");
        if (string == null || string.length() == 0) {
            throw new RuntimeException("Cannot locate netbeans user folder.");
        }
        File file = new File(string);
        if (!file.exists()) {
            throw new RuntimeException("NetBeans user folder (" + file.getPath() + ") does not exist.");
        }
        File file2 = new File(file, JMAKI_COMP_LIB);
        if (!file2.exists()) {
            throw new RuntimeException("Cannot find jMaki component folder (" + file2 + ").");
        }
        File file3 = this.findDojoLibrary(file2);
        if (file3 != null) {
            ZipUtil zipUtil = new ZipUtil();
            zipUtil.addFilter(new ZipUtil.UnZipFilter(){

                @Override
                public boolean allow(ZipEntry zipEntry) {
                    return zipEntry.getName().startsWith("resources/dojo/resources/libs") || zipEntry.getName().startsWith(JMakiRestWidgetGenerator.RESOURCES + File.separator + JMakiRestWidgetGenerator.DOJO + File.separator + JMakiRestWidgetGenerator.RESOURCES + File.separator + JMakiRestWidgetGenerator.LIBS);
                }
            });
            zipUtil.unzip(new FileInputStream(file3), this.resourcesDir.getParent(), this.canOverwrite());
        } else {
            File file4 = new File(file2, RESOURCES + File.separator + DOJO + File.separator + RESOURCES);
            File file5 = FileUtil.toFile((FileObject)this.dojoDir);
            FileSystem fileSystem = FileUtil.toFileObject((File)file5).getFileSystem();
            this.copyDirectory(fileSystem, file4, file5);
        }
        if (this.dojoDir.getFileObject(RESOURCES) == null) {
            throw new IOException("Copying dojo libs from :" + file2.getAbsolutePath() + " to " + this.resourcesDir.getParent() + " failed.");
        }
    }

    private File findDojoLibrary(File file) {
        File file2 = null;
        FilenameFilter filenameFilter = new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string != null && string.startsWith(JMakiRestWidgetGenerator.JMAKI_DOJO) && string.endsWith(".zip");
            }
        };
        File[] fileArray = file.listFiles(filenameFilter);
        if (fileArray != null && fileArray.length > 0) {
            file2 = fileArray[0];
        }
        return file2;
    }

    private void initDojo(Project project, List<ClientStubModel.Resource> list) throws IOException {
        ClientStubsGenerator.TokenReplacer tokenReplacer = new ClientStubsGenerator.TokenReplacer();
        tokenReplacer.addToken("TTL_DojoResources_Stubs", NbBundle.getMessage(JMakiRestWidgetGenerator.class, (String)"TTL_DojoResources_Stubs"));
        tokenReplacer.addToken("MSG_Readme", NbBundle.getMessage(JMakiRestWidgetGenerator.class, (String)"MSG_Readme"));
        tokenReplacer.addToken("MSG_TestPage", NbBundle.getMessage(JMakiRestWidgetGenerator.class, (String)"MSG_TestPage"));
        tokenReplacer.addToken("MSG_SelectResource", NbBundle.getMessage(JMakiRestWidgetGenerator.class, (String)"MSG_SelectResource"));
        tokenReplacer.addToken("__BASE_URL__", this.getBaseUrl());
        tokenReplacer.addToken("__FILE_ENCODING__", this.getBaseEncoding().name());
        this.createFolder(this.rdjDir, DATA);
        FileObject fileObject = this.createFolder(this.rdjDir, WIDGET);
        ClientStubModel.Resource resource = null;
        for (ClientStubModel.Resource resource2 : list) {
            if (!resource2.isContainer()) continue;
            resource = resource2;
            break;
        }
        this.dojoResSelList = this.createDojoResourceSelectList(list);
        this.jmakiResSelList = this.createJmakiResourceSelectList(list);
        this.jmakiResTagList = this.createJmakiResourceTagList(list);
        this.createDataObjectFromTemplate(DOJO_RESOURCESTABLE_TEMPLATE, fileObject, DOJO_RESOURCESTABLE, "js", this.canOverwrite());
        FileObject fileObject2 = this.createDataObjectFromTemplate(DOJO_SUPPORT_TEMPLATE, this.rdjDir, DOJO_SUPPORT, "js", false);
        if (resource != null) {
            new ResourceDojoComponents(resource, this.rdjDir).replaceTokens(fileObject2);
        }
        fileObject2 = this.createDataObjectFromTemplate(DOJO_TESTRESOURCESTABLE_TEMPLATE, this.rdjDir, "TestResourcesTable", "html", false);
        tokenReplacer.replaceTokens(fileObject2);
        if (resource != null) {
            new ResourceDojoComponents(resource, this.rdjDir).replaceTokens(fileObject2);
        }
    }

    private void initJmaki(Project project, List<ClientStubModel.Resource> list) throws IOException {
        ClientStubsGenerator.TokenReplacer tokenReplacer = new ClientStubsGenerator.TokenReplacer();
        tokenReplacer.addToken("TTL_JMakiWidget_Stubs", NbBundle.getMessage(JMakiRestWidgetGenerator.class, (String)"TTL_JMakiWidget_Stubs"));
        tokenReplacer.addToken("MSG_Readme", NbBundle.getMessage(JMakiRestWidgetGenerator.class, (String)"MSG_Readme"));
        tokenReplacer.addToken("MSG_TestPage", NbBundle.getMessage(JMakiRestWidgetGenerator.class, (String)"MSG_TestPage"));
        tokenReplacer.addToken("MSG_JMaki_Readme_Content", NbBundle.getMessage(JMakiRestWidgetGenerator.class, (String)"MSG_JMaki_Readme_Content"));
        tokenReplacer.addToken("__FILE_ENCODING__", this.getBaseEncoding().name());
        FileObject fileObject = this.createDataObjectFromTemplate(JMAKI_README_TEMPLATE, this.restDir, JMAKI_README, "html", this.canOverwrite());
        tokenReplacer.replaceTokens(fileObject);
        this.createDataObjectFromTemplate(JMAKI_RESTBUNDLE_TEMPLATE, this.getRootFolder(), "Bundle", "properties", this.canOverwrite());
        ClientStubModel.Resource resource = null;
        for (ClientStubModel.Resource resource2 : list) {
            if (!resource2.isContainer()) continue;
            resource = resource2;
            break;
        }
        fileObject = this.createDataObjectFromTemplate(JMAKI_TESTRESOURCESTABLE_TEMPLATE, this.restDir, "TestResourcesTable", JSP, false);
        tokenReplacer.replaceTokens(fileObject);
        if (resource != null) {
            new ResourceDojoComponents(resource, this.restDir).replaceTokens(fileObject);
        }
    }

    protected String createDojoResourceSelectList(List<ClientStubModel.Resource> list) {
        String string = "";
        for (ClientStubModel.Resource resource : list) {
            if (!resource.isContainer()) continue;
            string = string + "            <option value='" + this.getBaseUrl() + "/" + resource.getRepresentation().getRoot().getName() + "/;" + resource.getName() + "'>" + resource.getName() + "</option>\n";
        }
        return string;
    }

    protected String createJmakiResourceSelectList(List<ClientStubModel.Resource> list) {
        String string = "";
        for (ClientStubModel.Resource resource : list) {
            if (!resource.isContainer()) continue;
            string = string + "                <option value='" + resource.getName() + "' <%=p.equals(\"" + resource.getName() + "\")?\"selected\":\"\"%>>" + resource.getName() + "</option>\n";
        }
        return string;
    }

    protected String createJmakiResourceTagList(List<ClientStubModel.Resource> list) {
        String string = "";
        int n = 0;
        String string2 = "<!-- If using cross-domain proxy uncomment tag below and comment above line -->\n";
        for (ClientStubModel.Resource resource : list) {
            if (!resource.isContainer()) continue;
            String string3 = resource.getName();
            String string4 = resource.getRepresentation().getRoot().getName();
            if (n++ == 0) {
                string = string + "         <% if(p.equals(\"" + string3 + "\")) {%>\n" + "            <a:widget name=\"dojo.rest." + string4 + "table\" service=\"" + this.getBaseUrl() + "/" + string4 + "/\" />\n" + "            " + string2 + "<!-- &lt;a:widget name=\"dojo.rest." + string4 + "table\" service=\"" + this.getBaseUrl() + "/" + string4 + "/\" args=\"proxy=" + this.getProxyUrl() + "\"/>-->\n";
                continue;
            }
            string = string + "         <% } else if(p.equals(\"" + string3 + "\")) {%>\n" + "            <a:widget name=\"dojo.rest." + string4 + "table\" service=\"" + this.getBaseUrl() + "/" + string4 + "/\" />\n" + "            " + string2 + "<!-- &lt;a:widget name=\"dojo.rest." + string4 + "table\" service=\"" + this.getBaseUrl() + "/" + string4 + "/\" args=\"proxy=" + this.getProxyUrl() + "\"/>-->\n";
        }
        string = string + "<% }%>";
        return string;
    }

    public class ResourceJmakiTemplate
    extends ResourceDojoComponents {
        public ResourceJmakiTemplate(ClientStubModel.Resource resource, FileObject fileObject) {
            super(resource, fileObject);
        }

        @Override
        public FileObject generate() throws IOException {
            if (!this.r.isContainer()) {
                return null;
            }
            String string = this.r.getRepresentation().getRoot().getName() + JMakiRestWidgetGenerator.TABLE;
            FileObject fileObject = JMakiRestWidgetGenerator.this.createFolder(this.getFolder(), string);
            FileObject fileObject2 = JMakiRestWidgetGenerator.this.createDataObjectFromTemplate(JMakiRestWidgetGenerator.JMAKI_TEMPLATESBUNDLE_TEMPLATE, fileObject, "Bundle", "properties", JMakiRestWidgetGenerator.this.canOverwrite());
            this.replaceTokens(fileObject2);
            fileObject2 = JMakiRestWidgetGenerator.this.createDataObjectFromTemplate(JMakiRestWidgetGenerator.JMAKI_TEMPLATESJSP_TEMPLATE, fileObject, string, JMakiRestWidgetGenerator.JSP, JMakiRestWidgetGenerator.this.canOverwrite());
            this.replaceTokens(fileObject2);
            fileObject2 = JMakiRestWidgetGenerator.this.createDataObjectFromTemplate(JMakiRestWidgetGenerator.JMAKI_TEMPLATESPHP_TEMPLATE, fileObject, string, JMakiRestWidgetGenerator.PHP, JMakiRestWidgetGenerator.this.canOverwrite());
            this.replaceTokens(fileObject2);
            fileObject2 = JMakiRestWidgetGenerator.this.createDataObjectFromTemplate(JMakiRestWidgetGenerator.JMAKI_TEMPLATESEJS_TEMPLATE, fileObject, string, JMakiRestWidgetGenerator.EJS, JMakiRestWidgetGenerator.this.canOverwrite());
            this.replaceTokens(fileObject2);
            fileObject2 = JMakiRestWidgetGenerator.this.createDataObjectFromTemplate(JMakiRestWidgetGenerator.JMAKI_TEMPLATESRHTML_TEMPLATE, fileObject, string, JMakiRestWidgetGenerator.RHTML, JMakiRestWidgetGenerator.this.canOverwrite());
            this.replaceTokens(fileObject2);
            return this.getFolder();
        }
    }

    public class ResourceJmakiComponent
    extends ResourceDojoComponents {
        public ResourceJmakiComponent(ClientStubModel.Resource resource, FileObject fileObject) {
            super(resource, fileObject);
        }

        @Override
        public FileObject generate() throws IOException {
            if (!this.r.isContainer()) {
                return null;
            }
            String string = this.r.getRepresentation().getRoot().getName();
            FileObject fileObject = JMakiRestWidgetGenerator.this.createFolder(this.getFolder(), string + JMakiRestWidgetGenerator.TABLE);
            JMakiRestWidgetGenerator.this.createDataObjectFromTemplate(JMakiRestWidgetGenerator.JMAKI_COMPONENTCSS_TEMPLATE, fileObject, JMakiRestWidgetGenerator.JMAKI_COMPONENT, "css", JMakiRestWidgetGenerator.this.canOverwrite());
            JMakiRestWidgetGenerator.this.createDataObjectFromTemplate(JMakiRestWidgetGenerator.JMAKI_COMPONENTHTM_TEMPLATE, fileObject, JMakiRestWidgetGenerator.JMAKI_COMPONENT, "htm", JMakiRestWidgetGenerator.this.canOverwrite());
            FileObject fileObject2 = JMakiRestWidgetGenerator.this.createDataObjectFromTemplate(JMakiRestWidgetGenerator.JMAKI_COMPONENTJS_TEMPLATE, fileObject, JMakiRestWidgetGenerator.JMAKI_COMPONENT, "js", JMakiRestWidgetGenerator.this.canOverwrite());
            this.replaceTokens(fileObject2);
            fileObject2 = JMakiRestWidgetGenerator.this.createDataObjectFromTemplate(JMakiRestWidgetGenerator.JMAKI_WIDGETJSON_TEMPLATE, fileObject, JMakiRestWidgetGenerator.WIDGET, "json", JMakiRestWidgetGenerator.this.canOverwrite());
            this.replaceTokens(fileObject2);
            FileObject fileObject3 = JMakiRestWidgetGenerator.this.createFolder(fileObject, "images");
            File file = FileUtil.toFile((FileObject)fileObject3);
            JMakiRestWidgetGenerator.this.copyFile("JmakiResourcesTable.gif", new File(file, "rtable.gif"));
            JMakiRestWidgetGenerator.this.copyFile("JmakiResourcesTableUp.gif", new File(file, "rtableUp.gif"));
            JMakiRestWidgetGenerator.this.copyFile("JmakiResourcesTableDown.gif", new File(file, "rtableDown.gif"));
            return this.getFolder();
        }
    }

    public class ResourceDojoComponents
    extends ClientStubsGenerator.ResourceJavaScript {
        public ResourceDojoComponents(ClientStubModel.Resource resource, FileObject fileObject) {
            super(resource, fileObject);
            if (resource.isContainer() && this.root != null && this.root.getChildren().size() > 0) {
                String string = resource.getName();
                String string2 = this.root.getName();
                String string3 = this.root.getChildren().get(0).getName();
                String string4 = string3.substring(0, 1).toUpperCase() + string3.substring(1);
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("//__INCLUDE_JS_SCRIPTS__", JMakiRestWidgetGenerator.this.includeJs + "\n//__INCLUDE_JS_SCRIPTS__");
                hashMap.put("//__LIBS_JS_SCRIPTS__", JMakiRestWidgetGenerator.this.libsJs + "\n//__LIBS_JS_SCRIPTS__");
                hashMap.put("//__RESOURCES_DOJO_SCRIPTS__", JMakiRestWidgetGenerator.this.resourcesDojo + "\n//__RESOURCES_DOJO_SCRIPTS__");
                hashMap.put("//__REQUIRE_DOJO_SCRIPTS__", JMakiRestWidgetGenerator.this.requireDojo + "\n//__REQUIRE_DOJO_SCRIPTS__");
                hashMap.put("__CONTAINER_NAME__", string);
                hashMap.put("__CONTAINER_PATH_NAME__", string2);
                hashMap.put("__CONTAINER_ITEM_NAME__", string4);
                hashMap.put("__CONTAINER_ITEM_PATH_NAME__", string3);
                hashMap.put("__PROJECT_NAME__", JMakiRestWidgetGenerator.this.getProjectName());
                hashMap.put("<!-- __DOJO_RESOURCE_SELECT_LIST__ -->", JMakiRestWidgetGenerator.this.dojoResSelList + "\n<!-- __DOJO_RESOURCE_SELECT_LIST__ -->");
                hashMap.put("<!-- __JMAKI_RESOURCE_SELECT_LIST__ -->", JMakiRestWidgetGenerator.this.jmakiResSelList + "\n<!-- __JMAKI_RESOURCE_SELECT_LIST__ -->");
                hashMap.put("<!-- __JMAKI_RESOURCE_TAG_LIST__ -->", JMakiRestWidgetGenerator.this.jmakiResTagList + "\n<!-- __JMAKI_RESOURCE_TAG_LIST__ -->");
                hashMap.put("TTL_JMakiWidget_Stubs", NbBundle.getMessage(JMakiRestWidgetGenerator.class, (String)"TTL_JMakiWidget_Stubs"));
                hashMap.put("__BASE_URL__", JMakiRestWidgetGenerator.this.getBaseUrl());
                this.setTokens(hashMap);
            }
        }

        @Override
        public FileObject generate() throws IOException {
            if (!this.r.isContainer()) {
                return null;
            }
            String string = this.r.getName();
            FileObject fileObject = this.getFolder().getFileObject(JMakiRestWidgetGenerator.DATA);
            FileObject fileObject2 = JMakiRestWidgetGenerator.this.createDataObjectFromTemplate(JMakiRestWidgetGenerator.DOJO_COLLECTIONSTORE_TEMPLATE, fileObject, string + JMakiRestWidgetGenerator.STORE, "js", JMakiRestWidgetGenerator.this.canOverwrite());
            this.replaceTokens(fileObject2);
            return JMakiRestWidgetGenerator.this.rdjDir;
        }
    }
}

