/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.sfs.index;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Formatter;
import java.util.Iterator;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.netbeans.modules.cnd.repository.sfs.index.ChunkInfo;
import org.netbeans.modules.cnd.repository.sfs.index.FileIndex;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.support.KeyFactory;
import org.netbeans.modules.cnd.repository.support.SelfPersistent;
import org.netbeans.modules.cnd.repository.util.LongHashMap;
import org.netbeans.modules.cnd.repository.util.SlicedLongHashMap;

public class CompactFileIndex
implements FileIndex,
SelfPersistent {
    private static final int shift = 37;
    private static final long mask = 0x1FFFFFFFFFL;
    private static final int DEFAULT_SLICE_CAPACITY;
    private static final int DEFAULT_SLICE_COUNT;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final SlicedLongHashMap<Key> map = new SlicedLongHashMap(DEFAULT_SLICE_COUNT, DEFAULT_SLICE_CAPACITY);

    public CompactFileIndex() {
    }

    public CompactFileIndex(DataInput input) throws IOException {
        assert (input != null);
        int size = input.readInt();
        for (int i = 0; i < size; ++i) {
            this.map.put(KeyFactory.getDefaultFactory().readKey(input), input.readLong());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        try {
            this.lock.readLock().lock();
            int n = this.map.size();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Key> keySet() {
        try {
            this.lock.readLock().lock();
            Collection<Key> collection = this.map.keySet();
            return collection;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public Iterator<Key> getKeySetIterator() {
        return this.keySet().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int remove(Key key) {
        long data = Long.MIN_VALUE;
        try {
            this.lock.writeLock().lock();
            data = this.map.remove(key);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return data == Long.MIN_VALUE ? 0 : CompactFileIndex.convertToSize(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int put(Key key, long offset, int size) {
        long data = Long.MIN_VALUE;
        try {
            this.lock.writeLock().lock();
            data = this.map.put(key, CompactFileIndex.convertToLongData(offset, size));
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return data == Long.MIN_VALUE ? 0 : CompactFileIndex.convertToSize(data);
    }

    private static long convertToLongData(long offset, int size) {
        assert (offset <= 0x1FFFFFFFFFL) : "Offset " + offset + " is too large";
        assert (size < 0x8000000) : "Size " + size + " is too large";
        long data = size;
        data <<= 37;
        return data |= offset & 0x1FFFFFFFFFL;
    }

    private static final int convertToSize(long data) {
        int size = (int)(data >>> 37);
        return size;
    }

    private static final long convertToOffset(long data) {
        long offset = data & 0x1FFFFFFFFFL;
        return offset;
    }

    @Override
    public ChunkInfo get(Key key) {
        long entry = this.map.get(key);
        return entry == Long.MIN_VALUE ? null : new LongChunkInfo(entry);
    }

    public void write(DataOutput output) throws IOException {
        Collection<LongHashMap.Entry<Key>> collection = this.map.entrySet();
        output.writeInt(collection.size());
        for (LongHashMap.Entry<Key> entry : collection) {
            KeyFactory.getDefaultFactory().writeKey(entry.getKey(), output);
            output.writeLong(entry.getValue());
        }
    }

    static {
        int nrProc = Runtime.getRuntime().availableProcessors();
        if (nrProc <= 4) {
            DEFAULT_SLICE_COUNT = 32;
            DEFAULT_SLICE_CAPACITY = 512;
        } else {
            DEFAULT_SLICE_COUNT = 128;
            DEFAULT_SLICE_CAPACITY = 128;
        }
    }

    private static class LongChunkInfo
    implements ChunkInfo,
    Comparable,
    SelfPersistent {
        long entry;

        public LongChunkInfo(long entry) {
            this.entry = entry;
        }

        @Override
        public int getSize() {
            return CompactFileIndex.convertToSize(this.entry);
        }

        @Override
        public long getOffset() {
            return CompactFileIndex.convertToOffset(this.entry);
        }

        public int compareTo(Object o) {
            if (o instanceof ChunkInfo) {
                return this.getOffset() < ((ChunkInfo)o).getOffset() ? -1 : 1;
            }
            return 1;
        }

        @Override
        public void setOffset(long offset) {
            this.entry = CompactFileIndex.convertToLongData(offset, this.getSize());
        }

        public String toString() {
            Formatter f = new Formatter();
            long offset = this.getOffset();
            f.format("ChunkInfo [offset=%d (%H) size=%d long=%d]", offset, offset, this.getSize(), this.entry);
            return f.toString();
        }

        public void write(DataOutput output) throws IOException {
            output.writeLong(this.entry);
        }
    }
}

