/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.highlight.semantic.options;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Set;
import java.util.prefs.Preferences;
import org.openide.util.NbPreferences;
import org.openide.util.WeakSet;

public final class SemanticHighlightingOptions {
    private final Preferences preferences = NbPreferences.forModule(SemanticHighlightingOptions.class);
    private static final String ENABLE_MARK_OCCURRENCES = "EnableMarkOccurrences";
    private static final String KEEP_MARKS = "KeepMarks";
    public static final boolean SEMANTIC_ADVANCED = Boolean.getBoolean("cnd.semantic.advanced");
    private final Set<PropertyChangeListener> listeners = new WeakSet();
    private final Object lock = new Object();

    private SemanticHighlightingOptions() {
    }

    public static SemanticHighlightingOptions instance() {
        return Instantiator.instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        Object object = this.lock;
        synchronized (object) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        Object object = this.lock;
        synchronized (object) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyChange(PropertyChangeEvent evt) {
        Object object = this.lock;
        synchronized (object) {
            for (PropertyChangeListener listener : this.listeners) {
                listener.propertyChange(evt);
            }
        }
    }

    private boolean getOption(String key, boolean defaultValue) {
        return this.preferences.getBoolean(key, defaultValue);
    }

    private void setOption(String key, boolean value) {
        this.preferences.putBoolean(key, value);
    }

    public boolean getEnableMarkOccurrences() {
        return this.getOption(ENABLE_MARK_OCCURRENCES, true);
    }

    public void setEnableMarkOccurrences(boolean value) {
        this.setOption(ENABLE_MARK_OCCURRENCES, value);
    }

    public boolean getKeepMarks() {
        return this.getOption(KEEP_MARKS, true);
    }

    public void setKeepMarks(boolean value) {
        this.setOption(KEEP_MARKS, value);
    }

    private static class Instantiator {
        public static SemanticHighlightingOptions instance = new SemanticHighlightingOptions();

        private Instantiator() {
        }
    }
}

